/* $Id: $
 *
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/

#include "sph_dictionary.h"

/*-----------------------------------------------------------------------------
 Defines
 -----------------------------------------------------------------------------*/

/** Invalid key token */
#define DICT_INVALID_KEY    ((char*)-1)

#define NVALS 2000

#define VALUE "salut"

/*----------------------------------------------------------------------------*/
/**
 @brief    Unit tests
 */
/*----------------------------------------------------------------------------*/

int main(void)
{
    sph_dictionary    *    d ;
    int            i ;
    char        cval[90] ;

    cpl_test_init(PACKAGE_BUGREPORT, CPL_MSG_WARNING);

    /* Insert tests below */

    /* Allocate sph_dictionary */
    cpl_msg_info(cpl_func, "allocating...");
    d = sph_dictionary_new(0);
    cpl_test_nonnull(d);
    
    /* Set values in sph_dictionary */
    cpl_msg_info(cpl_func, "setting %d values...", NVALS);
    for (i=0 ; i<NVALS ; i++) {
        sprintf(cval, "%04d", i);
        cpl_test_zero(sph_dictionary_set(d, cval, VALUE));
    }

    cpl_msg_info(cpl_func, "getting %d values...", NVALS);
    for (i=0 ; i<NVALS ; i++) {
        const char * val;
        sprintf(cval, "%04d", i);
        val = sph_dictionary_get(d, cval, DICT_INVALID_KEY);
        cpl_test_noneq_ptr(val, DICT_INVALID_KEY);
        cpl_test_eq_string(val, VALUE);
    }

    cpl_msg_info(cpl_func, "unsetting %d values...", NVALS);
    for (i=0 ; i<NVALS ; i++) {
        sprintf(cval, "%04d", i);
        sph_dictionary_unset(d, cval);
    }
    cpl_test_zero(d->n);

    cpl_msg_info(cpl_func, "deallocating...");
    sph_dictionary_del(d);

    return cpl_test_end(0);
}
