from edps import classification_rule

from . import ifs_rules as rules

########################
# CLASSIFICATION RULES #
########################
# raw data classification: cls_
# product classification rules have the same name as the PRO.CATG
# static calibration classification: _class
# technical and test data
cls_ifs_technical = classification_rule("IFS_TECHNICAL_RAW", rules.is_ifs_technical)
cls_ifs_test = classification_rule("IFS_TEST_RAW", rules.is_ifs_test)
# dark
cls_ifs_dark = classification_rule("IFS_DARK_RAW", rules.is_ifs_dark)
IFS_MASTER_DARK = classification_rule("IFS_MASTER_DARK")
IFS_STATIC_BADPIXELMAP = classification_rule("IFS_STATIC_BADPIXELMAP")

# instrument & sky background
cls_ifs_ins_bg = classification_rule("IFS_CAL_BACKGROUND_RAW", rules.is_ifs_ins_bg)
cls_ifs_sky_bg = classification_rule("IFS_CAL_BACKGROUND_RAW", rules.is_ifs_sky_bg)
IFS_CAL_BACKGROUND = classification_rule("IFS_CAL_BACKGROUND")

# detmon flat field for ron and gain determination
cls_ifs_flat_RonGain = classification_rule("IFS_GAIN_RAW", rules.is_ifs_flat_rongain)

# detector flat field 
cls_ifs_det_flat_nb1 = classification_rule("IFS_DETECTOR_FLAT_FIELD_RAW", rules.is_ifs_dflat_nb1)
IFS_MASTER_DFF_LONG1 = classification_rule("IFS_MASTER_DFF_LONG1")
cls_ifs_det_flat_nb2 = classification_rule("IFS_DETECTOR_FLAT_FIELD_RAW", rules.is_ifs_dflat_nb2)
IFS_MASTER_DFF_LONG2 = classification_rule("IFS_MASTER_DFF_LONG2")
cls_ifs_det_flat_nb3 = classification_rule("IFS_DETECTOR_FLAT_FIELD_RAW", rules.is_ifs_dflat_nb3)
IFS_MASTER_DFF_LONG3 = classification_rule("IFS_MASTER_DFF_LONG3")
cls_ifs_det_flat_nb4 = classification_rule("IFS_DETECTOR_FLAT_FIELD_RAW", rules.is_ifs_dflat_nb4)
IFS_MASTER_DFF_LONG4 = classification_rule("IFS_MASTER_DFF_LONG4")
cls_ifs_det_flat_bb = classification_rule("IFS_DETECTOR_FLAT_FIELD_RAW", rules.is_ifs_dflat_bb)
IFS_MASTER_DFF_LONGBB = classification_rule("IFS_MASTER_DFF_LONGBB")
IFS_LARGE_SCALE_FLAT = classification_rule("IFS_LARGE_SCALE_FLAT")  # BB only
# produced by all det flats
IFS_PREAMP_FLAT = classification_rule("IFS_PREAMP_FLAT")
IFS_NON_LINEAR_PIXELMAP = classification_rule("IFS_NON_LINEAR_PIXELMAP")

# spectra positions
cls_ifs_specpos = classification_rule("IFS_SPECPOS_RAW", rules.is_ifs_specpos)
IFS_SPECPOS = classification_rule("IFS_SPECPOS")

# wavelength calibration
cls_ifs_wavecal = classification_rule("IFS_WAVECALIB_RAW", rules.is_ifs_wavecalib)
IFS_WAVECALIB = classification_rule("IFS_WAVECALIB")

# detector flat field 
cls_ifs_ins_flat = classification_rule("IFS_FLAT_FIELD_RAW", rules.is_ifs_ins_flat)
IFS_IFU_FLAT_FIELD = classification_rule("IFS_IFU_FLAT_FIELD")
IFS_INSTRUMENT_FLAT_FIELD = classification_rule("IFS_INSTRUMENT_FLAT_FIELD")

# distortion
cls_ifs_distortion = classification_rule("IFS_DISTORTION_MAP_RAW", rules.is_ifs_distortion)
IFS_DISTORTION_MAP = classification_rule("IFS_DISTORTION_MAP")

# flux cal
cls_ifs_standard_flux = classification_rule("IFS_SCIENCE_DR_RAW", rules.is_ifs_standard_flux)

# astrometry
cls_ifs_standard_astrometry = classification_rule("IFS_SCIENCE_DR_RAW", rules.is_ifs_standard_astrometry)

# science object center 
cls_ifs_coronagraph_center = classification_rule("IFS_SCIENCE_DR_RAW", rules.is_ifs_coronagraph_center)
IFS_SCIENCE_DR = classification_rule("IFS_SCIENCE_DR")

# science object flux 
cls_ifs_science_flux = classification_rule("IFS_SCIENCE_DR_RAW", rules.is_ifs_science_flux)

# science object center 
cls_ifs_science_object = classification_rule("IFS_SCIENCE_DR_RAW", rules.is_ifs_science_object)

# static calibrations
IFS_POINT_PATTERN = classification_rule("IFS_POINT_PATTERN")
