from . import sphere_keywords as kwd
from .sphere_rules import is_calib, is_technical, is_test, is_sphere

# grouping keywords
grpkwd_ifs_dark = [
    kwd.det_read_curname,
    kwd.det_seq1_dit,
    kwd.det_ndit,
    kwd.tpl_start
]
grpkwd_ifs_bg = [
    kwd.det_read_curname,
    kwd.det_seq1_dit,
    kwd.det_ndit,
    kwd.ins4_opti13_name,
    kwd.ins4_filt2_name,
    kwd.tpl_start
]
grpkwd_ifs_flat_rongain = [
    kwd.det_read_curname,
    kwd.tpl_start
]
grpkwd_ifs_flat_dflat = [
    kwd.ins2_opti2_name,
    kwd.tpl_start
]
# wavecal, spos, ifu_flat, distortion, std_flux
grpkwd_ifs_ifu_cal = [
    kwd.ins2_opti2_name,
    kwd.tpl_start
]
grpkwd_ifs_astrometry = [
    kwd.ins2_opti2_name,
    kwd.ins4_drot2_mode,
    kwd.tpl_start
]
grpkwd_ifs_science_ctr = [
    kwd.dpr_type,
    kwd.arcfile
]
grpkwd_ifs_science_obj = [
    kwd.dpr_type,
    kwd.obs_id,
    kwd.ins4_filt2_name,
    kwd.ins2_opti2_name,
    kwd.ins4_drot2_mode,
    kwd.tpl_start
]

# setup keywords
setupkwd_ifs_dark = [
    kwd.det_read_curname,
    kwd.det_ndit,
    kwd.det_seq1_dit
]
setupkwd_ifs_bg = [
    kwd.det_read_curname,
    kwd.det_seq1_dit,
    kwd.det_ndit,
    kwd.ins4_opti13_name,
    kwd.ins4_filt2_name
]
setupkwd_ifs_flat_rongain = [
    kwd.det_read_curname
]
setupkwd_ifs_flat_dflat = [
    kwd.ins2_opti2_name
]
setupkwd_ifs_ifu_cal = [
    kwd.ins2_opti2_name,
    kwd.det_read_curname
]
setupkwd_ifs_science = [
    kwd.ins2_opti2_name,
    kwd.ins4_filt2_name,
    kwd.ins4_drot2_mode
]

# match keywords
matchkwd_ifs_dark = [
    kwd.det_read_curname,
    kwd.det_seq1_dit
]
matchkwd_ifs_ins_bg = [
    kwd.det_read_curname,
    kwd.det_seq1_dit,
    kwd.ins4_opti13_name,
    kwd.ins4_filt2_name
]
matchkwd_ifs_sky_bg = [
    kwd.obs_start,
    kwd.det_seq1_dit,
    kwd.ins2_opti2_name
]
# SPOS, WAVECAL, DFLAT, IFU_FLAT, DISTORTION
matchkwd_ifs_ifu_cal = [
    kwd.ins2_opti2_name
]
matchkwd_ifs_science_flx_ctr = [
    kwd.obs_start,
    kwd.ins2_opti2_name
]


def is_ifs(f):
    return is_sphere(f) and f[kwd.seq_arm] == "IFS"


def is_ifs_technical(f):
    return is_technical(f) and is_ifs(f)


def is_ifs_test(f):
    return is_test(f) and is_ifs(f)


def is_ifs_calib(f):
    return is_ifs(f) and is_calib(f)


def is_ifs_img_calib(f):
    return is_ifs(f) and is_calib(f) and f[kwd.dpr_tech] == "IMAGE"


def is_ifs_ifu_calib(f):
    return is_ifs(f) and is_calib(f) and f[kwd.dpr_tech] == "IFU"


def is_ifs_science(f):
    return is_ifs(f) and f[kwd.dpr_catg] == "SCIENCE" and f[kwd.dpr_tech] in ["IFU", "IFU,SAM"]


# calibrations
def is_ifs_dark(f):
    return is_ifs_img_calib(f) and f[kwd.dpr_type] == "DARK"


def is_ifs_ins_bg(f):
    return is_ifs_img_calib(f) and f[kwd.dpr_type] == "DARK,BACKGROUND"


def is_ifs_sky_bg(f):
    return is_ifs(f) and f[kwd.dpr_type] == "SKY" and f[kwd.dpr_tech] in ["IFU", "IFU,SAM"]


def is_ifs_flat_rongain(f):
    return is_ifs_img_calib(f) and f[kwd.dpr_type] == "FLAT,LAMP,RONGAIN"


def is_ifs_dflat_nb1(f):
    return is_ifs_img_calib(f) and f[kwd.dpr_type] == "FLAT,LAMP" and f[kwd.ins2_lamp1_name] == "Calib Lamp 1" \
        and f[kwd.ins2_comb_ifs] in ["CAL_NB1_1_YJH", "CAL_NB1_1_YJ"]


def is_ifs_dflat_nb2(f):
    return is_ifs_img_calib(f) and f[kwd.dpr_type] == "FLAT,LAMP" and f[kwd.ins2_lamp2_name] == "Calib Lamp 2" \
        and f[kwd.ins2_comb_ifs] in ["CAL_NB2_1_YJH", "CAL_NB2_1_YJ"]


def is_ifs_dflat_nb3(f):
    return is_ifs_img_calib(f) and f[kwd.dpr_type] == "FLAT,LAMP" and f[kwd.ins2_lamp3_name] == "Calib Lamp 3" \
        and f[kwd.ins2_comb_ifs] in ["CAL_NB3_1_YJH", "CAL_NB3_1_YJ"]


def is_ifs_dflat_nb4(f):
    return is_ifs_img_calib(f) and f[kwd.dpr_type] == "FLAT,LAMP" and f[kwd.ins2_lamp4_name] == "Calib Lamp 4" \
        and f[kwd.ins2_comb_ifs] == "CAL_NB4_2_YJH"


def is_ifs_dflat_bb(f):
    return is_ifs_img_calib(f) and f[kwd.dpr_type] == "FLAT,LAMP" and f[kwd.ins2_lamp5_name] == "Calib Lamp 5" \
        and f[kwd.ins2_comb_ifs] in ["CAL_BB_2_YJH", "CAL_BB_2_YJ"]


def is_ifs_specpos(f):
    return is_ifs_ifu_calib(f) and f[kwd.dpr_type] == "SPECPOS,LAMP"


def is_ifs_wavecalib(f):
    return is_ifs_ifu_calib(f) and f[kwd.dpr_type] == "WAVE,LAMP"


def is_ifs_ins_flat(f):
    return is_ifs_ifu_calib(f) and f[kwd.dpr_type] == "FLAT,LAMP"


def is_ifs_distortion(f):
    return is_ifs_ifu_calib(f) and f[kwd.dpr_type] == "LAMP,DISTORT"


def is_ifs_standard_flux(f):
    return is_ifs_ifu_calib(f) and f[kwd.dpr_type] == "STD,FLUX"


def is_ifs_standard_astrometry(f):
    return is_ifs_ifu_calib(f) and f[kwd.dpr_type] == "OBJECT,ASTROMETRY"


def is_ifs_coronagraph_center(f):
    return is_ifs_science(f) and f[kwd.dpr_type] == "OBJECT,CENTER"


def is_ifs_science_flux(f):
    return is_ifs_science(f) and f[kwd.dpr_type] == "OBJECT,FLUX"


def is_ifs_science_object(f):
    return is_ifs_science(f) and f[kwd.dpr_type] == "OBJECT"

# ################  Association rules   ######################################################################
# ##  -  first, e.g.  ref=trigger (e.g. science)                                                           ###
# ##  -  second, e.g.  f=file to associate (e.g. calibration)                                              ###
# ############################################################################################################
