from edps import (
    data_source,
    RelativeTimeRange,
    SAME_NIGHT,
    ONE_DAY,
    ONE_WEEK,
    ONE_MONTH,
    QUARTERLY,
    UNLIMITED,
    IN_THE_PAST,
)

from . import sphere_keywords as kwd
from .irdis_classification import *
from .sphere_rules import TEN_DAYS

######################
#     DATA SOURCES   #
######################
# Imaging

ird_raw_dark_img = (data_source("IRD_DARK_RAW")
                    .with_classification_rule(cls_ird_dark)
                    # .with_classification_rule(cls_ird_acq_dark)
                    .with_setup_keywords(rules.setupkwd_ird_dark)
                    .with_grouping_keywords(rules.grpkwd_ird_dark)
                    .with_match_keywords(rules.matchkwd_ird_dark, time_range=RelativeTimeRange(-1.5, 1.5), level=0)
                    .with_match_keywords(rules.matchkwd_ird_dark, time_range=TEN_DAYS, level=1)
                    .build())

ird_raw_ins_bg = (data_source("IRD_INS_BG_RAW")
                  .with_classification_rule(cls_ird_ins_bg)
                  .with_setup_keywords(rules.setupkwd_ird_bg)
                  .with_grouping_keywords(rules.grpkwd_ird_bg)
                  .with_match_keywords(rules.matchkwd_ird_ins_bg, time_range=RelativeTimeRange(-1.5, 1.5), level=0)
                  .with_match_keywords(rules.matchkwd_ird_ins_bg, time_range=TEN_DAYS, level=1)
                  .build())

ird_raw_sky_bg = (data_source("IRD_SKY_BG_RAW")
                  .with_classification_rule(cls_ird_sky_bg)
                  .with_setup_keywords(rules.setupkwd_ird_bg)
                  .with_grouping_keywords(rules.grpkwd_ird_bg)
                  .with_match_keywords(rules.matchkwd_ird_sky_bg, time_range=SAME_NIGHT, level=0)
                  .build())

ird_raw_flat = (data_source("IRD_FLAT_FIELD_RAW")
                .with_classification_rule(cls_ird_flat)
                .with_classification_rule(cls_ird_flat_pol_qc1)
                # .with_classification_rule(cls_ird_acq_flat)
                .with_setup_keywords(rules.setupkwd_ird_flat)
                .with_grouping_keywords(rules.grpkwd_ird_flat)
                .with_min_group_size(2)
                .with_match_keywords(rules.matchkwd_ird_flat, time_range=TEN_DAYS, level=0)
                .with_match_keywords(rules.matchkwd_ird_flat, time_range=UNLIMITED, level=1)
                .build())

ird_raw_gain = (data_source("IRD_GAIN_RAW")
                .with_classification_rule(cls_ird_FlatRongain)
                .with_setup_keywords(rules.setupkwd_ird_flat)
                .with_grouping_keywords(rules.grpkwd_ird_flat)
                .with_min_group_size(4)
                .build())

ird_raw_distortion = (data_source("IRD_DISTORTION_MAP_RAW")
                      .with_classification_rule(cls_ird_distortion)
                      .with_setup_keywords(rules.setupkwd_ird_distortion)
                      .with_grouping_keywords(rules.grpkwd_ird_distortion)
                      .with_match_function(rules.assoc_ird_distortion, time_range=ONE_WEEK, level=0)
                      .with_match_function(rules.assoc_ird_distortion, time_range=TEN_DAYS, level=1)
                      .build())

ird_raw_standard_flux = (data_source("IRD_SCIENCE_IMAGING_RAW")
                         .with_classification_rule(cls_ird_standard_flux)
                         .with_setup_keywords(rules.setupkwd_ird_img_science)
                         .with_grouping_keywords([kwd.arcfile])
                         .with_match_keywords(rules.matchkwd_ird_img_std_phot, time_range=ONE_MONTH, level=0)
                         .build())

ird_raw_img_standard_astrometry = (data_source("RAW_SCIENCE_DBI_IMG")
                                   .with_classification_rule(cls_ird_standard_astrometry)
                                   .with_setup_keywords(rules.setupkwd_ird_img_science)
                                   .with_grouping_keywords([kwd.arcfile])
                                   .with_match_keywords(rules.matchkwd_ird_img_std_phot, time_range=QUARTERLY,
                                                        level=0)
                                   .build())

ird_raw_science_flux_img = (data_source("IRD_SCIENCE_DBI_RAW")
                            .with_classification_rule(cls_ird_science_flux_img)
                            .with_setup_keywords(rules.setupkwd_ird_img_science)
                            .with_grouping_keywords(rules.grpkwd_ird_img_science_obj_flx)
                            .with_match_keywords(rules.matchkwd_ird_img_science_flx_ctr, time_range=SAME_NIGHT,
                                                 level=0)
                            .build())

# pol, img
ird_raw_coronagraph_center = (data_source("IRD_STAR_CENTER_WAFFLE_RAW")
                              .with_classification_rule(cls_ird_img_coronagraph_center)
                              .with_setup_keywords(rules.setupkwd_ird_img_science)
                              .with_grouping_keywords([kwd.arcfile])
                              .with_match_keywords(rules.matchkwd_ird_img_science_flx_ctr, time_range=SAME_NIGHT,
                                                   level=0)
                              .build())

ird_raw_science_img = (data_source("IRD_SCIENCE_DBI_RAW")
                       .with_classification_rule(cls_ird_science_img)
                       .with_setup_keywords(rules.setupkwd_ird_img_science)
                       .with_grouping_keywords(rules.grpkwd_ird_img_science_obj_flx)
                       .build())

ird_raw_science_flux_pol = (data_source("IRD_SCIENCE_DPI_RAW")
                            .with_classification_rule(cls_ird_science_flux_pol)
                            .with_setup_keywords(rules.setupkwd_ird_pol_science_obj)
                            .with_grouping_keywords(rules.grpkwd_ird_pol_science_obj)
                            .with_match_keywords(rules.matchkwd_ird_pol_science_obj, time_range=SAME_NIGHT,
                                                 level=0)
                            .build())

ird_raw_science_pol = (data_source("IRD_SCIENCE_DPI_RAW")
                       .with_classification_rule(cls_ird_science_pol)
                       .with_setup_keywords(rules.setupkwd_ird_pol_science_obj)
                       .with_grouping_keywords(rules.grpkwd_ird_pol_science_obj)
                       .build())

ird_raw_science_lss = (data_source("IRD_SCIENCE_SPECTROSCOPY_RAW")
                       .with_classification_rule(cls_ird_science_lss)
                       .with_setup_keywords(rules.setupkwd_ird_lss_sci_wcal)
                       .with_grouping_keywords(rules.grpkwd_ird_lss_sci_wcal)
                       .build())

ird_raw_wavecal_lss = (data_source("IRD_WAVECALIB_RAW")
                       .with_classification_rule(cls_ird_wavecal_lss)
                       .with_setup_keywords([kwd.ins1_filt_name, kwd.ins1_opti1_name, kwd.ins1_opti2_name])
                       .with_grouping_keywords(rules.grpkwd_ird_lss_sci_wcal)
                       .with_match_keywords(rules.matchkwd_ird_lss_wcal, time_range=ONE_DAY, level=0)
                       .with_match_keywords(rules.matchkwd_ird_lss_wcal, time_range=TEN_DAYS, level=1)
                       .build())

# static calibrations
ird_point_pattern_table = (data_source("IRD_POINT_PATTERN")
                           .with_classification_rule(IRD_POINT_PATTERN)
                           .with_match_keywords([kwd.instrume, kwd.seq_arm], time_range=IN_THE_PAST, level=0)
                           .build())

ird_phot_star_table = (data_source("IRD_PHOT_STAR_TABLE")
                       .with_classification_rule(IRD_PHOT_STAR_TABLE)
                       .with_match_keywords([kwd.instrume, kwd.seq_arm], time_range=IN_THE_PAST, level=0)
                       .build())

ird_filter_table = (data_source("IRD_FILTER_TABLE")
                    .with_classification_rule(IRD_FILTER_TABLE)
                    .with_match_keywords([kwd.instrume, kwd.seq_arm], time_range=IN_THE_PAST, level=0)
                    .build())

ird_static_wafflemap = (data_source("IRD_STATIC_WAFFLEMAP")
                        .with_classification_rule(IRD_STATIC_WAFFLEMAP)
                        .with_match_keywords([kwd.instrume, kwd.seq_arm], time_range=IN_THE_PAST, level=0)
                        .build())
