from edps import match

from . import visir_keywords as kwd


def is_visir(f):
    return f[kwd.instrume] == "VISIR"


def is_calib(f):
    return is_visir(f) and f[kwd.dpr_catg] == "CALIB"


def is_science(f):
    return f[kwd.dpr_catg] == "SCIENCE"


def is_acquisition(f):
    return f[kwd.dpr_catg] == "ACQUISITION"


def is_std(f):
    return is_visir(f) and is_calib(f) and f[kwd.dpr_type] == "STD"


def is_echelle(f):
    return "ECHELLE" in f[kwd.dpr_tech]


def is_longslit(f):
    return "SPECTRUM" in f[kwd.dpr_tech]


def is_jitter(f):
    return "JITTER" in f[kwd.dpr_tech]


def is_burst(f):
    return "BURST" in f[kwd.dpr_tech]


def is_image(f):
    return "IMAGE" in f[kwd.dpr_tech]


def is_chopnod(f):
    return "CHOPNOD" in f[kwd.dpr_tech]


def uses_sam_filters(f):
    return f[kwd.filt1] in ["11_3_SAM", "10_5_SAM"]


def is_sam(f):
    return "SAM" in f[kwd.dpr_tech] or uses_sam_filters(f)


def is_std_echelle(f):
    return is_std(f) and is_echelle(f) and not is_sam(f)


def is_std_spectra(f):
    return is_std(f) and is_chopnod(f) and "IMAGE" not in f[kwd.dpr_tech] and not is_echelle(f) and not is_sam(f)


def is_science_echelle(f):
    return is_science(f) and is_echelle(f) and f[kwd.dpr_type] == "OBJECT" and not is_sam(f)


def is_science_longslit(f):
    return is_science(f) and is_longslit(f) and f[kwd.dpr_type] == "OBJECT" and not is_sam(f)


def is_science_image(f):
    return is_science(f) and is_image(f) and is_chopnod(f) and is_jitter(f) and f[kwd.dpr_type] == "OBJECT"


def is_science_sam(f):
    return is_science(f) and is_sam(f)


def is_science_image_jit(f):
    return is_science_image(f) and not is_burst(f)


def is_science_image_jit_burst(f):
    return is_science_image(f) and is_burst(f)


def is_std_image(f):
    return is_calib(f) and is_image(f) and is_chopnod(f) and is_jitter(f) and "STD" in f[kwd.dpr_type] and not is_sam(f)


def is_std_image_jit(f):
    return is_std_image(f) and not is_burst(f)


def is_std_image_jit_burst(f):
    return is_std_image(f) and is_burst(f)


def is_std_sam(f):
    return is_std(f) and is_sam(f)


def is_standard_imaging(f):
    return is_std(f) and f[kwd.dpr_tech] == "IMAGE,CHOPNOD" and not uses_sam_filters(f)


def is_standard_coronagraph(f):
    return is_std(f) and f[kwd.dpr_tech] in ["CORONOGRAPHY,CHOPNOD", "CORONAGRAPHY,CHOPNOD",
                                             "CORO,CHOPNOD"] and not uses_sam_filters(f)


def is_standard_burst(f):
    return is_std(f) and f[kwd.dpr_tech] in ["IMAGE,BURST", "IMAGE,BURST,CHOPNOD,JITTER",
                                             "IMAGE,BURST,CHOPNOD"] and not uses_sam_filters(f)


# ASSOCIATION RULES
#  -  first, e.g.  ref=trigger (e.g. science)
#  -  second, e.g.  f=file to associate (e.g. calibration)

def assoc_image(ref, f):
    c1 = "BURST" in ref[kwd.dpr_tech] and match(ref, f, [kwd.dpr_tech, kwd.filt1, kwd.ins_pfov])
    c2 = "BURST" not in ref[kwd.dpr_tech] and "BURST" not in f[kwd.dpr_tech] and \
         match(ref, f, [kwd.filt1, kwd.ins_pfov])
    return c1 or c2
