from edps import classification_rule

from . import visir_keywords as kwd
from . import visir_rules as rules

# Dictionaris containing the values of header keywords that define calibrations and science data
# in the red and blue arms.
visir = {kwd.instrume: "VISIR"}
calib_keywords = {**visir, kwd.pro_catg: None, kwd.dpr_catg: "CALIB"}
science_keywords = {**visir, kwd.pro_catg: None, kwd.dpr_catg: "SCIENCE"}
acqusition_keywords = {**visir, kwd.pro_catg: None, kwd.dpr_catg: "ACQUISITION"}
# ---- Classification rules  -----------------

# Raw types
# Darks
dark_img_class = classification_rule(
    "IM_CAL_DARK", {**calib_keywords, kwd.dpr_type: "DARK", kwd.dpr_tech: "IMAGE"})
dark_spec_class = classification_rule(
    "SPEC_CAL_DARK", {**calib_keywords, kwd.dpr_type: "DARK", kwd.dpr_tech: "SPECTRUM"})

# Spectroscopic standard stars
standard_echelle_class = classification_rule("SPEC_CAL_PHOT_HRG", rules.is_std_echelle)
standard_spectra_class = classification_rule("SPEC_CAL_PHOT", rules.is_std_spectra)

# Photometric standard stars
standard_coronagraphy_class = classification_rule(
    "IM_CAL_PHOT", rules.is_standard_coronagraph)

standard_imaging_class = classification_rule("IM_CAL_PHOT", rules.is_standard_imaging)

standard_burst_class = classification_rule("BURST", rules.is_standard_burst)

# Other standard stars
std_sam_class = classification_rule("IM_CAL_PHOT", rules.is_std_sam)
std_pupil_class = classification_rule(
    "IM_CAL_PHOT", {**calib_keywords, kwd.dpr_type: "STD", kwd.dpr_tech: "IMAGE,PUPIL"})
std_chopnod_jitter_class = classification_rule(
    "IM_CAL_PHOT",
    {**calib_keywords, kwd.dpr_type: "STD", kwd.dpr_tech: ["IMAGE,CHOPNOD,JITTER"]},)

# Science exposures
science_echelle_class = classification_rule("SPEC_OBS_HRG", rules.is_science_echelle)
science_long_slit_class = classification_rule("SPEC_OBS_LMR", rules.is_science_longslit)
science_image_jit_class = classification_rule(
    "IM_OBS_CHO_NOD_JIT", rules.is_science_image_jit)
science_image_class = classification_rule(
    "IM_OBS_CHO_NOD",
    {**science_keywords, kwd.dpr_tech: "IMAGE,CHOPNOD", kwd.dpr_type: "OBJECT"},)
science_image_jit_burst_class = classification_rule(
    "IM_OBS_CHO_NOD_JIT_BURST", rules.is_science_image_jit_burst)
science_image_burst_class = classification_rule(
    "IM_OBS_CHO_NOD_BURST",
    {**science_keywords, kwd.dpr_tech: "IMAGE,BURST,CHOPNOD", kwd.dpr_type: "OBJECT"},)
science_coronagraphy_class = classification_rule(
    "IM_OBS_CHO_NOD_JIT",
    {
        **science_keywords,
        kwd.dpr_type: "OBJECT",
        kwd.dpr_tech: ["CORO,CHOPNOD", "CORONOGRAPHY,CHOPNOD", "CORONAGRAPHY,CHOPNOD"],
    },
)
science_pupil_class = classification_rule(
    "IM_OBS_PUPIL",
    {**science_keywords, kwd.dpr_type: "OBJECT", kwd.dpr_tech: ["IMAGE,PUPIL"]},)
#
science_sam_class = classification_rule("IM_OBS_CHO_NOD_JIT", rules.is_science_sam)

sci_acq_chopnod_class = classification_rule(
    "IM_ACQ_CHO_NOD_JIT",
    {**acqusition_keywords, kwd.dpr_type: "OBJECT", kwd.dpr_tech: ["IMAGE,CHOPNOD"]},)

# Master calibrations and products of intermediate reduction steps
SPC_PHOT_HRG_TAB = classification_rule(
    "SPC_PHOT_HRG_TAB", {**visir, kwd.pro_catg: "SPC_PHOT_HRG_TAB"})
SPC_PHOT_TAB = classification_rule(
    "SPC_PHOT_TAB", {**visir, kwd.pro_catg: "SPC_PHOT_TAB"})

DESTRIPED = classification_rule("DESTRIPED", {**visir, kwd.pro_catg: "DESTRIPED"})
UNDISTORTED = classification_rule("UNDISTORTED", {**visir, kwd.pro_catg: "UNDISTORTED"})
SPEC_OBS_HRG_PREPROCESSED = classification_rule(
    "SPEC_OBS_HRG_PREPROCESSED", {**visir, kwd.pro_catg: "SPEC_OBS_HRG_PREPROCESSED"})
SPEC_CAL_PHOT_HRG_PREPROCESSED = classification_rule(
    "SPEC_CAL_PHOT_HRG_PREPROCESSED",
    {**visir, kwd.pro_catg: "SPEC_OBS_HRG_PREPROCESSED"},)
SPEC_OBS_LMR_PREPROCESSED = classification_rule(
    "SPEC_OBS_LMR_PREPROCESSED", {**visir, kwd.pro_catg: "SPEC_OBS_LMR_PREPROCESSED"})
SPEC_CAL_PHOT_PREPROCESSED = classification_rule(
    "SPEC_CAL_PHOT_PREPROCESSED", {**visir, kwd.pro_catg: "SPEC_OBS_PREPROCESSED"})
BEAM_DETECTED = classification_rule(
    "BEAM_DETECTED", {**visir, kwd.pro_catg: "BEAM_DETECTED"})
BKG_CORRECTED = classification_rule(
    "BKG_CORRECTED", {**visir, kwd.pro_catg: "BKG_CORRECTED"})
COADDED_IMAGE = classification_rule(
    "COADDED_IMAGE", {**visir, kwd.pro_catg: "COADDED_IMAGE"})
COADDED_IMAGE_COMBINED = classification_rule(
    "COADDED_IMAGE_COMBINED", {**visir, kwd.pro_catg: "COADDED_IMAGE_COMBINED"})
QC_HEADER = classification_rule("QC_HEADER", {**visir, kwd.pro_catg: "QC_HEADER"})
QC_HEADER_COMBINED = classification_rule(
    "QC_HEADER_COMBINED", {**visir, kwd.pro_catg: "QC_HEADER_COMBINED"})
COADDED_WEIGHT = classification_rule(
    "COADDED_WEIGHT", {**visir, kwd.pro_catg: "COADDED_WEIGHT"})
WEIGHT_MAP = classification_rule("WEIGHT_MAP", {**visir, kwd.pro_catg: "WEIGHT_MAP"})
IMG_PHOT_COMBINED = classification_rule(
    "IMG_PHOT_COMBINED", {**visir, kwd.pro_catg: "IMG_PHOT_COMBINED"})
COADDED_WEIGHT_COMBINED = classification_rule(
    "COADDED_WEIGHT_COMBINED", {**visir, kwd.pro_catg: "COADDED_WEIGHT_COMBINED"})
COADDED_CONTRIBUTION_COMBINED = classification_rule(
    "COADDED_CONTRIBUTION_COMBINED",
    {**visir, kwd.pro_catg: "COADDED_CONTRIBUTION_COMBINED"},)
IM_CAL_PHOT_PREPROCESSED = classification_rule(
    "IM_CAL_PHOT_PREPROCESSED", {**visir, kwd.pro_catg: "IM_CAL_PHOT_PREPROCESSED"})
# Static calibrations
img_std_catalog_class = classification_rule(
    "IMG_STD_CATALOG", {**visir, kwd.pro_catg: "IMG_STD_CATALOG"})
spec_cal_lines_class = classification_rule(
    "SPEC_CAL_LINES", {**visir, kwd.pro_catg: "SPEC_CAL_LINES"})
spec_cal_qeff_class = classification_rule(
    "SPEC_CAL_QEFF", {**visir, kwd.pro_catg: "SPEC_CAL_QEFF"})

spec_std_catalog_class = classification_rule(
    "SPEC_STD_CATALOG", {**visir, kwd.pro_catg: "SPEC_STD_CATALOG"})
static_mask_class = classification_rule(
    "STATIC_MASK", {**calib_keywords, kwd.dpr_tech: "STATIC_MASK"})
linearity_table_class = classification_rule(
    "LINEARITY_TABLE", {**calib_keywords, kwd.dpr_tech: "LINEARITY_TABLE"})
arc_lines_hrg_class = classification_rule(
    "SPC_WCAL_HRG_TAB", {**calib_keywords, kwd.pro_catg: "SPC_WCAL_HRG_TAB"})
