from edps import science, qc0, calchecker
from edps import task

from .visir_datasources import *
from .visir_reduce_spectra import process_science_longslit, process_standard_longslit
from .visir_task_functions import standard_optional, standard_mandatory

__title__ = "VISIR long-slit workflow"

# --- PROCESSING TASKS -------------------------------------------------------------------

# --- Reduce long-slit observations ----------------------------------------------------------------
# Reduce long-slit standard and object
process_long_slit_standard = process_standard_longslit(raw_standard_long_slit)
process_long_slit_science = process_science_longslit(raw_science_long_slit)
# These task definitions will be removed in future edps versions, when tasks will be "discovered" also inside classes
repack_lss_std = process_long_slit_standard.repack
undistort_lss_std = process_long_slit_standard.undistort
destripe_lss_std = process_long_slit_standard.destripe
repack_lss_sci = process_long_slit_science.repack
undistort_lss_sci = process_long_slit_science.undistort
destripe_lss_sci = process_long_slit_science.destripe

# Calibrate object long-slit observations using long-slit standard stars
# Standard stars are mandatory only for QC0 process in Paranal.
calibrate_science_long_slit = (task("calibrate_science_long_slit")
                               .with_recipe("visir_util_apply_calib")
                               .with_main_input(process_long_slit_science.processed)
                               .with_associated_input(process_long_slit_standard.processed, [SPC_PHOT_TAB], min_ret=0,
                                                      condition=standard_optional)
                               .with_associated_input(process_long_slit_standard.processed, [SPC_PHOT_TAB], min_ret=1,
                                                      condition=standard_mandatory)
                               .with_meta_targets([qc0, science, calchecker])
                               .build())
# ---
