import logging
import os
from adari_core.plots.text import TextPlot
from adari_core.data_libs.master_dark_bias import MasterDarkBiasReport
from .xshooter_utils import XshooterSetupInfo, XshooterReportMixin

logger = logging.getLogger(__name__)

center_size = 200


class XshooterMasterDarkReport(XshooterReportMixin, MasterDarkBiasReport):
    def __init__(self):
        super().__init__("xshooter_master_dark")
        self.center_size = center_size
        self.hist_bins_max = 20

    def parse_sof(self):
        master_dark_nir = None
        master_dark_uvb = None
        master_dark_vis = None
        master_dark_agc = None

        for filename, catg in self.inputs:
            if catg == "MASTER_DARK_NIR" and master_dark_nir is None:
                master_dark_nir = filename
                self.category_label = "NIR"
            elif catg == "MASTER_DARK_UVB" and master_dark_uvb is None:
                master_dark_uvb = filename
                self.category_label = "UVB"
            elif catg == "MASTER_DARK_VIS" and master_dark_vis is None:
                master_dark_vis = filename
                self.category_label = "VIS"
            elif catg == "MASTER_DARK_AGC" and master_dark_agc is None:
                master_dark_agc = filename
                self.category_label = "AGC"

        # Build and return the file name list
        file_lists = []
        if master_dark_vis is not None:
            file_lists.append(
                {
                    "master_im": master_dark_vis,
                }
            )
        if master_dark_uvb is not None:
            file_lists.append(
                {
                    "master_im": master_dark_uvb,
                }
            )
        if master_dark_agc is not None:
            file_lists.append(
                {
                    "master_im": master_dark_agc,
                }
            )
        if master_dark_nir is not None:
            file_lists.append(
                {
                    "master_im": master_dark_nir,
                }
            )
        return file_lists

    def generate_panels(self, **kwargs):
        panels = {}
        self.metadata = XshooterSetupInfo.dark(list(self.hdus[0].values())[0])
        new_panels = super().generate_raw_cuts_panels(
            master_im_ext="PRIMARY",
            master_title="Master Dark",
            im_clipping="mad",
            im_n_clipping=4,
            im_zoom_clipping="percentile",
            im_zoom_n_clipping=95,
            master_im_clipping="percentile",
            master_im_n_clipping=95,
            master_im_zoom_clipping="mad",
            master_im_zoom_n_clipping=3,
            hist_clipping="sigma",
            hist_n_clipping=7,
            cut_clipping="percentile",
            cut_n_clipping=95,
            cut_min_span=None,
            cut_cent_clipping="percentile",
            cut_cent_n_clipping=95,
            cut_cent_min_span=None,
        )

        for i, (panel, panel_descr) in enumerate(new_panels.items()):
            panel_descr["report_description"] = (
                f"XSHOOTER dark panel - "
                f"{os.path.basename(panel_descr['master_im'])}, "
                f"{panel_descr['master_im_ext']}"
            )

            master_im = self.hdus[i]["master_im"]

            # Text Plot
            px = 0
            py = 0
            # which hdul and ext to use
            vspace = 0.3
            fname = os.path.basename(str(master_im.filename()))
            t1 = TextPlot(columns=1, v_space=vspace)
            col1 = (
                str(master_im["PRIMARY"].header.get("INSTRUME")),
                "EXTNAME: " + str(master_im["PRIMARY"].header.get("EXTNAME", "N/A")),
                "PRO CATG: "
                + str(master_im["PRIMARY"].header.get("HIERARCH ESO PRO CATG")),
                "FILE NAME: " + fname,
                "RAW1 NAME: "
                + str(
                    master_im["PRIMARY"].header.get("HIERARCH ESO PRO REC1 RAW1 NAME")
                ),
            )
            t1.add_data(col1)
            panel.assign_plot(t1, px, py, xext=2)

            px = px + 2
            t2 = TextPlot(columns=1, v_space=vspace, xext=1)
            col2 = self.metadata
            t2.add_data(col2)
            panel.assign_plot(t2, px, py, xext=1)

            panels = {**panels, **new_panels}

        return panels


rep = XshooterMasterDarkReport()
