import os
from adari_core.data_libs.master_rawdisp import MasterRawdispReport
from .xshooter_utils import XshooterSetupInfo, XshooterReportMixin

class XshooterRawdispReport(XshooterReportMixin, MasterRawdispReport):
    def __init__(self):
        super().__init__("xshooter_rawdisp")

        self.extensions = []
        self.tasks = {
            "BIAS_AGC": "bias",
            "BIAS_UVB": "bias",
            "BIAS_VIS": "bias",
            #
            "DARK_AGC": "dark",
            "DARK_UVB": "dark",
            "DARK_VIS": "dark",
            "DARK_NIR": "dark",
            #
            "ON_RAW": "detmon",
            "OFF_RAW": "detmon",
            #
            "FMTCHK_UVB": "order_prediction",
            "FMTCHK_VIS": "order_prediction",
            "FMTCHK_NIR_ON": "order_prediction",
            "FMTCHK_NIR_OFF": "order_prediction",
            #
            "ORDERDEF_D2_UVB": "order_definition",
            "ORDERDEF_VIS": "order_definition",
            "ORDERDEF_NIR_ON": "order_definition",
            "ORDERDEF_QTH_UVB": "order_definition",
            "ORDERDEF_NIR_OFF": "order_definition",
            #
            "FLAT_D2_SLIT_UVB": "lamp_flat",
            "FLAT_SLIT_VIS": "lamp_flat",
            "FLAT_SLIT_NIR_ON": "lamp_flat",
            "FLAT_QTH_SLIT_UVB": "lamp_flat",
            "FLAT_SLIT_NIR_OFF": "lamp_flat",
            "FLAT_D2_IFU_UVB": "lamp_flat",
            "FLAT_IFU_VIS": "lamp_flat",
            "FLAT_IFU_NIR_ON": "lamp_flat",
            "FLAT_QTH_IFU_UVB": "lamp_flat",
            "FLAT_IFU_NIR_OFF": "lamp_flat",
            #
            "ARC_SLIT_UVB": "arc",
            "ARC_SLIT_VIS": "arc",
            "ARC_SLIT_NIR_ON": "arc",
            "ARC_SLIT_NIR_OFF": "arc",
            "ARC_IFU_UVB": "arc",
            "ARC_IFU_VIS": "arc",
            "ARC_IFU_NIR_ON": "arc",
            "ARC_IFU_NIR_OFF": "arc",
            #
            "WAVE_UVB": "wavelength_calibration_2d",
            "WAVE_VIS": "wavelength_calibration_2d",
            "WAVE_NIR_ON": "wavelength_calibration_2d",
            "WAVE_NIR_OFF": "wavelength_calibration_2d",
            #
            "AFC_ATT_UVB": "flexures",
            "AFC_ATT_VIS": "flexures",
            "AFC_ATT_NIR": "flexures",
            #
            "SKYFLAT_AGC": "acquisition_camera_flats",
            #
            "STD_FLUX_SLIT_NOD_UVB": "response_nod",
            "STD_FLUX_SLIT_NOD_VIS": "response_nod",
            "STD_FLUX_SLIT_NOD_NIR": "response_nod",
            #
            "STD_FLUX_SLIT_STARE_UVB": "response_stare",
            "STD_FLUX_SLIT_STARE_VIS": "response_stare",
            "STD_FLUX_SLIT_STARE_NIR": "response_stare",
            "STD_FLUX_IFU_STARE_UVB": "response_stare",
            "STD_FLUX_IFU_STARE_VIS": "response_stare",
            "STD_FLUX_IFU_STARE_NIR": "response_stare",
            #
            "STD_FLUX_SLIT_OFFSET_UVB": "response_offset",
            "STD_FLUX_SLIT_OFFSET_VIS": "response_offset",
            "STD_FLUX_SLIT_OFFSET_NIR": "response_offset",
            "STD_FLUX_IFU_OFFSET_UVB": "response_offset",
            "STD_FLUX_IFU_OFFSET_VIS": "response_offset",
            "STD_FLUX_IFU_OFFSET_NIR": "response_offset",
            # tellurics
            "STD_TELL_SLIT_NOD_UVB": "telluric_standard_slit_nod",
            "STD_TELL_SLIT_NOD_VIS": "telluric_standard_slit_nod",
            "STD_TELL_SLIT_NOD_NIR": "telluric_standard_slit_nod",
            "STD_TELL_SLIT_STARE_UVB": "telluric_standard_slit_stare",
            "STD_TELL_SLIT_STARE_VIS": "telluric_standard_slit_stare",
            "STD_TELL_SLIT_STARE_NIR": "telluric_standard_slit_stare",
            "STD_TELL_SLIT_OFFSET_UVB": "telluric_standard_slit_offset",
            "STD_TELL_SLIT_OFFSET_VIS": "telluric_standard_slit_offset",
            "STD_TELL_SLIT_OFFSET_NIR": "telluric_standard_slit_offset",
        }

        self.select_raw_files = {}

        self.task_scaling = {}

        self.setup_info = XshooterSetupInfo

    def parse_sof(self):
        # we building multiple report sets, so we append multiple reports to file_lists
        # get a list of tags
        ext = "PRIMARY"
        tags = list(self.tasks.keys())
        added = {}
        file_lists = []
        for filename, catg in self.inputs:
            if catg in tags:
                if filename is not None and catg not in added:
                    file_lists.append({"filename": filename})
                    added[catg] = self.tasks[catg]
                    self.sof_tag.append(catg)
                    self.extensions.append(ext)
        return file_lists

    def generate_panels(self, **kwargs):
        panels = {}
        new_panels = super().generate_panels(ext=self.extensions, **kwargs)
        for i, (panel, panel_descr) in enumerate(new_panels.items()):
            # Alter the cut pos, or remove CutPlot(s) completely,
            # depending on task name
            try:
                task_name = panel_descr["task_name"]
            except KeyError:
                raise RuntimeError(
                    "A report has been created by "
                    "MasterRawdispReport that did "
                    "not come back with a task name "
                    "attached!"
                )
            panel_descr["report_name"] = "xshooter_rawdisp_{}_{}_{}_{}".format(
                task_name,
                self.extensions[i],
                self.sof_tag[i].lower(),
                os.path.basename(panel_descr["filename"]),
            )
            panel_descr["report_description"] = (
                f"XSHOOTER rawdisp panel - "
                f"{panel_descr['task_name']}, "
                f"{panel_descr['tag']}, "
                f"{os.path.basename(panel_descr['filename'])}, "
                f"{panel_descr['ext']}"
            )
        panels = {**panels, **new_panels}

        return panels


rep = XshooterRawdispReport()
