from edps import match_rules

from .xshooter_datasources import *

# Association rules for bias frames. Note: QC does not require det.chip1.id
# This association is for all calibratinos, but flexure correction, and standard stars.
associate_bias_cals = (match_rules()
                       .with_match_keywords(keys_arm_read_clock, time_range=FIVE_DAYS, level=0)
                       .with_match_keywords(keys_arm_read_clock, time_range=ONE_WEEK, level=1)
                       .with_match_keywords(keys_arm_read_clock, time_range=UNLIMITED, level=3))
associate_bias_cals_agc = (match_rules()
                           .with_match_keywords([kwd.seq_arm], time_range=FIVE_DAYS, level=0)
                           .with_match_keywords([kwd.seq_arm], time_range=ONE_WEEK, level=1)
                           .with_match_keywords([kwd.seq_arm], time_range=UNLIMITED, level=3))

# This association is for flexure correction.
associate_bias_flex = (match_rules()
                       .with_match_keywords([kwd.seq_arm, kwd.det_out1_gain] + keys_bin,
                                            time_range=THREE_DAYS, level=0)
                       .with_match_keywords([kwd.seq_arm, kwd.det_out1_gain] + keys_bin,
                                            time_range=ONE_MONTH, level=1)
                       .with_match_keywords([kwd.seq_arm, kwd.det_out1_gain] + keys_bin, time_range=UNLIMITED,
                                            level=3))

# This association is for science (same rules as before, different validity range
associate_bias_science = (match_rules()
                          .with_match_keywords(keys_arm_read_clock, time_range=THREE_DAYS, level=0)
                          .with_match_keywords(keys_arm_read_clock, time_range=ONE_WEEK, level=1)
                          .with_match_keywords(keys_arm_read_clock, time_range=UNLIMITED, level=3))

# Association rules for optical darks
associate_dark_optical = (match_rules()
                          .with_match_keywords(match_dark_opt, time_range=ONE_MONTH, level=0)
                          .with_match_keywords(match_dark_opt, time_range=RelativeTimeRange(-93, 93), level=1)
                          .with_match_keywords(match_dark_opt, time_range=UNLIMITED, level=3))

# Association rules for trace predict calibrations
associate_predict_to_2dmap = (match_rules()
                              .with_match_keywords([kwd.seq_arm], time_range=TWO_DAYS, level=0)
                              .with_match_keywords([kwd.seq_arm], time_range=ONE_MONTH, level=0)
                              .with_match_keywords([kwd.seq_arm], time_range=UNLIMITED, level=3))

# Association rules for flats
associate_flat_uvb = (match_rules()
                      .with_match_keywords(match_flat_uvb, time_range=THREE_DAYS, level=0)
                      .with_match_keywords(match_flat_uvb, time_range=ONE_WEEK, level=1)
                      .with_match_keywords(match_flat_uvb, time_range=UNLIMITED, level=3))

associate_flat_vis = (match_rules()
                      .with_match_keywords(match_flat_vis, time_range=THREE_DAYS, level=0)
                      .with_match_keywords(match_flat_vis, time_range=ONE_WEEK, level=1)
                      .with_match_keywords(match_flat_vis, time_range=UNLIMITED, level=3))

associate_flat_nir = (match_rules()
                      .with_match_keywords(match_flat_nir, time_range=THREE_DAYS, level=0)
                      .with_match_keywords(match_flat_nir, time_range=ONE_WEEK, level=1)
                      .with_match_keywords(match_flat_nir, time_range=UNLIMITED, level=3))
associate_arm = (match_rules()
                 .with_match_keywords(instrument_and_arm, time_range=ONE_DAY, level=0)
                 .with_match_keywords(instrument_and_arm, time_range=ONE_WEEK, level=1)
                 .with_match_keywords(instrument_and_arm, time_range=UNLIMITED, level=3))

associate_arm_tplstart = (match_rules()
                          .with_match_keywords(instrument_and_arm + [kwd.tpl_start], time_range=ONE_DAY, level=0))

associate_flat_uvb_arcs = (match_rules()
                           .with_match_keywords(match_flat2_uvb, time_range=FIVE_DAYS, level=0)
                           .with_match_keywords(match_flat2_uvb, time_range=ONE_WEEK, level=1)
                           .with_match_keywords(match_flat2_uvb, time_range=UNLIMITED, level=3))

associate_flat_vis_arcs = (match_rules()
                           .with_match_keywords(match_flat2_vis, time_range=FIVE_DAYS, level=0)
                           .with_match_keywords(match_flat2_vis, time_range=ONE_WEEK, level=1)
                           .with_match_keywords(match_flat2_vis, time_range=UNLIMITED, level=3))

associate_flat_nir_arcs = (match_rules()
                           .with_match_keywords(match_flat_nir, time_range=FIVE_DAYS, level=0)
                           .with_match_keywords(match_flat_nir, time_range=ONE_WEEK, level=1)
                           .with_match_keywords(match_flat_nir, time_range=UNLIMITED, level=3))

associate_flat_flex_opt = (match_rules()
                           .with_match_keywords(keys_chip_arm_opti2, time_range=THREE_DAYS, level=0)
                           .with_match_keywords(keys_chip_arm_opti2, time_range=UNLIMITED, level=3))

associate_flat_flex_nir = (match_rules()
                           .with_match_function(rules.assoc_flat_to_flex_nir, time_range=THREE_DAYS, level=0)
                           .with_match_function(rules.assoc_flat_to_flex_nir, time_range=UNLIMITED, level=3))

associate_flat_to_dmap_opt = (match_rules()
                              .with_match_keywords(keys_chip_arm_opti2, time_range=THREE_DAYS, level=0)
                              .with_match_keywords(keys_chip_arm_opti2, time_range=UNLIMITED, level=3))

associate_flat_to_dmap_nir = (match_rules()
                              .with_match_function(rules.match_nir_flat_to_dmap, time_range=THREE_DAYS, level=0)
                              .with_match_function(rules.match_nir_flat_to_dmap, time_range=UNLIMITED, level=3))

match_k = [kwd.ins_opti2_name, kwd.seq_arm, kwd.obs_id, kwd.obs_targ_name]
associate_flex_using_target_name = (match_rules()
                                    .with_match_keywords(match_k, time_range=RelativeTimeRange(-0.05, 0), level=0)
                                    .with_match_keywords(match_k, time_range=RelativeTimeRange(-0.08, 0), level=1))

associate_flex_using_container = (match_rules()
                                  .with_match_function(rules.associate_flex, time_range=RelativeTimeRange(-0.5, 0),
                                                       level=0)
                                  .with_match_function(rules.associate_flex, time_range=SAME_NIGHT,
                                                       level=1))

association_sky_rules = (match_rules()
                         .with_match_keywords(instrument_and_arm + [kwd.tpl_start], time_range=SAME_NIGHT, level=0))
