from edps import subworkflow, task, copy_upstream

from .xshooter_association_rules import *
from .xshooter_task_functions import *


# Functions to assess the condition that determines which flat is selected
def use_flat_science_uvb_slit(params: JobParameters) -> bool:
    return use_flat_science(params) and is_UVB_slit(params)


def use_flat_science_vis_slit(params: JobParameters) -> bool:
    return use_flat_science(params) and is_VIS_slit(params)


def use_flat_science_nir_slit(params: JobParameters) -> bool:
    return use_flat_science(params) and is_NIR_slit(params)


def use_flat_standard_uvb_slit(params: JobParameters) -> bool:
    return use_flat_standard(params) and is_UVB_slit(params)


def use_flat_standard_vis_slit(params: JobParameters) -> bool:
    return use_flat_standard(params) and is_VIS_slit(params)


def use_flat_standard_nir_slit(params: JobParameters) -> bool:
    return use_flat_standard(params) and is_NIR_slit(params)


def use_flat_science_uvb_ifu(params: JobParameters) -> bool:
    return use_flat_science(params) and is_UVB_ifu(params)


def use_flat_science_vis_ifu(params: JobParameters) -> bool:
    return use_flat_science(params) and is_VIS_ifu(params)


def use_flat_science_nir_ifu(params: JobParameters) -> bool:
    return use_flat_science(params) and is_NIR_ifu(params)


def use_flat_standard_uvb_ifu(params: JobParameters) -> bool:
    return use_flat_standard(params) and is_UVB_ifu(params)


def use_flat_standard_vis_ifu(params: JobParameters) -> bool:
    return use_flat_standard(params) and is_VIS_ifu(params)


def use_flat_standard_nir_ifu(params: JobParameters) -> bool:
    return use_flat_standard(params) and is_NIR_ifu(params)


@subworkflow("flat_strategy", "")
def flat_strategy(flat_calibrations, raw_science, raw_standard):
    # This subworkflow selects the flats that will be used to reduce the flux standards. Two options are available,
    # they are selected on the value of the workflow parameter "use_flats".
    #   use_flat: "standard". Use the flats that are closest in time to the standard star observations
    #   use_flat: "science".  Use the same flats used to process science observations also for standard stars.

    # Flats closest in time to the science observations are copied to the task output
    flats_science = (task('flats_science')
                     .with_condition(use_flat_science)
                     .with_main_input(raw_science)
                     .with_dynamic_parameter('arm', which_arm)
                     .with_dynamic_parameter('ifu', which_ifu)
                     .with_function(copy_upstream)
                     .with_job_processing(fix_setup_keywords)
                     .with_alternative_associated_inputs(flat_calibrations)
                     .build())

    # Flats closest in time to the standard stars observations are copied to the task output
    flats_standard = (task('flats_standard')
                      .with_condition(use_flat_standard)
                      .with_main_input(raw_standard)
                      .with_dynamic_parameter('arm', which_arm)
                      .with_dynamic_parameter('ifu', which_ifu)
                      .with_function(copy_upstream)
                      .with_job_processing(fix_setup_keywords)
                      .with_alternative_associated_inputs(flat_calibrations)
                      .build())

    # This statement selects the task corresponding to the chosen flatfield strategy. This task can then be
    # used as the associated input for the standard task.

    alternatives_flats_for_standard = (alternative_associated_inputs()
                                       .with_associated_input(flats_science,
                                                              [master_flat_slit_uvb, order_tab_edges_slit_uvb],
                                                              condition=use_flat_science_uvb_slit,
                                                              match_rules=associate_arm)
                                       .with_associated_input(flats_science,
                                                              [master_flat_slit_vis, order_tab_edges_slit_vis],
                                                              condition=use_flat_science_vis_slit,
                                                              match_rules=associate_arm)
                                       .with_associated_input(flats_science,
                                                              [master_flat_slit_nir, order_tab_edges_slit_nir],
                                                              condition=use_flat_science_nir_slit,
                                                              match_rules=associate_arm)
                                       .with_associated_input(flats_standard,
                                                              [master_flat_slit_uvb, order_tab_edges_slit_uvb],
                                                              condition=use_flat_standard_uvb_slit,
                                                              match_rules=associate_flat_uvb)
                                       .with_associated_input(flats_standard,
                                                              [master_flat_slit_vis, order_tab_edges_slit_vis],
                                                              condition=use_flat_standard_vis_slit,
                                                              match_rules=associate_arm_tplstart)
                                       .with_associated_input(flats_standard,
                                                              [master_flat_slit_nir, order_tab_edges_slit_nir],
                                                              condition=use_flat_standard_nir_slit,
                                                              match_rules=associate_arm_tplstart)
                                       .with_associated_input(flats_science,
                                                              [master_flat_ifu_uvb, order_tab_edges_slit_uvb],
                                                              condition=use_flat_science_uvb_ifu,
                                                              match_rules=associate_arm)
                                       .with_associated_input(flats_science,
                                                              [master_flat_ifu_vis, order_tab_edges_slit_vis],
                                                              condition=use_flat_science_vis_ifu,
                                                              match_rules=associate_arm)
                                       .with_associated_input(flats_science,
                                                              [master_flat_ifu_nir, order_tab_edges_slit_nir],
                                                              condition=use_flat_science_nir_ifu,
                                                              match_rules=associate_arm)
                                       .with_associated_input(flats_standard,
                                                              [master_flat_ifu_uvb, order_tab_edges_ifu_uvb],
                                                              condition=use_flat_standard_uvb_ifu,
                                                              match_rules=associate_arm_tplstart)
                                       .with_associated_input(flats_standard,
                                                              [master_flat_ifu_vis, order_tab_edges_ifu_vis],
                                                              condition=use_flat_standard_vis_ifu,
                                                              match_rules=associate_arm_tplstart)
                                       .with_associated_input(flats_standard,
                                                              [master_flat_ifu_nir, order_tab_edges_ifu_nir],
                                                              condition=use_flat_standard_nir_ifu,
                                                              match_rules=associate_arm_tplstart))

    return alternatives_flats_for_standard
