from edps import match

from . import xshooter_keywords as kwd


def is_xsh(f):
    return f[kwd.instrume] == 'XSHOOTER' or f[kwd.instrume] == 'SHOOT'


def is_calib(f):
    return is_xsh(f) and f[kwd.dpr_catg] == 'CALIB'


def is_uvb(f):
    return is_xsh(f) and f[kwd.seq_arm] == 'UVB'


def is_vis(f):
    return is_xsh(f) and f[kwd.seq_arm] == 'VIS'


def is_nir(f):
    return is_xsh(f) and f[kwd.seq_arm] == 'NIR'


def is_agc(f):
    return is_xsh(f) and (f[kwd.seq_arm] == 'AGC' or f[kwd.det_chip1_id] == 'CCD57-10IE')


def is_ifu(f):
    return is_xsh(f) and f[kwd.ins_opti2_id] == 'IFU'


def is_slit(f):
    return is_xsh(f) and f[kwd.ins_opti2_id] == 'SLOT'


def is_image(f):
    return f[kwd.dpr_tech] == 'IMAGE'


def is_dark(f):
    return is_calib(f) and is_image(f) and f[kwd.dpr_type] == 'DARK'


def is_dark_uvb(f):
    return is_dark(f) and is_uvb(f) and f[kwd.tpl_nexp] >= 3


def is_dark_vis(f):
    return is_dark(f) and is_vis(f) and f[kwd.tpl_nexp] >= 3


def is_echelle(f):
    return f[kwd.dpr_tech] == 'ECHELLE'


def is_echelle_pinhole(f):
    return f[kwd.dpr_tech] == 'ECHELLE,PINHOLE'


def is_echelle_ifu_nodding(f):
    return f[kwd.dpr_tech] == 'ECHELLE,IFU,NODDING'


def is_echelle_ifu(f):
    return f[kwd.dpr_tech] == 'ECHELLE,IFU'


def is_echelle_slit_off(f):
    return is_slit(f) and is_image(f)


def is_echelle_ifu_on(f):
    return is_ifu(f) and is_echelle_ifu(f)


def is_echelle_ifu_off(f):
    return is_ifu(f) and is_image(f)


def is_lamp_fmtchk(f):
    return f[kwd.dpr_type] == 'LAMP,FMTCHK'


def is_lamp_afc(f):
    return f[kwd.dpr_type] == 'LAMP,AFC'


def is_calib_uvb(f):
    return is_calib(f) and is_uvb(f)


def is_calib_vis(f):
    return is_calib(f) and is_vis(f)


def is_calib_nir(f):
    return is_calib(f) and is_nir(f)


def is_fmtchk_on_nir(f):
    return is_calib_nir(f) and is_echelle_pinhole(f) and is_lamp_fmtchk(f) and \
        (f[kwd.ins_lamp2_name] == 'ArHgNeXe_Lamp' or f[kwd.ins_lamp2_name] == 'ArKrNeXe_Lamp') and f[
            kwd.det_dit] > 0.67


def is_fmtchk_off_nir(f):
    return is_calib_nir(f) and is_image(f) and is_lamp_fmtchk(f) and f[kwd.det_dit] > 0.67


def is_opti3_pin_05(f):
    return f[kwd.ins_opti3_name] == 'Pin_0.5'


def is_opti4_pin_05(f):
    return f[kwd.ins_opti4_name] == 'Pin_0.5'


def is_opti5_pin_05(f):
    return f[kwd.ins_opti5_name] == 'Pin_0.5'


def is_lamp_flat(f):
    return f[kwd.dpr_type] == 'LAMP,FLAT'


def is_lamp_dflat(f):
    return f[kwd.dpr_type] == 'LAMP,DFLAT'


def is_lamp_qflat(f):
    return f[kwd.dpr_type] == 'LAMP,QFLAT'


def is_flat_d2_ifu_uvb(f):
    return is_calib_uvb(f) and is_echelle_ifu_on(f) and is_lamp_dflat(f) and \
        f[kwd.ins_lamp3_name] == 'UVB_Low_D2' and f[kwd.tpl_nexp] > 2


def is_flat_qth_ifu_uvb(f):
    return is_calib_uvb(f) and is_echelle_ifu_on(f) and is_lamp_qflat(f) and \
        f[kwd.ins_lamp4_name] == 'UVB_High' and f[kwd.tpl_nexp] > 2


def is_flat_d2_ifu_uvb_hc(f):
    return is_calib_uvb(f) and is_echelle_ifu_on(f) and is_lamp_dflat(f) and \
        f[kwd.ins_lamp3_name] == 'UVB_Low_D2' and f[kwd.tpl_nexp] < 3


def is_flat_qth_ifu_uvb_hc(f):
    return is_calib_uvb(f) and is_echelle_ifu_on(f) and is_lamp_qflat(f) and \
        f[kwd.ins_lamp4_name] == 'UVB_High' and f[kwd.tpl_nexp] < 3


def is_flat_ifu_vis(f):
    return is_calib_vis(f) and is_echelle_ifu_on(f) and is_lamp_flat(f) and \
        f[kwd.ins_lamp5_name] == 'VIS_FF_lamp' and f[kwd.tpl_nexp] > 1


def is_flat_ifu_vis_hc(f):
    return is_calib_vis(f) and is_echelle_ifu_on(f) and is_lamp_flat(f) and \
        f[kwd.ins_lamp5_name] == 'VIS_FF_lamp' and f[kwd.tpl_nexp] < 2


def is_flat_ifu_nir_on(f):
    return is_calib_nir(f) and is_echelle_ifu_on(f) and is_lamp_flat(f) and \
        f[kwd.ins_lamp6_name] == 'NIR_FF_lamp' and f[kwd.tpl_nexp] > 2


def is_flat_ifu_nir_off(f):
    return is_calib_nir(f) and is_echelle_ifu_off(f) and is_lamp_flat(f) and f[kwd.tpl_nexp] > 2


def is_flat_ifu_nir_on_hc(f):
    return is_calib_nir(f) and is_echelle_ifu_on(f) and is_lamp_flat(f) and \
        f[kwd.ins_lamp6_name] == 'NIR_FF_lamp' and f[kwd.tpl_nexp] < 3


def is_flat_ifu_nir_off_hc(f):
    return is_calib_nir(f) and is_echelle_ifu_off(f) and is_lamp_flat(f) and f[kwd.tpl_nexp] < 3


def is_lamp_wave(f):
    return is_calib(f) and f[kwd.dpr_type] == 'LAMP,WAVE'


def is_arc_slit_nir_off(f):
    return is_nir(f) and is_lamp_wave(f) and is_echelle_slit_off(f) and f[kwd.ins_opti5_name] != 'Pin_row'


def is_afc_ifu(f):
    return is_calib(f) and is_lamp_afc(f) and is_echelle(f) and f[kwd.ins_opti2_name] != 'SLOT' and \
        f[kwd.ins_opti4_name] != 'Pin_0.5' and f[kwd.tpl_id] in ['SHOOT_ifu_acq', 'XSHOOTER_ifu_acq',
                                                                 'SHOOT_ifu_AFC', 'XSHOOTER_ifu_AFC']


def is_adc_slit(f):
    return is_calib(f) and is_lamp_afc(f) and is_echelle(f) and f[kwd.ins_opti2_name] != "SLOT" and \
        f[kwd.tpl_id] in ["SHOOT_slt_acq", "XSHOOTER_slt_acq", "XSHOOTER_slt_acq_rrm"]


def is_adc_slit_uvb(f):
    return is_adc_slit(f) and is_uvb(f) and not is_opti3_pin_05(f)


def is_adc_slit_vis(f):
    return is_adc_slit(f) and is_vis(f) and not is_opti4_pin_05(f)


def is_adc_slit_nir(f):
    return is_adc_slit(f) and is_nir(f) and not is_opti5_pin_05(f)


def is_afc_ifu_uvb(f):
    return is_afc_ifu(f) and is_uvb(f)


def is_afc_ifu_vis(f):
    return is_afc_ifu(f) and is_vis(f)


def is_afc_ifu_nir(f):
    return is_afc_ifu(f) and is_nir(f)


# ASSOCIATION RULES
#  -  first, e.g.  ref=trigger (e.g. science)
#  -  second, e.g.  f=file to associate (e.g. calibration)

def match_nir_flat_to_dmap(ref, f):
    return match(ref, f, [kwd.det_chip_id, kwd.seq_arm, kwd.ins_opti2_id]) and \
        f[kwd.ins_opti5_name] != '0.9x11JH' and f[kwd.ins_opti5_name] != '0.6x11JH'


def assoc_flat_to_flex_nir(ref, f):
    return match(ref, f, [kwd.det_chip_id, kwd.seq_arm, kwd.ins_opti2_id]) and \
        (('JH' in ref[kwd.ins_opti5_name] and 'JH' in f[kwd.ins_opti5_name]) or
         ('JH' not in ref[kwd.ins_opti5_name] and 'JH' not in f[kwd.ins_opti5_name]))


def associate_flex(ref, f):
    return (ref[kwd.ins_opti2_name] == f[kwd.ins_opti2_name] or
            (ref[kwd.ins_opti2_name] == 'IFU' and f[kwd.ins_opti2_name] == 'SLOT')) and \
        ref[kwd.seq_arm] == f[kwd.seq_arm] and \
        (ref[kwd.obs_id] == f[kwd.obs_id] or ref[kwd.obs_container_id] == f[kwd.obs_container_id])
