from edps import subworkflow, task, SCIENCE, QC0, CALCHECKER, ReportInput

from .xshooter_association_rules import association_sky_rules, associate_dark_optical, associate_bias_science
from .xshooter_datasources import *
from .xshooter_task_functions import *


@subworkflow("science_slit", "")
def xshoo_science_slit(raw_stare, raw_offset, raw_nod, alternatives_spectral_format, bias, dark,
                       alternatives_flat, alternatives_dmap, alternatives_bp_map_rp, sky_line_list,
                       response_calib, atmos_ext, tell_mask, alternatives_flex, input_type,
                       additional_metatargets, reports):
    # This subworkflow process the input datasources defined by the input variables raw_stare, raw_offset, and raw_nod.
    # and associates the needed task (bias, dark, flats, wavelength, response, flexure correction) and (spectral_format,
    # line_list) static calibrations. The input type specifies the name of the task and the metatargets, and has to be
    # set according to the type of input data (science observations, telluric standards and flux standards when they
    # have to be treated as regular science observations). Additional meta targets can be specified with
    # additional_metatargets

    # Task to process slit stare observations
    science_slit_stare_tb = (task(input_type + "_slit_stare")
                             .with_recipe("xsh_scired_slit_stare")
                             .with_main_input(raw_stare)
                             .with_dynamic_parameter("arm", which_arm)
                             .with_dynamic_parameter("jh", which_jh)
                             .with_dynamic_parameter("ifu", which_ifu)
                             .with_alternative_associated_inputs(alternatives_spectral_format)
                             .with_associated_input(bias, [master_bias_uvb], condition=is_UVB, min_ret=1,
                                                    match_rules=associate_bias_science)
                             .with_associated_input(bias, [master_bias_vis], condition=is_VIS, min_ret=1,
                                                    match_rules=associate_bias_science)
                             .with_associated_input(bias, [master_bias_agc], condition=is_AGC, min_ret=1,
                                                    match_rules=associate_bias_science)
                             .with_associated_input(dark, [master_dark_nir], condition=is_NIR, min_ret=0)
                             .with_associated_input(dark, [master_dark_uvb], condition=use_dark_UVB, min_ret=0,
                                                    match_rules=associate_dark_optical)
                             .with_associated_input(dark, [master_dark_vis], condition=use_dark_VIS, min_ret=0,
                                                    match_rules=associate_dark_optical)
                             .with_alternative_associated_inputs(alternatives_flat)
                             .with_alternative_associated_inputs(alternatives_flex)
                             .with_alternative_associated_inputs(alternatives_dmap)
                             .with_alternative_associated_inputs(alternatives_bp_map_rp)
                             .with_associated_input(sky_line_list, condition=physical_mode, min_ret=0)
                             .with_alternative_associated_inputs(response_calib)
                             .with_associated_input(atmos_ext, min_ret=0)
                             .with_associated_input(tell_mask, min_ret=0)
                             .with_associated_input(sky_map_nir, min_ret=0, condition=is_NIR)
                             # .with_cluster('SKY.POSITION', max_diameter="max_diameter", max_separation="max_separation")
                             # .with_min_group_size(2)
                             .with_grouping_keywords([kwd.mjd_obs])
                             # .with_associated_input(raw_acquisition, min_ret=0, max_ret=2)
                             .with_input_filter(spectral_format_tab_uvb_class, spectral_format_tab_vis_class,
                                                spectral_format_tab_nir_class,
                                                master_bias_uvb, master_bias_vis, master_dark_vis, master_dark_uvb,
                                                master_dark_nir,
                                                master_flat_slit_uvb, master_flat_slit_vis, master_flat_slit_nir,
                                                order_tab_edges_slit_uvb, order_tab_edges_slit_vis,
                                                order_tab_edges_slit_nir,
                                                DISP_TAB_UVB, DISP_TAB_VIS, DISP_TAB_NIR, wave_tab_2d_uvb_class,
                                                wave_tab_2d_vis_class, wave_tab_2d_nir_class, xsh_mod_cfg_tab_uvb_class,
                                                xsh_mod_cfg_tab_vis_class, xsh_mod_cfg_tab_nir_class,
                                                sky_sub_bkpts_uvb_class,
                                                sky_sub_bkpts_vis_class, sky_sub_bkpts_nir_class, bp_map_nl_uvb,
                                                bp_map_nl_vis, bp_map_nl_nir, bp_map_rp_uvb_class, bp_map_rp_vis_class,
                                                bp_map_rp_nir_class,
                                                sky_line_list_uvb_class, sky_line_list_vis_class,
                                                sky_line_list_nir_class,
                                                response_merge1d_slit_uvb, response_merge1d_slit_vis,
                                                response_merge1d_slit_nir,
                                                atmos_ext_uvb_class, atmos_ext_vis_class, atmos_ext_nir_class,
                                                tell_mask_uvb_class,
                                                tell_mask_vis_class, tell_mask_nir_class,
                                                mresponse_merge1d_slit_uvb_class,
                                                mresponse_merge1d_slit_vis_class, mresponse_merge1d_slit_nir_class,
                                                xsh_mod_cfg_opt_afc_uvb, xsh_mod_cfg_opt_afc_vis,
                                                xsh_mod_cfg_opt_afc_nir,
                                                order_tab_afc_slit_uvb, order_tab_afc_slit_vis, order_tab_afc_slit_nir,
                                                disp_tab_afc_uvb, disp_tab_afc_vis, disp_tab_afc_nir,
                                                xsh_mod_cfg_opt_2d_uvb_class, xsh_mod_cfg_opt_2d_vis_class,
                                                xsh_mod_cfg_opt_2d_nir_class)
                             .with_meta_targets([input_type] + additional_metatargets))

    for report_name, report_inputs in reports.items():
        science_slit_stare_tb = (science_slit_stare_tb
                                 .with_report(report_name, report_inputs))

    # Task to process slit offset observations
    science_slit_offset_tb = (task(input_type + "_slit_offset")
                              .with_recipe("xsh_scired_slit_offset")
                              .with_main_input(raw_offset)
                              .with_dynamic_parameter("arm", which_arm)
                              .with_dynamic_parameter("jh", which_jh)
                              .with_dynamic_parameter("ifu", which_ifu)
                              .with_associated_input(dark, [master_dark_nir], condition=is_NIR, min_ret=0)
                              .with_associated_input(dark, [master_dark_uvb], condition=use_dark_UVB, min_ret=0,
                                                     match_rules=associate_dark_optical)
                              .with_associated_input(dark, [master_dark_vis], condition=use_dark_VIS, min_ret=0,
                                                     match_rules=associate_dark_optical)
                              .with_alternative_associated_inputs(alternatives_spectral_format)
                              .with_alternative_associated_inputs(alternatives_flat)
                              .with_associated_input(bias, [master_bias_uvb], condition=is_UVB, min_ret=1,
                                                     match_rules=associate_bias_science)
                              .with_associated_input(bias, [master_bias_vis], condition=is_VIS, min_ret=1,
                                                     match_rules=associate_bias_science)
                              .with_associated_input(bias, [master_bias_agc], condition=is_AGC, min_ret=1,
                                                     match_rules=associate_bias_science)
                              .with_alternative_associated_inputs(alternatives_flex)
                              .with_alternative_associated_inputs(alternatives_dmap)
                              .with_alternative_associated_inputs(alternatives_bp_map_rp)
                              .with_alternative_associated_inputs(response_calib)
                              .with_associated_input(tell_mask, min_ret=0)
                              .with_associated_input(sky_map_nir, min_ret=0, condition=is_NIR)
                              .with_associated_input(atmos_ext, min_ret=0)
                              .with_grouping_keywords([kwd.mjd_obs])
                              #    .with_associated_input(raw_acquisition, min_ret=0, max_ret=2)
                              .with_input_filter(spectral_format_tab_uvb_class, spectral_format_tab_vis_class,
                                                 spectral_format_tab_nir_class, master_bias_uvb, master_bias_vis,
                                                 master_flat_slit_uvb, master_flat_slit_vis, master_flat_slit_nir,
                                                 order_tab_edges_slit_uvb, order_tab_edges_slit_vis,
                                                 order_tab_edges_slit_nir,
                                                 order_tab_afc_slit_uvb, order_tab_afc_slit_vis, order_tab_afc_slit_nir,
                                                 DISP_TAB_UVB, DISP_TAB_VIS, DISP_TAB_NIR, wave_tab_2d_uvb_class,
                                                 wave_tab_2d_vis_class, wave_tab_2d_nir_class,
                                                 bp_map_nl_uvb, bp_map_nl_vis, bp_map_nl_nir, bp_map_rp_uvb_class,
                                                 bp_map_rp_vis_class, bp_map_rp_nir_class,
                                                 response_merge1d_slit_uvb, response_merge1d_slit_vis,
                                                 response_merge1d_slit_nir,
                                                 atmos_ext_uvb_class, atmos_ext_vis_class, atmos_ext_nir_class,
                                                 tell_mask_uvb_class, tell_mask_vis_class, tell_mask_nir_class,
                                                 mresponse_merge1d_slit_uvb_class, mresponse_merge1d_slit_vis_class,
                                                 mresponse_merge1d_slit_nir_class,
                                                 xsh_mod_cfg_opt_afc_uvb, xsh_mod_cfg_opt_afc_vis,
                                                 xsh_mod_cfg_opt_afc_nir,
                                                 xsh_mod_cfg_opt_2d_uvb_class, xsh_mod_cfg_opt_2d_vis_class,
                                                 xsh_mod_cfg_opt_2d_nir_class,
                                                 disp_tab_afc_uvb, disp_tab_afc_vis, disp_tab_afc_nir)
                              .with_meta_targets([input_type] + additional_metatargets))

    if input_type in ["science", "telluric_standard"]:
        science_slit_offset_tb = (science_slit_offset_tb
                                  .with_associated_input(raw_sky, match_rules=association_sky_rules,
                                                         condition=is_UVB_slit,
                                                         min_ret=1, max_ret=100)
                                  .with_associated_input(raw_sky, match_rules=association_sky_rules,
                                                         condition=is_VIS_slit,
                                                         min_ret=1, max_ret=100)
                                  .with_associated_input(raw_sky, match_rules=association_sky_rules,
                                                         condition=is_NIR_slit,
                                                         min_ret=1, max_ret=100))
    elif input_type == "flux_standard":
        science_slit_offset_tb = (science_slit_offset_tb
                                  .with_associated_input(raw_flux_sky_slit_off_uvb, match_rules=association_sky_rules,
                                                         condition=is_UVB_slit,
                                                         min_ret=1, max_ret=100)
                                  .with_associated_input(raw_flux_sky_slit_off_vis, match_rules=association_sky_rules,
                                                         condition=is_VIS_slit,
                                                         min_ret=1, max_ret=100)
                                  .with_associated_input(raw_flux_sky_slit_off_nir, match_rules=association_sky_rules,
                                                         condition=is_NIR_slit,
                                                         min_ret=1, max_ret=100)
                                  .with_input_map({raw_std_slit_off_uvb_class: raw_sci_slit_off_uvb_class,
                                                   raw_std_slit_off_vis_class: raw_sci_slit_off_vis_class,
                                                   raw_std_slit_off_nir_class: raw_sci_slit_off_nir_class}))
    for report_name, report_inputs in reports.items():
        science_slit_offset_tb = (science_slit_offset_tb
                                  .with_report(report_name, report_inputs))

    # Task to process slit nodding observations
    science_slit_nod_tb = (task(input_type + "_slit_nod")
                           .with_recipe("xsh_scired_slit_nod")
                           .with_main_input(raw_nod)
                           .with_dynamic_parameter("arm", which_arm)
                           .with_dynamic_parameter("jh", which_jh)
                           .with_dynamic_parameter("ifu", which_ifu)
                           .with_alternative_associated_inputs(alternatives_spectral_format)
                           .with_associated_input(bias, [master_bias_uvb], condition=is_UVB, min_ret=1,
                                                  match_rules=associate_bias_science)
                           .with_associated_input(bias, [master_bias_vis], condition=is_VIS, min_ret=1,
                                                  match_rules=associate_bias_science)
                           .with_associated_input(bias, [master_bias_agc], condition=is_AGC, min_ret=1,
                                                  match_rules=associate_bias_science)
                           .with_alternative_associated_inputs(alternatives_flat)
                           .with_alternative_associated_inputs(alternatives_dmap)
                           .with_alternative_associated_inputs(alternatives_bp_map_rp)
                           .with_alternative_associated_inputs(response_calib)
                           .with_associated_input(atmos_ext, min_ret=0)
                           .with_associated_input(tell_mask, min_ret=0)
                           .with_associated_input(sky_map_nir, min_ret=0, condition=is_NIR)
                           .with_associated_input(dark, [master_dark_nir], condition=is_NIR, min_ret=0)
                           .with_associated_input(dark, [master_dark_uvb], condition=use_dark_UVB, min_ret=0,
                                                  match_rules=associate_dark_optical)
                           .with_associated_input(dark, [master_dark_vis], condition=use_dark_VIS, min_ret=0,
                                                  match_rules=associate_dark_optical)
                           .with_alternative_associated_inputs(alternatives_flex)
                           # .with_cluster('SKY.POSITION', max_diameter="max_diameter", max_separation="max_separation")
                           # .with_min_group_size(2)
                           .with_grouping_keywords([kwd.mjd_obs])
                           #     .with_associated_input(raw_acquisition, min_ret=0, max_ret=2)
                           .with_input_filter(spectral_format_tab_uvb_class, spectral_format_tab_vis_class,
                                              spectral_format_tab_nir_class, master_bias_uvb, master_bias_vis,
                                              master_flat_slit_uvb, master_flat_slit_vis, master_flat_slit_nir,
                                              order_tab_edges_slit_uvb, order_tab_edges_slit_vis,
                                              order_tab_edges_slit_nir,
                                              DISP_TAB_UVB, DISP_TAB_VIS, DISP_TAB_NIR, wave_tab_2d_uvb_class,
                                              wave_tab_2d_vis_class, wave_tab_2d_nir_class,
                                              bp_map_nl_uvb, bp_map_nl_vis, bp_map_nl_nir, bp_map_rp_uvb_class,
                                              bp_map_rp_vis_class, bp_map_rp_nir_class,
                                              response_merge1d_slit_uvb, response_merge1d_slit_vis,
                                              response_merge1d_slit_nir, WAVE_MAP_NIR, WAVE_MAP_VIS, WAVE_MAP_UVB,
                                              atmos_ext_uvb_class, atmos_ext_vis_class, atmos_ext_nir_class,
                                              tell_mask_uvb_class, xsh_mod_cfg_tab_uvb_class, xsh_mod_cfg_tab_vis_class,
                                              xsh_mod_cfg_tab_nir_class,
                                              xsh_mod_cfg_opt_afc_nir, disp_tab_afc_uvb, disp_tab_afc_vis,
                                              disp_tab_afc_nir,
                                              xsh_mod_cfg_opt_2d_uvb_class, xsh_mod_cfg_opt_2d_vis_class,
                                              xsh_mod_cfg_opt_2d_nir_class, xsh_mod_cfg_opt_afc_uvb,
                                              tell_mask_vis_class, tell_mask_nir_class, xsh_mod_cfg_opt_afc_vis,
                                              mresponse_merge1d_slit_uvb_class, mresponse_merge1d_slit_vis_class,
                                              mresponse_merge1d_slit_nir_class)
                           .with_meta_targets([input_type] + additional_metatargets))

    for report_name, report_inputs in reports.items():
        science_slit_nod_tb = (science_slit_nod_tb
                               .with_report(report_name, report_inputs))

    # removing the "xshooter_science" report for telluric_standards if the
    # idp_parameters set is loaded.
    if input_type == "telluric_standard":
        # Note: the select_reports job processing function includes the fix_setup_keywords
        # processing function
        science_slit_stare_tb = (science_slit_stare_tb
                                 .with_job_processing(select_reports))
        science_slit_offset_tb = (science_slit_offset_tb
                                  .with_job_processing(select_reports))
        science_slit_nod_tb = (science_slit_nod_tb
                               .with_job_processing(select_reports))
    else:
        science_slit_stare_tb = (science_slit_stare_tb
                                 .with_job_processing(fix_setup_keywords))
        science_slit_offset_tb = (science_slit_offset_tb
                                  .with_job_processing(fix_setup_keywords))
        science_slit_nod_tb = (science_slit_nod_tb
                               .with_job_processing(fix_setup_keywords))

    return science_slit_stare_tb.build(), science_slit_offset_tb.build(), science_slit_nod_tb.build()


@subworkflow("science_ifu", "")
def xshoo_science_ifu(alternatives_spectral_format, bias, dark, alternatives_flat,
                      dmap, alternatives_bp_map_rp, alternatives_flex):
    # This subworkflow processes science observations taken in IFU mode

    science_ifu_stare = (task("science_ifu_stare")
                         .with_recipe('xsh_scired_ifu_stare')
                         .with_main_input(raw_science_ifu_stare)
                         .with_dynamic_parameter("arm", which_arm)
                         .with_dynamic_parameter("jh", which_jh)
                         .with_dynamic_parameter("ifu", which_ifu)
                         .with_alternative_associated_inputs(alternatives_spectral_format)
                         .with_associated_input(bias, [master_bias_uvb], condition=is_UVB, min_ret=1,
                                                match_rules=associate_bias_science)
                         .with_associated_input(bias, [master_bias_vis], condition=is_VIS, min_ret=1,
                                                match_rules=associate_bias_science)
                         .with_associated_input(bias, [master_bias_agc], condition=is_AGC, min_ret=1,
                                                match_rules=associate_bias_science)
                         .with_associated_input(dark, [master_dark_nir], condition=is_NIR, min_ret=0)
                         .with_associated_input(dark, [master_dark_uvb], condition=use_dark_UVB, min_ret=0,
                                                match_rules=associate_dark_optical)
                         .with_associated_input(dark, [master_dark_vis], condition=use_dark_VIS, min_ret=0,
                                                match_rules=associate_dark_optical)
                         .with_alternative_associated_inputs(alternatives_flat)
                         .with_alternative_associated_inputs(alternatives_flex)
                         .with_alternative_associated_inputs(alternatives_bp_map_rp)
                         .with_associated_input(sky_map_nir, min_ret=0, condition=is_NIR)
                         # .with_associated_input(raw_acquisition, min_ret=0, max_ret=2)
                         .with_job_processing(fix_setup_keywords)
                         .with_input_filter(spectral_format_tab_uvb_class, spectral_format_tab_vis_class,
                                            master_bias_uvb, master_bias_vis, master_dark_uvb, master_dark_vis,
                                            master_dark_nir, xsh_mod_cfg_tab_nir_class, xsh_mod_cfg_tab_vis_class,
                                            xsh_mod_cfg_opt_2d_uvb_class, xsh_mod_cfg_opt_2d_vis_class,
                                            xsh_mod_cfg_opt_2d_nir_class,
                                            xsh_mod_cfg_opt_afc_uvb, xsh_mod_cfg_opt_afc_vis, xsh_mod_cfg_opt_afc_nir,
                                            xsh_mod_cfg_tab_uvb_class, WAVE_TAB_AFC_VIS, WAVE_TAB_AFC_NIR,
                                            spectral_format_tab_nir_class, master_flat_ifu_uvb, master_flat_ifu_vis,
                                            master_flat_ifu_nir, order_tab_edges_ifu_uvb, order_tab_edges_ifu_vis,
                                            order_tab_edges_ifu_nir, WAVE_TAB_ARC_IFU_UP_UVB, WAVE_TAB_ARC_IFU_CEN_UVB,
                                            WAVE_TAB_ARC_IFU_DOWN_UVB, WAVE_TAB_ARC_IFU_UP_VIS,
                                            WAVE_TAB_ARC_IFU_CEN_VIS,
                                            WAVE_TAB_ARC_IFU_DOWN_VIS, WAVE_TAB_ARC_IFU_UP_NIR,
                                            WAVE_TAB_ARC_IFU_CEN_NIR,
                                            WAVE_TAB_ARC_IFU_DOWN_NIR, DISP_TAB_NIR, DISP_TAB_UVB, DISP_TAB_VIS,
                                            bp_map_nl_uvb, bp_map_nl_vis, bp_map_nl_nir, bp_map_rp_uvb_class,
                                            bp_map_rp_vis_class, bp_map_rp_nir_class)
                         .with_meta_targets([SCIENCE, QC0, CALCHECKER])
                         .build())

    science_ifu_offset = (task('science_ifu_offset')
                          .with_recipe('xsh_scired_ifu_offset')
                          .with_dynamic_parameter('arm', which_arm)
                          .with_dynamic_parameter('jh', which_jh)
                          .with_dynamic_parameter('ifu', which_ifu)
                          .with_main_input(raw_science_ifu_offset)
                          .with_associated_input(raw_sky, match_rules=association_sky_rules, condition=is_UVB_ifu,
                                                 max_ret=100)
                          .with_associated_input(raw_sky, match_rules=association_sky_rules, condition=is_VIS_ifu,
                                                 max_ret=100)
                          .with_associated_input(raw_sky, match_rules=association_sky_rules, condition=is_NIR_ifu,
                                                 max_ret=100)
                          .with_alternative_associated_inputs(alternatives_spectral_format)
                          .with_associated_input(bias, [master_bias_uvb], condition=is_UVB, min_ret=1,
                                                 match_rules=associate_bias_science)
                          .with_associated_input(bias, [master_bias_vis], condition=is_VIS, min_ret=1,
                                                 match_rules=associate_bias_science)
                          .with_associated_input(bias, [master_bias_agc], condition=is_AGC, min_ret=1,
                                                 match_rules=associate_bias_science)
                          .with_associated_input(dark, [master_dark_nir], condition=is_NIR, min_ret=0)
                          .with_associated_input(dark, [master_dark_uvb], condition=use_dark_UVB, min_ret=0,
                                                 match_rules=associate_dark_optical)
                          .with_associated_input(dark, [master_dark_vis], condition=use_dark_VIS, min_ret=0,
                                                 match_rules=associate_dark_optical)
                          .with_alternative_associated_inputs(alternatives_flat)
                          .with_alternative_associated_inputs(alternatives_bp_map_rp)
                          .with_alternative_associated_inputs(alternatives_flex)
                          .with_associated_input(ifu_cfg_tab)
                          .with_associated_input(dmap, [DISP_TAB_UVB, WAVE_MAP_UVB, xsh_mod_cfg_opt_2d_uvb_class],
                                                 condition=is_UVB, min_ret=0)
                          .with_associated_input(dmap, [DISP_TAB_VIS, WAVE_MAP_VIS, xsh_mod_cfg_opt_2d_vis_class],
                                                 condition=is_VIS, min_ret=0)
                          .with_associated_input(dmap, [DISP_TAB_NIR, WAVE_MAP_NIR, xsh_mod_cfg_opt_2d_nir_class],
                                                 condition=is_NIR, min_ret=0)
                          .with_associated_input(sky_map_nir, min_ret=0, condition=is_NIR)
                          #  .with_associated_input(raw_acquisition, min_ret=0, max_ret=2)
                          .with_job_processing(fix_setup_keywords)
                          .with_input_filter(spectral_format_tab_uvb_class, spectral_format_tab_vis_class,
                                             spectral_format_tab_nir_class, master_flat_ifu_uvb, master_flat_ifu_vis,
                                             master_flat_ifu_nir, order_tab_edges_ifu_uvb, order_tab_edges_ifu_vis,
                                             order_tab_afc_slit_uvb, order_tab_afc_slit_vis, order_tab_afc_slit_nir,
                                             order_tab_edges_ifu_nir, WAVE_TAB_ARC_IFU_UP_UVB, WAVE_TAB_ARC_IFU_CEN_UVB,
                                             WAVE_TAB_ARC_IFU_DOWN_UVB, WAVE_TAB_ARC_IFU_UP_VIS,
                                             WAVE_TAB_ARC_IFU_CEN_VIS, WAVE_TAB_ARC_IFU_DOWN_VIS,
                                             WAVE_TAB_ARC_IFU_UP_NIR,
                                             WAVE_TAB_ARC_IFU_CEN_NIR, WAVE_TAB_ARC_IFU_DOWN_NIR,
                                             DISP_TAB_NIR, DISP_TAB_UVB, DISP_TAB_VIS,
                                             bp_map_nl_uvb, bp_map_nl_vis, bp_map_nl_nir, bp_map_rp_uvb_class,
                                             bp_map_rp_vis_class, bp_map_rp_nir_class, WAVE_MAP_UVB, WAVE_MAP_VIS,
                                             WAVE_MAP_NIR,
                                             xsh_mod_cfg_opt_2d_uvb_class, xsh_mod_cfg_opt_2d_vis_class,
                                             xsh_mod_cfg_opt_2d_nir_class,
                                             xsh_mod_cfg_opt_afc_uvb, xsh_mod_cfg_opt_afc_vis, xsh_mod_cfg_opt_afc_nir,
                                             disp_tab_afc_uvb, disp_tab_afc_vis, disp_tab_afc_nir,
                                             ifu_cfg_tab_uvb_class, ifu_cfg_tab_vis_class, ifu_cfg_tab_nir_class)
                          .with_meta_targets([SCIENCE, QC0, CALCHECKER])
                          .build())

    return science_ifu_stare, science_ifu_offset
