from edps import subworkflow, task, match_rules, copy_upstream, FilterMode

from .xshooter_classification import *
from .xshooter_task_functions import *


@subworkflow('spectra_combination', "")
def spectra_combination(raw_spectra_to_combine, spc_stare, spc_offset, spc_nod,
                        spc_stare_tc, spc_offset_tc, spc_nod_tc, input_type, additional_metatargets=None):
    # This sub-worflow combines spectra selected according to the grouping rule defined in the datasources
    # of raw_spectra_to_combine. Note that the raw_spectra_to_combine are only used for the selection, but
    # the processed data passed from the associated input tasks spc_stare, spc_offset, spc_nod,
    # spc_stare_tc, spc_offset_tc, spc_nod_tc are combined. The input_type specifies the name
    # of the output task of this subworkflow and the meta targets. Additional meta targets can be specified
    # with additional_metatargets.

    additional_metatargets = additional_metatargets or []

    combination_criterion = (match_rules()
                             .with_match_keywords([kwd.seq_arm, kwd.obs_targ_name]))

    # This task collects all the products of the science reduction tasks. The main input is a datasource
    # that contains all the raw frames whose products are meant to be combined.
    # It is used to select the tasks that processed these data, and copy them to the output.
    #
    # The input_type is used to define the task and meta-target names and should be set according to the input
    # of this subworkflow.

    selection = (task("select_" + input_type + "_to_combine")
                 .with_main_input(raw_spectra_to_combine)
                 .with_associated_input(spc_stare, match_rules=combination_criterion,
                                        condition=avoid_telluric_correction, min_ret=0, max_ret=1000)
                 .with_associated_input(spc_offset, match_rules=combination_criterion,
                                        condition=avoid_telluric_correction, min_ret=0, max_ret=1000)
                 .with_associated_input(spc_nod, match_rules=combination_criterion,
                                        condition=avoid_telluric_correction, min_ret=0, max_ret=1000)
                 .with_associated_input(spc_stare_tc, match_rules=combination_criterion,
                                        condition=attempt_telluric_correction, min_ret=0, max_ret=1000)
                 .with_associated_input(spc_offset_tc, match_rules=combination_criterion,
                                        condition=attempt_telluric_correction, min_ret=0, max_ret=1000)
                 .with_associated_input(spc_nod_tc, match_rules=combination_criterion,
                                        condition=attempt_telluric_correction, min_ret=0, max_ret=1000)
                 .with_function(copy_upstream)
                 .with_min_group_size(2)
                 .build())

    # Here the actual combination is done. The combination task is named according to the input_type.
    combination = (task(input_type + "_combination")
                   .with_main_input(selection)
                   .with_function(combine_spectra)
                   .with_input_filter(SCI_SLIT_FLUX_IDP_UVB, SCI_SLIT_FLUX_IDP_VIS, SCI_SLIT_FLUX_IDP_NIR,
                                      SCI_SLIT_IDP_UVB, SCI_SLIT_IDP_VIS, SCI_SLIT_IDP_NIR,
                                      SCI_IDP_UVB, SCI_IDP_VIS, SCI_IDP_NIR,
                                      TELL_IDP_UVB, TELL_IDP_VIS, TELL_IDP_NIR,
                                      STD_IDP_UVB, STD_IDP_VIS, STD_IDP_NIR,
                                      TELLURIC_CORR_VIS, TELLURIC_CORR_NIR,
                                      mode=FilterMode.SELECT)
                   .with_meta_targets([input_type + "_combination"] + additional_metatargets)
                   .build())

    return combination, selection
