from edps import subworkflow, task, QC1_CALIB, CALCHECKER, ReportInput

from .xshooter_association_rules import associate_bias_cals, associate_predict_to_2dmap
from .xshooter_datasources import *
from .xshooter_task_functions import *


@subworkflow('wavelength_calibration', "")
def wavelength_calibration(bias, alternatives_flats_for_dmap, predict, alternatives_spectral_format,
                           alternatives_flats_for_arcs):
    # The task creates a wavelength and spatial resampling solution, and a clean arc line list
    # If a master calibration is used as associated input, it needs to match the arm
    # of the main input. This is the reason why there are conditions for associated and alternative input.
    # If the input from an upstream task instead, the proper match is taken care of by the match rule.
    wavelength_calibration_2d = (task("wavelength_calibration_2d")
                                 .with_recipe('xsh_2dmap')
                                 .with_report('xshooter_rawdisp', ReportInput.RECIPE_INPUTS)
                                 .with_report('xshooter_wavelength', ReportInput.RECIPE_INPUTS_OUTPUTS)
                                 .with_main_input(raw_wave)
                                 .with_dynamic_parameter("arm", which_arm)
                                 .with_dynamic_parameter("jh", which_jh)
                                 .with_dynamic_parameter("ifu", which_ifu)
                                 .with_associated_input(bias, [master_bias_uvb], condition=is_UVB, min_ret=1,
                                                        match_rules=associate_bias_cals)
                                 .with_associated_input(bias, [master_bias_vis], condition=is_VIS, min_ret=1,
                                                        match_rules=associate_bias_cals)
                                 .with_associated_input(raw_wave_nir_off, condition=is_NIR)
                                 .with_alternative_associated_inputs(alternatives_flats_for_dmap)
                                 .with_associated_input(predict, [xsh_mod_cfg_opt_fmt_uvb], condition=is_UVB,
                                                        match_rules=associate_predict_to_2dmap)
                                 .with_associated_input(predict, [xsh_mod_cfg_opt_fmt_vis], condition=is_VIS,
                                                        match_rules=associate_predict_to_2dmap)
                                 .with_associated_input(predict, [xsh_mod_cfg_opt_fmt_nir], condition=is_NIR,
                                                        match_rules=associate_predict_to_2dmap)
                                 .with_alternative_associated_inputs(alternatives_spectral_format)
                                 .with_associated_input(arc_line_list)
                                 .with_associated_input(arc_line_list_intmon)
                                 .with_associated_input(bp_map_rp_nir, condition=is_NIR)
                                 .with_job_processing(set_map2d_parameters)
                                 .with_input_filter(bp_map_nl_uvb, master_bias_uvb, order_tab_edges_slit_uvb,
                                                    xsh_mod_cfg_opt_fmt_uvb,
                                                    bp_map_rp_uvb_class, arc_line_list_uvb_class,
                                                    spectral_format_tab_uvb_class,
                                                    bp_map_nl_vis, master_bias_vis, order_tab_edges_slit_vis,
                                                    xsh_mod_cfg_opt_fmt_vis,
                                                    bp_map_rp_vis_class, arc_line_list_vis_class,
                                                    spectral_format_tab_vis_class,
                                                    bp_map_nl_nir, order_tab_edges_slit_nir, xsh_mod_cfg_opt_fmt_nir,
                                                    bp_map_rp_nir_class, arc_line_list_nir_class,
                                                    spectral_format_tab_nir_class)
                                 .with_meta_targets([QC1_CALIB, CALCHECKER])
                                 .build())

    alternatives_dmap = (alternative_associated_inputs()
                         .with_associated_input(wavelength_calibration_2d, [xsh_mod_cfg_opt_2d_uvb, DISP_TAB_UVB],
                                                condition=is_UVB)
                         .with_associated_input(wavelength_calibration_2d, [xsh_mod_cfg_opt_2d_vis, DISP_TAB_VIS],
                                                condition=is_VIS)
                         .with_associated_input(wavelength_calibration_2d, [xsh_mod_cfg_opt_2d_nir, DISP_TAB_NIR],
                                                condition=is_NIR))

    # Task to process the raw arc exposures. It computes arclines tilt and instrumental resolution.
    # Not used for further processing.
    # If a master calibration is used as associated input, it needs to match the arm
    # arm of the main input. This is the reason why there are conditions for associated and alternative inputs.
    # If the input from an upstream task instead, the proper match is taken care of by the match rule.
    arc = (task("arc")
           .with_recipe('xsh_wavecal')
           .with_report('xshooter_rawdisp', ReportInput.RECIPE_INPUTS)
           .with_report('xshooter_wavelength', ReportInput.RECIPE_INPUTS_OUTPUTS)
           .with_main_input(raw_arc)
           .with_dynamic_parameter("arm", which_arm)
           .with_dynamic_parameter("jh", which_jh)
           .with_dynamic_parameter("ifu", which_ifu)
           .with_associated_input(raw_arc_slit_nir_off, condition=is_NIR_slit)
           .with_associated_input(raw_arc_ifu_nir_off, condition=is_NIR_ifu)
           .with_associated_input(bias, [master_bias_uvb], condition=is_UVB, min_ret=1,
                                  match_rules=associate_bias_cals)
           .with_associated_input(bias, [master_bias_vis], condition=is_VIS, min_ret=1,
                                  match_rules=associate_bias_cals)
           .with_alternative_associated_inputs(alternatives_flats_for_arcs)
           .with_alternative_associated_inputs(alternatives_dmap)
           .with_associated_input(arc_line_list)
           .with_alternative_associated_inputs(alternatives_spectral_format)
           .with_associated_input(bp_map_rp_nir, condition=is_NIR)
           .with_input_filter(bp_map_nl_uvb, master_bias_uvb, order_tab_edges_slit_uvb,
                              xsh_mod_cfg_opt_2d_uvb, DISP_TAB_UVB, bp_map_rp_uvb_class, arc_line_list_uvb_class,
                              spectral_format_tab_uvb_class, bp_map_nl_vis, master_bias_vis, order_tab_edges_slit_vis,
                              xsh_mod_cfg_opt_2d_vis, DISP_TAB_VIS, bp_map_rp_vis_class, arc_line_list_vis_class,
                              spectral_format_tab_vis_class, bp_map_nl_nir, order_tab_edges_slit_nir,
                              xsh_mod_cfg_opt_2d_nir, DISP_TAB_NIR, bp_map_rp_nir_class, arc_line_list_nir_class,
                              arc_slit_nir_off_class, spectral_format_tab_nir_class,
                              order_tab_edges_ifu_uvb, order_tab_edges_ifu_vis, order_tab_edges_ifu_nir,
                              arc_ifu_nir_off_class, spectral_format_tab_nir_jh_class)
           .with_job_processing(set_wavecal_parameters)
           .with_meta_targets([QC1_CALIB])
           .build())

    return wavelength_calibration_2d, alternatives_dmap, arc
