/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.base;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleSecurityException;
import org.apache.guacamole.auth.jdbc.base.ModeledDirectoryObject;
import org.apache.guacamole.auth.jdbc.base.ModeledObject;
import org.apache.guacamole.auth.jdbc.base.ObjectModel;
import org.apache.guacamole.auth.jdbc.base.ObjectRelationMapper;
import org.apache.guacamole.auth.jdbc.base.RestrictedObject;
import org.apache.guacamole.auth.jdbc.user.ModeledAuthenticatedUser;
import org.apache.guacamole.auth.jdbc.user.UserModel;
import org.apache.guacamole.net.auth.permission.ObjectPermission;
import org.apache.guacamole.net.auth.permission.ObjectPermissionSet;

public abstract class RelatedObjectSet<ParentObjectType extends ModeledDirectoryObject<ParentModelType>, ParentModelType extends ObjectModel>
extends RestrictedObject
implements org.apache.guacamole.net.auth.RelatedObjectSet {
    private ParentObjectType parent;

    public void init(ModeledAuthenticatedUser currentUser, ParentObjectType parent) {
        super.init(currentUser);
        this.parent = parent;
    }

    protected abstract ObjectRelationMapper<ParentModelType> getObjectRelationMapper();

    protected abstract ObjectPermissionSet getParentObjectEffectivePermissionSet() throws GuacamoleException;

    protected abstract ObjectPermissionSet getChildObjectEffectivePermissionSet() throws GuacamoleException;

    private boolean canAlterRelation(Collection<String> identifiers) throws GuacamoleException {
        if (this.getCurrentUser().getUser().isAdministrator()) {
            return true;
        }
        if (!this.getParentObjectEffectivePermissionSet().hasPermission(ObjectPermission.Type.UPDATE, ((ModeledDirectoryObject)this.parent).getIdentifier())) {
            return false;
        }
        Collection accessibleIdentifiers = this.getChildObjectEffectivePermissionSet().getAccessibleObjects(Collections.singleton(ObjectPermission.Type.UPDATE), identifiers);
        return accessibleIdentifiers.size() == identifiers.size();
    }

    public Set<String> getObjects() throws GuacamoleException {
        ModeledAuthenticatedUser user = this.getCurrentUser();
        if (user.getUser().isAdministrator()) {
            return this.getObjectRelationMapper().selectChildIdentifiers((ObjectModel)((ModeledObject)this.parent).getModel());
        }
        return this.getObjectRelationMapper().selectReadableChildIdentifiers((UserModel)user.getUser().getModel(), user.getEffectiveUserGroups(), (ObjectModel)((ModeledObject)this.parent).getModel());
    }

    public void addObjects(Set<String> identifiers) throws GuacamoleException {
        if (identifiers.isEmpty()) {
            return;
        }
        if (!this.canAlterRelation(identifiers)) {
            throw new GuacamoleSecurityException("Permission denied.");
        }
        this.getObjectRelationMapper().insert((ObjectModel)((ModeledObject)this.parent).getModel(), identifiers);
    }

    public void removeObjects(Set<String> identifiers) throws GuacamoleException {
        if (identifiers.isEmpty()) {
            return;
        }
        if (!this.canAlterRelation(identifiers)) {
            throw new GuacamoleSecurityException("Permission denied.");
        }
        this.getObjectRelationMapper().delete((ObjectModel)((ModeledObject)this.parent).getModel(), identifiers);
    }
}

