/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.sqlserver;

import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.jdbc.JDBCEnvironment;
import org.apache.guacamole.auth.jdbc.security.PasswordPolicy;
import org.apache.guacamole.auth.sqlserver.SQLServerDriver;
import org.apache.guacamole.auth.sqlserver.SQLServerGuacamoleProperties;
import org.apache.guacamole.auth.sqlserver.SQLServerPasswordPolicy;
import org.apache.guacamole.properties.GuacamoleProperty;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLServerEnvironment
extends JDBCEnvironment {
    private static final Logger logger = LoggerFactory.getLogger(SQLServerEnvironment.class);
    private static final String DEFAULT_HOSTNAME = "localhost";
    private static final int DEFAULT_PORT = 1433;
    private static final boolean DEFAULT_USER_REQUIRED = false;
    private static final int DEFAULT_ABSOLUTE_MAX_CONNECTIONS = 0;
    private static final int DEFAULT_MAX_CONNECTIONS_PER_USER = 1;
    private static final int DEFAULT_MAX_GROUP_CONNECTIONS_PER_USER = 1;
    private static final int DEFAULT_MAX_CONNECTIONS = 0;
    private static final int DEFAULT_MAX_GROUP_CONNECTIONS = 0;
    public static final SQLServerDriver SQLSERVER_DEFAULT_DRIVER = SQLServerDriver.MICROSOFT_2005;

    @Override
    public boolean isUserRequired() throws GuacamoleException {
        return (Boolean)this.getProperty((GuacamoleProperty)SQLServerGuacamoleProperties.SQLSERVER_USER_REQUIRED, false);
    }

    @Override
    public int getAbsoluteMaxConnections() throws GuacamoleException {
        return (Integer)this.getProperty((GuacamoleProperty)SQLServerGuacamoleProperties.SQLSERVER_ABSOLUTE_MAX_CONNECTIONS, 0);
    }

    @Override
    public int getDefaultMaxConnections() throws GuacamoleException {
        return (Integer)this.getProperty((GuacamoleProperty)SQLServerGuacamoleProperties.SQLSERVER_DEFAULT_MAX_CONNECTIONS, 0);
    }

    @Override
    public int getDefaultMaxGroupConnections() throws GuacamoleException {
        return (Integer)this.getProperty((GuacamoleProperty)SQLServerGuacamoleProperties.SQLSERVER_DEFAULT_MAX_GROUP_CONNECTIONS, 0);
    }

    @Override
    public int getDefaultMaxConnectionsPerUser() throws GuacamoleException {
        return (Integer)this.getProperty((GuacamoleProperty)SQLServerGuacamoleProperties.SQLSERVER_DEFAULT_MAX_CONNECTIONS_PER_USER, 1);
    }

    @Override
    public int getDefaultMaxGroupConnectionsPerUser() throws GuacamoleException {
        return (Integer)this.getProperty((GuacamoleProperty)SQLServerGuacamoleProperties.SQLSERVER_DEFAULT_MAX_GROUP_CONNECTIONS_PER_USER, 1);
    }

    @Override
    public PasswordPolicy getPasswordPolicy() {
        return new SQLServerPasswordPolicy(this);
    }

    public String getSQLServerHostname() throws GuacamoleException {
        return (String)this.getProperty((GuacamoleProperty)SQLServerGuacamoleProperties.SQLSERVER_HOSTNAME, DEFAULT_HOSTNAME);
    }

    public int getSQLServerPort() throws GuacamoleException {
        return (Integer)this.getProperty((GuacamoleProperty)SQLServerGuacamoleProperties.SQLSERVER_PORT, 1433);
    }

    public String getSQLServerDatabase() throws GuacamoleException {
        return (String)this.getRequiredProperty((GuacamoleProperty)SQLServerGuacamoleProperties.SQLSERVER_DATABASE);
    }

    public String getSQLServerUsername() throws GuacamoleException {
        return (String)this.getRequiredProperty((GuacamoleProperty)SQLServerGuacamoleProperties.SQLSERVER_USERNAME);
    }

    public String getSQLServerPassword() throws GuacamoleException {
        return (String)this.getRequiredProperty((GuacamoleProperty)SQLServerGuacamoleProperties.SQLSERVER_PASSWORD);
    }

    public SQLServerDriver getSQLServerDriver() throws GuacamoleException {
        return (SQLServerDriver)((Object)this.getProperty(SQLServerGuacamoleProperties.SQLSERVER_DRIVER, (Object)SQLSERVER_DEFAULT_DRIVER));
    }

    @Override
    public boolean isRecursiveQuerySupported(SqlSession session) {
        return true;
    }
}

