/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.tunnel;

import com.google.common.collect.ConcurrentHashMultiset;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.guacamole.GuacamoleClientTooManyException;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleResourceConflictException;
import org.apache.guacamole.auth.jdbc.JDBCEnvironment;
import org.apache.guacamole.auth.jdbc.connection.ModeledConnection;
import org.apache.guacamole.auth.jdbc.connectiongroup.ModeledConnectionGroup;
import org.apache.guacamole.auth.jdbc.tunnel.AbstractGuacamoleTunnelService;
import org.apache.guacamole.auth.jdbc.tunnel.Seat;
import org.apache.guacamole.auth.jdbc.user.RemoteAuthenticatedUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RestrictedGuacamoleTunnelService
extends AbstractGuacamoleTunnelService {
    private static final Logger logger = LoggerFactory.getLogger(RestrictedGuacamoleTunnelService.class);
    @Inject
    private JDBCEnvironment environment;
    private final ConcurrentHashMultiset<Seat> activeSeats = ConcurrentHashMultiset.create();
    private final ConcurrentHashMultiset<String> activeConnections = ConcurrentHashMultiset.create();
    private final ConcurrentHashMultiset<Seat> activeGroupSeats = ConcurrentHashMultiset.create();
    private final ConcurrentHashMultiset<String> activeGroups = ConcurrentHashMultiset.create();
    private final AtomicInteger totalActiveConnections = new AtomicInteger(0);

    private <T> boolean tryAdd(ConcurrentHashMultiset<T> multiset, T value, int max) {
        int count;
        do {
            if ((count = multiset.count(value)) < max || max == 0) continue;
            return false;
        } while (!multiset.setCount(value, count, count + 1));
        return true;
    }

    private boolean tryIncrement(AtomicInteger counter, int max) {
        int count;
        do {
            if ((count = counter.get()) < max || max == 0) continue;
            return false;
        } while (!counter.compareAndSet(count, count + 1));
        return true;
    }

    @Override
    protected ModeledConnection acquire(RemoteAuthenticatedUser user, List<ModeledConnection> connections, boolean includeFailoverOnly) throws GuacamoleException {
        if (!this.tryIncrement(this.totalActiveConnections, this.environment.getAbsoluteMaxConnections())) {
            throw new GuacamoleResourceConflictException("Cannot connect. Overall maximum connections reached.");
        }
        String username = user.getIdentifier();
        ModeledConnection[] sortedConnections = connections.toArray(new ModeledConnection[connections.size()]);
        Arrays.sort(sortedConnections, new Comparator<ModeledConnection>(){

            @Override
            public int compare(ModeledConnection a, ModeledConnection b) {
                int calcWeightB;
                int connA = RestrictedGuacamoleTunnelService.this.getActiveConnections(a).size();
                int connB = RestrictedGuacamoleTunnelService.this.getActiveConnections(b).size();
                int weightA = a.getConnectionWeight();
                int weightB = b.getConnectionWeight();
                int calcWeightA = connA * weightB;
                if (calcWeightA == (calcWeightB = connB * weightA)) {
                    return weightA - weightB;
                }
                return calcWeightA - calcWeightB;
            }
        });
        boolean userSpecificFailure = true;
        for (ModeledConnection connection : sortedConnections) {
            Seat seat;
            if (connection.getConnectionWeight() < 1) {
                logger.debug("Weight for {} is < 1, connection will be skipped.", (Object)connection.getName());
                continue;
            }
            if (!includeFailoverOnly && connection.isFailoverOnly() || !this.tryAdd(this.activeSeats, seat = new Seat(username, connection.getIdentifier()), connection.getMaxConnectionsPerUser())) continue;
            if (this.tryAdd(this.activeConnections, connection.getIdentifier(), connection.getMaxConnections())) {
                return connection;
            }
            this.activeSeats.remove(seat);
            userSpecificFailure = false;
        }
        this.totalActiveConnections.decrementAndGet();
        if (userSpecificFailure) {
            throw new GuacamoleClientTooManyException("Cannot connect. Connection already in use by this user.");
        }
        throw new GuacamoleResourceConflictException("Cannot connect. This connection is in use.");
    }

    @Override
    protected void release(RemoteAuthenticatedUser user, ModeledConnection connection) {
        this.activeSeats.remove(new Seat(user.getIdentifier(), connection.getIdentifier()));
        this.activeConnections.remove(connection.getIdentifier());
        this.totalActiveConnections.decrementAndGet();
    }

    @Override
    protected void acquire(RemoteAuthenticatedUser user, ModeledConnectionGroup connectionGroup) throws GuacamoleException {
        String username = user.getIdentifier();
        Seat seat = new Seat(username, connectionGroup.getIdentifier());
        if (this.tryAdd(this.activeGroupSeats, seat, connectionGroup.getMaxConnectionsPerUser())) {
            if (this.tryAdd(this.activeGroups, connectionGroup.getIdentifier(), connectionGroup.getMaxConnections())) {
                return;
            }
            this.activeGroupSeats.remove(seat);
            throw new GuacamoleResourceConflictException("Cannot connect. This connection group is in use.");
        }
        throw new GuacamoleClientTooManyException("Cannot connect. Connection group already in use by this user.");
    }

    @Override
    protected void release(RemoteAuthenticatedUser user, ModeledConnectionGroup connectionGroup) {
        this.activeGroupSeats.remove(new Seat(user.getIdentifier(), connectionGroup.getIdentifier()));
        this.activeGroups.remove(connectionGroup.getIdentifier());
    }
}

