/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.mysql;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.util.Properties;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.mysql.MySQLEnvironment;
import org.mybatis.guice.datasource.helper.JdbcHelper;

public class MySQLAuthenticationProviderModule
implements Module {
    private final Properties myBatisProperties = new Properties();
    private final Properties driverProperties = new Properties();

    public MySQLAuthenticationProviderModule(MySQLEnvironment environment) throws GuacamoleException {
        this.myBatisProperties.setProperty("mybatis.environment.id", "guacamole");
        this.myBatisProperties.setProperty("JDBC.host", environment.getMySQLHostname());
        this.myBatisProperties.setProperty("JDBC.port", String.valueOf(environment.getMySQLPort()));
        this.myBatisProperties.setProperty("JDBC.schema", environment.getMySQLDatabase());
        this.myBatisProperties.setProperty("JDBC.username", environment.getMySQLUsername());
        this.myBatisProperties.setProperty("JDBC.password", environment.getMySQLPassword());
        this.myBatisProperties.setProperty("JDBC.autoCommit", "false");
        this.myBatisProperties.setProperty("mybatis.pooled.pingEnabled", "true");
        this.myBatisProperties.setProperty("mybatis.pooled.pingQuery", "SELECT 1");
        this.driverProperties.setProperty("characterEncoding", "UTF-8");
        this.driverProperties.setProperty("allowMultiQueries", "true");
    }

    @Override
    public void configure(Binder binder) {
        JdbcHelper.MySQL.configure(binder);
        Names.bindProperties(binder, this.myBatisProperties);
        binder.bind(Properties.class).annotatedWith(Names.named("JDBC.driverProperties")).toInstance(this.driverProperties);
    }
}

