PRO graph_region, nblocks_x, nblocks_y, zoom, label_title, ypos
;+
;  GRAPH_REGION - a UIMAGE-specific routine.  This routine issues a
;  call to SET_VIEWPORT so that a graph to be plotted will come out
;  nicely on the display device.  The supplied parameters are used
;  to determine the region of the display device that should be used,
;  using a heuristcally-based algorithm.
;#
;  Written by John Ewing.
;  SPR 10383  Jan 07 93  Add more comments.  J Ewing
;  SPR 10456  Jan 14 93  Bound prologue comments by ";+" and ";-".  J Ewing
;--------------------------------------------------------------------------
;
;  The case in the IF statement below in which (label_title NE '') catches
;  all plots generated by the Histogram operation (and those ones only).
;  -----------------------------------------------------------------------
  IF(label_title NE '') THEN BEGIN
    CASE !D.NAME OF
      'X'    : BEGIN
                 CASE nblocks_x * zoom OF
                    1 : BEGIN & x1 = 0.02 & x2 = 0.98 & END
                    2 : BEGIN & x1 = 0.02 & x2 = 0.98 & END
                    3 : BEGIN & x1 = 0.02 & x2 = 0.98 & END
                    4 : BEGIN & x1 = 0.30 & x2 = 0.88 & END
                    5 : BEGIN & x1 = 0.27 & x2 = 0.90 & END
                    6 : BEGIN & x1 = 0.24 & x2 = 0.92 & END
                    7 : BEGIN & x1 = 0.21 & x2 = 0.93 & END
                    8 : BEGIN & x1 = 0.20 & x2 = 0.94 & END
                    9 : BEGIN & x1 = 0.17 & x2 = 0.94 & END
                   10 : BEGIN & x1 = 0.16 & x2 = 0.95 & END
                   11 : BEGIN & x1 = 0.15 & x2 = 0.95 & END
                   12 : BEGIN & x1 = 0.14 & x2 = 0.95 & END
                   13 : BEGIN & x1 = 0.13 & x2 = 0.95 & END
                   14 : BEGIN & x1 = 0.12 & x2 = 0.95 & END
                 ELSE : BEGIN & x1 = 0.11 & x2 = 0.95 & END
                 ENDCASE
                 CASE nblocks_y * zoom OF
                    1 : BEGIN & y1 = 0.02 & y2 = 0.96 & ypos = y2 + .14 & END
                    2 : BEGIN & y1 = 0.02 & y2 = 0.96 & ypos = y2 + .14 & END
                    3 : BEGIN & y1 = 0.02 & y2 = 0.96 & ypos = y2 + .14 & END
                    4 : BEGIN & y1 = 0.25 & y2 = 0.75 & ypos = y2 + .14 & END
                    5 : BEGIN & y1 = 0.25 & y2 = 0.78 & ypos = y2 + .13 & END
                    6 : BEGIN & y1 = 0.15 & y2 = 0.80 & ypos = y2 + .13 & END
                    7 : BEGIN & y1 = 0.15 & y2 = 0.82 & ypos = y2 + .09 & END
                    8 : BEGIN & y1 = 0.15 & y2 = 0.80 & ypos = y2 + .09 & END
                    9 : BEGIN & y1 = 0.13 & y2 = 0.85 & ypos = y2 + .07 & END
                   10 : BEGIN & y1 = 0.09 & y2 = 0.85 & ypos = y2 + .07 & END
                   11 : BEGIN & y1 = 0.09 & y2 = 0.85 & ypos = y2 + .07 & END
                   12 : BEGIN & y1 = 0.09 & y2 = 0.87 & ypos = y2 + .06 & END
                   13 : BEGIN & y1 = 0.09 & y2 = 0.87 & ypos = y2 + .06 & END
                   14 : BEGIN & y1 = 0.09 & y2 = 0.88 & ypos = y2 + .05 & END
                 ELSE : BEGIN & y1 = 0.09 & y2 = 0.90 & ypos = y2 + .04 & END
                 ENDCASE
               END
      'REGIS': BEGIN
                 x1 = 0.16
                 x2 = 0.95
                 y1 = 0.14
                 y2 = 0.85
                 ypos = y2 + .10
               END
       ELSE :  BEGIN
                 x1 = 0.16
                 x2 = 0.95
                 y1 = 0.09
                 y2 = 0.87
                 ypos = y2 + .07
               END
    ENDCASE
  ENDIF ELSE BEGIN
;
;  The code below is invoked for all graphs except for those generated
;  via the Histogram operation.
;  -------------------------------------------------------------------
    CASE !D.NAME OF
      'X'    : BEGIN
                 CASE nblocks_x * zoom OF
                    3 : BEGIN & x1 = 0.02 & x2 = 0.98 & END
                    4 : BEGIN & x1 = 0.38 & x2 = 0.95 & END
                    5 : BEGIN & x1 = 0.36 & x2 = 0.95 & END
                    6 : BEGIN & x1 = 0.29 & x2 = 0.95 & END
                    7 : BEGIN & x1 = 0.25 & x2 = 0.95 & END
                    8 : BEGIN & x1 = 0.23 & x2 = 0.95 & END
                    9 : BEGIN & x1 = 0.18 & x2 = 0.95 & END
                   10 : BEGIN & x1 = 0.16 & x2 = 0.95 & END
                   11 : BEGIN & x1 = 0.15 & x2 = 0.95 & END
                   12 : BEGIN & x1 = 0.15 & x2 = 0.95 & END
                   13 : BEGIN & x1 = 0.15 & x2 = 0.95 & END
                   14 : BEGIN & x1 = 0.15 & x2 = 0.95 & END
                 ELSE : BEGIN & x1 = 0.15 & x2 = 0.95 & END
                 ENDCASE
                 CASE nblocks_y * zoom OF
                    3 : BEGIN & y1 = 0.02 & y2 = 0.96 & END
                    4 : BEGIN & y1 = 0.25 & y2 = 0.95 & END
                    5 : BEGIN & y1 = 0.25 & y2 = 0.90 & END
                    6 : BEGIN & y1 = 0.15 & y2 = 0.95 & END
                    7 : BEGIN & y1 = 0.15 & y2 = 0.95 & END
                    8 : BEGIN & y1 = 0.15 & y2 = 0.95 & END
                    9 : BEGIN & y1 = 0.13 & y2 = 0.95 & END
                   10 : BEGIN & y1 = 0.09 & y2 = 0.96 & END
                   11 : BEGIN & y1 = 0.09 & y2 = 0.95 & END
                   12 : BEGIN & y1 = 0.09 & y2 = 0.95 & END
                   13 : BEGIN & y1 = 0.09 & y2 = 0.95 & END
                   14 : BEGIN & y1 = 0.09 & y2 = 0.95 & END
                 ELSE : BEGIN & y1 = 0.09 & y2 = 0.95 & END
                 ENDCASE
               END
      'REGIS': BEGIN
                 x1 = 0.16
                 x2 = 0.95
                 y1 = 0.14
                 y2 = 0.96
               END
       ELSE :  BEGIN
                 x1 = 0.16
                 x2 = 0.95
                 y1 = 0.09
                 y2 = 0.96
               END
    ENDCASE
  ENDELSE
  SET_VIEWPORT, x1, x2, y1, y2
END
;DISCLAIMER:
;
;This software was written at the Cosmology Data Analysis Center in
;support of the Cosmic Background Explorer (COBE) Project under NASA
;contract number NAS5-30750.
;
;This software may be used, copied, modified or redistributed so long
;as it is not sold and this disclaimer is distributed along with the
;software.  If you modify the software please indicate your
;modifications in a prominent place in the source code.  
;
;All routines are provided "as is" without any express or implied
;warranties whatsoever.  All routines are distributed without guarantee
;of support.  If errors are found in this code it is requested that you
;contact us by sending email to the address below to report the errors
;but we make no claims regarding timely fixes.  This software has been 
;used for analysis of COBE data but has not been validated and has not 
;been used to create validated data sets of any type.
;
;Please send bug reports to CGIS@ZWICKY.GSFC.NASA.GOV.


