;
; Copyright 2005, 2006 University of Leiden.
;
; This file is part of MIA+EWS.
;
; MIA+EWS is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; MIA+EWS is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with MIA; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
;********************************************************
;#class#
;fbtTableGui
;#description#
;fairly generic GUI to display some items in a fits
;table and select rows quickly
;#end_class#
;*******************************************************

PRO flipAst, aString
;toggle string between asterisk and blank
 aspos = min(strpos(aString,'*'))
 slen = strlen(aString)
 if  (aspos EQ (-1)) then aString='*'+aString $
    else aString=strmid(aString,1,slen-1)
 RETURN
END

FUNCTION guiTableSelect, table, doSelect, initialOff=initialOff
;**************************************************************
;#function#
;guiTableSelect
;#description#
;create a gui that shows the contents of an IDL table/structure
;and allows you to select rows on the basis of the
;table contents
;#call#
;selectArray = guiTableSelect(table, doSelect, initialOff=initialOff )
;#inputs#
;\anArg{table}{idl structure}{table to look at}
;\anArg{initialOff}{boolean}{if set all rows are initially de-selected }
;#outputs#
;\anArg{doSelect}{boolean}{true if user exited with SELECT button}
;\anArg{}{}{false if user hit QUIT button}
;#return#
;\anArg{-}{bytarr}{1 at each selected row; 0 at deselected rows}
;#end_function#
;**************************************************************
;common to pass information between gui and the rest of the world
   COMMON guitable, a, fileButtons, fileNumbers, actionButtons, $
      relationButtons, buttons, rowSelect, nRows, dataInRow, $
      nCols, curVal, curCol, curRow, doQuit, hide, relation
;define uValue structure associated with each button
   ev = {vEv,type:'',pos:[0,0]}
;by default dont zap files from list
   if (KEYWORD_SET(initialOff)) then initial = 0B else initial=1B
;by default user hit QUIT button
   doQuit = 1B
;start in SHOW mode
   hide = 0B
;start with relation set to '='
   relation = '='
;copy input table into common
   a = table
   totalRows = N_ELEMENTS(table)
;names of columns
   tags = tag_names(table)
   nCols = N_ELEMENTS(tags)
;pixels per character in buttons
;  charpix = 9
   charpix = 8.5
   butSize = 7*charpix
;too many buttons crashes X server so limit number of displayed rows
   maxRows = 100
   nRows = totalRows < maxRows
;mapping from displayed rows to data rows
;in initial SHOW mode start with 1st nRows in table
   dataInRow = lindgen(nRows)
;current first row ; allow scrolling past maxRows
;bRow is index of lowest real table row currently displayed
   bRow = 0
   nButtons=nRows*nCols
;set initial selection state of each row
   rowSelect = replicate(initial, N_ELEMENTS(a))
   dataSelect = WHERE(rowSelect EQ 1B)
;symbols to mark selected rows
   doAstr = [' ','*']
;set max size (chars) of displayed button/label for each column
   maxSize = intarr(nCols)
   for icol = 0, nCols-1 do maxSize[icol] = 1 + MAX(strlen(strtrim(table.(icol),2))) 
;start defining widgets for layout
; base of everything
   base = widget_base(/col,title='Gorgonzola')
; base for pushing buttons that select/quit... and scroll
   actionBase=widget_base(base,/row)
   relationBase=widget_base(base,/row)
   boolBase = widget_base(base,/row)
; base for storing selection buttons and selected values
   selectBase = widget_base(base,/row)
   actionButtons=lonarr(11)
   boolButtons=lonarr(2)
   relationButtons=lonarr(7)
; define action buttons and their user values
;buttons to hide or show unselected data
   actionButtons(0) = widget_button(actionBase, value='HIDE', $
      xsize=butSize,ysize=25,uvalue={vEv,'display',[8,0]})
   actionButtons(1) = widget_button(actionBase, value='SHOW', $
      xsize=butSize,ysize=25,uvalue={vEv,'display',[9,0]})
;buttons to leave with or without selections
   actionButtons(2) = widget_button(actionBase,value='SELECT', $
      xsize=butSize,uvalue={vEv,'action',[4,0]})
   actionButtons(3) = widget_button(actionBase,value='QUIT', $
      xsize=butSize,uvalue={vEv,'action',[5,0]})
;buttons to scroll files within widget show
   actionButtons(4) = widget_button(actionBase,value='UP', $
      xsize=butSize,uvalue={vEv,'display',[6,0]})
   actionButtons(5) = widget_button(actionBase,value='DOWN', $
      xsize=butSize,uvalue={vEv,'display',[7,0]})
;show user HIDE/SHOW status
   actionButtons(10) = widget_label(actionBase,value='SHOW', $
      xsize=butSize)
;buttons to select data
   boolButtons(0) = widget_button(boolBase, value='AND', $
      xsize=butSize, uvalue={vEv,'boolean',[0,0]})
   boolButtons(1) = widget_button(boolBase, value='OR', $
      xsize=butSize,uvalue={vEv,'boolean',[1,0]})
   relationButtons(0) = widget_button(relationBase, value='=', $
      xsize=butSize,uvalue={vEv,'relation',[2,0]})
   relationButtons(1) = widget_button(relationBase, value='!=', $
      xsize=butSize,uvalue={vEv,'relation',[3,0]})
   relationButtons(2) = widget_button(relationBase, value='>', $
      xsize=butSize,uvalue={vEv,'relation',[2,0]})
   relationButtons(3) = widget_button(relationBase, value='<', $
      xsize=butSize,uvalue={vEv,'relation',[3,0]})
   relationButtons(4) = widget_button(relationBase, value='<=', $
      xsize=butSize,uvalue={vEv,'relation',[2,0]})
   relationButtons(5) = widget_button(relationBase, value='>=', $
      xsize=butSize,uvalue={vEv,'relation',[3,0]})
   relationButtons(6) = widget_label(relationBase, value='=', $
      xsize=butSize)
;label and value of data cell just clicked
   actionButtons(6) = widget_label(selectBase, value='',$
      xsize=150,ysize=25,/align_left)
   actionButtons(7) = widget_label(selectBase, value='',$
      xsize=150,ysize=25,/align_left)
;total number of rows and number of selected rows
   actionButtons(8) = widget_label(selectBase, value='',$
      xsize=80,ysize=25,/align_left)
   actionButtons(9) = widget_label(selectBase, value='',$
      xsize=80,ysize=25,/align_left)
;base for listing contents of tables and to show selected files
   fileBase=widget_base(base, y_scroll_size=600,x_scroll_size=1130,/scroll,/row)
;base to contain column labels and cells with table values and selected files
   base1=widget_base(fileBase,row=nRows+1,space=0)
;buttons containing header keyword values
   buttons = lonarr(nCols,nRows)
;buttons containing column labels
   tagButtons=lonarr(nCols)
;buttons indicating which files are currently selected
   fileButtons = lonarr(nRows)
   fileNumbers = lonarr(nRows)
;dummies to fill up a little space
   dummy = widget_label(base1,value='', xsize=30)
   dummy1 = widget_label(base1,value='',xsize=30)
;create column labels 
   for icol =0, nCols-1 do tagButtons(icol)=widget_label(base1,value=tags(icol),$
      xsize=charpix*maxSize[icol],/align_left)
;create file number, file select, and data cell buttons
   for iRow=0,nRows-1 do begin
      dRow = dataInRow[iRow]
      fileNumbers(iRow)=widget_label(base1, value=strtrim(dRow,2), $
	 xsize=30, ysize=25)
      fileButtons(iRow)=widget_button(base1, value=doAstr[rowSelect(dRow)], $
         uvalue={vEv,'file',[iRow,-1]}, xsize=30, ysize=25)
      for icol=0,nCols-1 do $
         buttons(icol, iRow) = widget_button(base1, $
	   value=strtrim((table[dRow].(icol)),2), $
           uvalue={vEv,'data',[icol,iRow]}, ysize=25, $
	   xsize=charpix*maxSize[iCol],/align_left)
   endfor
;write total number of files and files selected 
   widget_control, actionButtons(8), set_value=strtrim(totalRows,2)
   widget_control, actionButtons(9), set_value=strtrim(totalRows,2)
;
   widget_control,base,/realize
   xmanager,'gorganzola',base, event_handler='guiTableEvent'
   doSelect = 1-doQuit
RETURN, rowSelect
end

PRO guiTableEvent,ev
;*************************************************************************
;#procedure#
;guiTableEvent
;#call#
;none: called by widget manager
;#end_procedure#
;***********************************************************************
;common to communicate between event handler and data
   COMMON guitable, a, fileButtons, fileNumbers, actionButtons, $
      relationButtons, buttons, rowSelect, nRows, dataInRow, $
      nCols, curVal, curCol, curRow, doQuit, hide, relation
;markers for chosen files
   doAstr = ['*',' ']
   maxRows = 100
   widget_control,ev.top,get_uvalue=textwid
   widget_control,ev.id,get_uvalue=uval
   widget_control,ev.id,get_value=value
;action buttons
   if (uval.type eq 'action') then begin
;get out; set indicator that we dont want to reselect
      if (value EQ 'QUIT') then begin
         widget_control,ev.top,/destroy
         doQuit = 1
;get out; but set indicator that we do want to reselect
      endif else if(value EQ 'SELECT') then begin
         widget_control,ev.top,/destroy
         doQuit = 0
      endif
      RETURN
   endif  ; action
;behavior involving moving/hiding display
;because table is too big to convert all of it to widgets
;allow software scrolling with UP and DOWN
;HIDE, SHOW affect whether unselected rows are displayed
;notice that and UP or DOWN when hide true is may suppress rows
;that were previously displayed
;pressing SHOW button displays all rows, selected or not
;pressing HIDE button hides unselected rows
;
   if (uval.type eq 'display') then begin
;current first displayed row
      bRow = dataInRow[0]
      totalRows = N_ELEMENTS(a)
;determine whether we are in hide or show mode
      if (hide) then begin
         dataSelect = WHERE(rowSelect EQ 1)
         noData = (dataSelect[0] EQ -1)
	 if(noData) then begin
            print,'no selected data'
	    RETURN
         endif
	 nSelect = N_ELEMENTS(dataSelect)
      endif
;shift UP
      if (value EQ 'UP') then begin
         if(NOT hide) then bRow = (bRow - maxRows) > 0 $
         else begin
	    lastR = MAX(WHERE(dataSelect LT bRow))
	    iSelect = lastR-nRows > 0
;    bRow = dataSelect[iSelect]
         endelse   ; hide is on
;shift DOWN
      endif else if (value EQ 'DOWN') then begin
         if(NOT hide) then bRow = (bRow + maxRows-1) < (totalRows - nRows) $
	 else begin 
	    lastR = max(dataInRow)
	    firstR = MIN(WHERE(dataSelect GT lastR))
	    if(firstR LT 0) then firstR = nSelect-nRows
	    iSelect = (firstR < (nSelect-nRows)) > 0
;    bRow = dataSelect[iSelect]
         endelse
;SHOW everything; if I was already in SHOW mode this is NOP
      endif else if (value EQ 'SHOW') then begin
	 widget_control, actionButtons(10), set_value='SHOW'
         if (hide) then begin
	    hide = 0
	    bRow = (bRow < (totalRows - nRows)) > 0
         endif
;HIDE unselected rows ; even if I was already in hide check
;if there are recently unselected rows to hide
      endif else if (value EQ 'HIDE') then begin
	 widget_control, actionButtons(10), set_value='HIDE'
         dataSelect = WHERE(rowSelect EQ 1)
         noData = (dataSelect[0] EQ -1)
	 if(noData) then begin
            print,'no selected data'
	    RETURN
         endif
	 nSelect = N_ELEMENTS(dataSelect)
	 firstR = MAX(WHERE(dataSelect LE bRow))
	 iSelect = (firstR < (nSelect-nRows))>0
; bRow = dataSelect[iSelect]
	 hide = 1
      endif  ; various choices of display buttons
;bRow is known, choose rest of rows to display 
      if (NOT hide) then dataInRow = bRow + lindgen(maxRows) else begin
	 iSelect = iSelect + lindgen(nRows)
	 for iRow = 0, nRows-1 do if (iSelect(iRow) LT nSelect) then $
	    dataInRow[iRow] = dataSelect[iSelect[iRow]] else $
	    dataInRow[iRow] = -1
      endelse
;rows ave been selected, now do it.
      for iRow = 0, nRows-1 do begin
	 dRow = dataInRow[iRow]
	 if(dRow GE 0) then begin
	    widget_control,fileButtons(iRow),set_value=doAstr[0 EQ rowSelect[dRow]]
            widget_control,fileNumbers(iRow),set_value=strTrim(dRow,2)
            for iCol = 0, nCols-1 do widget_control, buttons[iCol, iRow], $
	       set_value=strtrim(a[dRow].(iCol),2)
         endif else begin
	    widget_control,fileButtons(iRow),set_value=''
            widget_control,fileNumbers(iRow),set_value=''
            for iCol = 0, nCols-1 do widget_control, buttons[iCol, iRow], $
	       set_value=''
	 endelse
      endfor
      RETURN
   endif          ; display buttons
;relation buttons
   if (uval.type eq 'relation') then begin
      relation = value
      widget_control, relationButtons(6), set_Value=value
      RETURN
   endif
;boolean buttons
   if (uval.type eq 'boolean') then begin
;apply selected value to tables
;first check which entries match selected value
;curcol = -1 is file selection row and this doesnt count
      if (curCol LT 0) then RETURN
;which relation to apply
      CASE relation OF
         '=': newSel  = a.(curCol) EQ curVal
         '>': newSel  = a.(curCol) GT curVal
         '>=': newSel = a.(curCol) GE curVal
         '!=': newSel = a.(curCol) NE curVal
         '<': newSel  = a.(curCol) LT curVal
         '<=': newSel = a.(curCol) LE curVal
      ENDCASE
;now apply new selection
      CASE value OF
         'AND' : begin
             rowSelect = rowSelect AND newSel
          END
         'OR' : begin
             rowSelect = rowSelect OR newSel
          END
      endCase
;now show this on screen 
      widget_control,actionButtons(9),set_value = $
         strtrim(long(total(rowSelect NE 0)),2)
      if (not hide) then begin
         for iRow = 0, nRows -1 do if (dataInRow[iRow] GE 0) then $
            widget_control,fileButtons(iRow), set_value=$
	       doAstr[0 EQ rowSelect[dataInRow[iRow]]]
      endif else begin
	 widget_control,actionButtons(0), timer=.1
      endelse
   endif
;a data cell has been selected
   if (uval.type EQ 'data') then begin
      widget_control,ev.id,set_value=value
      iCol = uval.pos[0]
      iRow = uval.pos[1]
      curCol = iCol
      tags = tag_names(a)
      tag = tags(icol)
;get value at selected cell
      curVal = a[dataInRow[iRow]].(iCol)
;show this on screen
      widget_control, actionButtons(6),set_value = tag
      widget_control, actionButtons(7),set_value = STRTRIM(curVal,2)
      RETURN
   endif
;an individual file has been selected; toggle it's selection state
   if (uval.type EQ 'file') then begin
      iRow = uval.pos[0]
      curCol = -1
;pointer to row in data
      dRow = dataInRow[iRow]
      current = rowSelect[dRow]
      if (current) then rowSelect[dRow] = 0 else rowSelect[dRow]=1
      widget_control,fileButtons(iRow),set_value=doAstr[0 EQ rowSelect[dRow]]
      widget_control,actionButtons(9),set_value = strtrim(long(total(rowSelect NE 0)),2)
      RETURN
   endif
RETURN
END
