; Procedure written by Markus Wittkowski
; Adapted to use within OYSTER
;
pro finitodata,file,limit,dit,targetname,specconf,pharms1,pharms2,factor1,factor2,factor3,plot=plot
;
if n_elements(limit) eq 0 then limit=50
;
errmsg=''
fxread,file,data,head_hdu,errmsg=errmsg
if (strmid(errmsg,0,5) eq 'Error') then begin
 print, errmsg + "   < RETURNING > "
 return
endif
;
dit=0.
factor1=0.
factor2=0.
factor3=0.
;
if errmsg eq '' then begin
d=mrdfits(file,0,h)
; command='dfits '+file+' | grep "HIERARCH ESO DET DIT" '
; spawn,command,ditstring
; dit=float(strmid(ditstring,24,9))
dit=float(fitshparse(h,'DET DIT'))
; command='dfits '+file+' | grep "HIERARCH ESO OBS TARG NAME" '
; spawn,command,targetname
; targetname=strmid(targetname,30,8)
targetname=fitshparse(h,'TARG NAME')
; command='dfits '+file+' | grep "HIERARCH ESO OCS OBS SPECCONF" '
; spawn,command,specconf
; specconf=strmid(specconf,33,14)
specconf=fitshparse(h,'SPECCONF')
; command='dfits '+file+' | grep "HIERARCH ESO DEL FNT PHA_RMS_CH1" '
; spawn,command,pharms1
; pharms1=strmid(pharms1,35,10)
pharms1=float(fitshparse(h,'PHA_RMS_CH1'))
; command='dfits '+file+' | grep "HIERARCH ESO DEL FNT PHA_RMS_CH2" '
; spawn,command,pharms2
; pharms2=strmid(pharms2,35,10)
pharms2=float(fitshparse(h,'PHA_RMS_CH2'))
if keyword_set(plot) then print,"DIT=",dit
if keyword_set(plot) then print,"Target:",targetname
if keyword_set(plot) then print,"SpecConf:",specconf
if keyword_set(plot) then print,"Phase RMS 1:",pharms1
if keyword_set(plot) then print,"Phase RMS 2:",pharms2
endif
;
if dit gt 0 then begin
;
exten=9
errmsg1=''
fxbopen, unit,file,exten,header,errmsg=errmsg1
if errmsg1 eq '' then begin
fxbread,unit,time1,'Time'
fxbread,unit,phase1,'Phase'
time1=time1/1.e6
fxbclose,unit
endif
exten=10
errmsg2=''
fxbopen, unit,file,exten,header,errmsg=errmsg2
if errmsg2 eq '' then begin
number=fxpar(header,'NAXIS2')
fxbread,unit,time2,'Time'
fxbread,unit,phase2,'Phase'
time2=time2/1.e6
fxbclose,unit
endif
;
if errmsg1 eq '' and errmsg2 eq '' then begin
phase3=phase1+phase2
index=where(phase3 ge !PI,count)
if count gt 0 then phase3(index)=phase3(index)-!PI
index=where(phase3 le -1.*!PI,count)
if count gt 0 then phase3(index)=phase3(index)+!PI
;
totaltime=time1(n_elements(time1)-1)
intervals=floor(totaltime/DIT)
phasesrms1=fltarr(intervals)
for i=0,intervals-1 do begin
starttime=i*DIT
stoptime=i*DIT+DIT
index=where(time1 gt starttime and time1 lt stoptime)
phases=phase1(index)
phasesrms1(i)=stdev(phases)
endfor
;
totaltime=time2(n_elements(time2)-1)
intervals=floor(totaltime/DIT)
phasesrms2=fltarr(intervals)
for i=0,intervals-1 do begin
starttime=i*DIT
stoptime=i*DIT+DIT
index=where(time2 gt starttime and time2 lt stoptime)
phases=phase2(index)
phasesrms2(i)=stdev(phases)
endfor
;
totaltime=time2(n_elements(time2)-1)
intervals=floor(totaltime/DIT)
phasesrms3=fltarr(intervals)
for i=0,intervals-1 do begin
starttime=i*DIT
stoptime=i*DIT+DIT
index=where(time2 gt starttime and time2 lt stoptime)
phases=phase3(index)
phasesrms3(i)=stdev(phases)
endfor
;
if keyword_set(plot) then window,0
index=sort(phasesrms1)
if keyword_set(plot) then plot,phasesrms1(index)
pos=(limit/100.)*n_elements(phasesrms1)
if keyword_set(plot) then plots,[pos,pos],[0,2.]
indexgood=index(0:floor(n_elements(index)*(limit/100.)))
phasesgood=phasesrms1(indexgood)
factor1=exp(-1.*avg(phasesgood))
;
if keyword_set(plot) then window,1
index=sort(phasesrms2)
if keyword_set(plot) then plot,phasesrms2(index)
pos=(limit/100.)*n_elements(phasesrms2)
if keyword_set(plot) then plots,[pos,pos],[0,2.]
indexgood=index(0:floor(n_elements(index)*(limit/100.)))
phasesgood=phasesrms2(indexgood)
factor2=exp(-1.*avg(phasesgood))
;
if keyword_set(plot) then window,2
index=sort(phasesrms3)
if keyword_set(plot) then plot,phasesrms3(index)
pos=(limit/100.)*n_elements(phasesrms3)
if keyword_set(plot) then plots,[pos,pos],[0,2.]
indexgood=index(0:floor(n_elements(index)*(limit/100.)))
phasesgood=phasesrms3(indexgood)
factor3=exp(-1.*avg(phasesgood))
;
if keyword_set(plot) then print,factor1,factor2,factor3
endif
endif
;
end
