;
; Copyright 2005, 2006 University of Leiden.
;
; This file is part of MIA+EWS.
;
; MIA+EWS is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; MIA+EWS is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with MIA; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
FUNCTION makeScans, inData, rows, nRows=nRows, iErr=iErr
;combine 0 or 1 dimensional input time series into "scans"
;INPUTS
;   inData   an input ImageData object
;   rows     long(2) first and last rows to be included.
;            If not given use all rows in inData
;   nRows    if given and smaller than number of elements in rows
;            make the output an array of scan structures, each
;            containing nRows points
;OUTPUTS
;   outScan  a structure or array of structures, 
;            similar to inData structure but
;            with concatenation of all parts into a time sequence
;
;establish error handler
   cErr = 0
   catch, cErr
   if (cErr NE 0) then begin
;supress further handling at this level 
      catch, /cancel 
      midiCatchError
      iErr = 1
RETURN,0
   endif         ; handle actual error
;end of establishing error handler
;
;how big in input set
   nAxis = inData->nAxis()
   if (N_PARAMS() GT 1) then pRows = rows ELSE pRows = [1, nAxis(1)]
;condition input
   pRows[0] = pRows[0] > 1
   pRows[1] = pRows[1] < nAxis[1]
;is nrows specified?
   if (NOT KEYWORD_SET(nRows)) THEN nR = pRows[1] - pRows[0] + 1 ELSE $
      nR = 1 > (nRows < nAxis[1])
;how many read cycles
   nRead = (pRows[1] - pRows[0] +1)/nR
;read data
   inStruct = inData->readrows(pRows[0]+lindgen(nR),iErr=iErr)
   if (iErr NE 0) then midiSetError, 'couldnt read input data',/notinitial
   outData = {frame:inStruct.frame, $
      time:inStruct.time, $
      exp_Time:inStruct.exp_Time, $
      reference:inStruct[0].reference, $
      opd:inStruct.opd, $
      localOpd:inStruct.localOpd, $
      offset:inStruct[0].offset, $
      rotation:inStruct.rotation, $
      stepping_Phase:inStruct.stepping_Phase, $
      opt_Train:inStruct[0].opt_Train $
      }
;data, source, tartype
   dataCols = inData->dataColumns() - 1
   sourceCols = inData->sourceColumns() - 1
   tarCols = inData->targetColumns() - 1
   nData = N_ELEMENTS(dataCols)
   for iData = 0, nData-1 do begin
      sData = STRTRIM(STRING(iData+1),2)
      outData = CREATE_STRUCT(outData, 'DATA'+sData, $
         inStruct.(dataCols[iData]), $
	 'SOURCE'+sData, inStruct[0].(sourceCols[iData]), $
	 'TARTYP'+sData, inStruct[0].(tarCols[iData]))
   endfor
   if (nRead GT 1 ) then begin
      outTag = TAG_NAMES(outData)
      outData = REPLICATE(outData, nRead)
      dataTag = min(WHERE(outTag EQ 'DATA1'))
      pRows[0] = pRows[0] + nR
      for iRead = 1, nRead-1 do begin
         inStruct = inData->readrows(pRows[0]+lindgen(nR),iErr=iErr)
         if (iErr NE 0) then midiSetError, 'couldnt read input data',/notinitial
         outData[iRead].frame    = inStruct.frame
         outData[iRead].time     = inStruct.time
         outData[iRead].exp_Time = inStruct.exp_Time
         outData[iRead].reference = inStruct[0].reference
         outData[iRead].opd       = inStruct.opd
         outData[iRead].localOpd  = inStruct.localOpd
         outData[iRead].offset    = inStruct[0].offset
         outData[iRead].rotation  = inStruct.rotation
         outData[iRead].stepping_Phase = inStruct.stepping_Phase
         outData[iRead].opt_Train  = inStruct[0].opt_Train 
         for iData = 0, nData-1 do begin
	    nTag = dataTag + 3* iData
            outData[iRead].(nTag)   = inStruct.(dataCols[iData])
            outData[iRead].(nTag+1) = inStruct[0].(sourceCols[iData])
            outData[iRead].(nTag+2) = inStruct[0].(tarCols[iData])
	 endfor 
         pRows[0] = pRows[0] + nR
      endfor 
   endif
   iErr = 0
RETURN, outData
END

