;
; Copyright 2005, 2006 University of Leiden.
;
; This file is part of MIA+EWS.
;
; MIA+EWS is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; MIA+EWS is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with MIA; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
PRO source__DEFINE
;********************************************************
;#structure#
; source
;#inheritance#
; fitsTable
;#description#
; Internal variables for source Object
;#structure_text#
;define structures for source class
oir5={Source,  $        ;#class members#
INHERITS FITSTABLE, $   ;#class inheritance#
revision:1, $           ;int & revision numbers
nBands:1    $           ;int &number of freqs. for which fluxes are given
}
;#end_structure#
;********************************************************
;
;********************************************************
;#structure#
; sourceStruct
;#inheritance#
; None
;#description#
; template for one row of source table
;#structure_text#
oir6={SourceStruct,  $  ;#FITS TABLE structure#
source_ID:0,      $     ;int  & source number
source:STRING(REPLICATE(32B,16)), $ ;str ; source name
calCode:STRING(REPLICATE(32B,4)), $ ;str ; calibration code
raEpp:0.0d, $   ; dbl & mean ra (deg)
decEpp:0.0d,$   ; dbl & mean dec (deg)
equinox:STRING(REPLICATE(32B,8)),$ ; string & epoch of raEpp/decEpp
rApp:0.0d, $    ; dbl & apparent ra
decApp:0.0d,$   ; dbl & apparent dec
sysVel:0.0d,$   ; dbl & systemic velocity (m/s)
velTyp:STRING(REPLICATE(32B,8)),$ ; str & type of sysvel
velDef:STRING(REPLICATE(32B,8)),$ ; str & 'radio' or 'optical'
pmRa:0.0d,$   ; dbl & propermotion ra (deg/day)
pmDec:0.0d,$  ; dbl &propermotion dec (deg/day)
parallax:0.0, $ ; flt &heliocentric parallax (arcsec)
diameter:0.0, $ ; flt &source diameter (arcsec)
diam_err:0.0 $ ; flt &source diameter uncertainty (arcsec)
;iFlux   float(nbands)
;qFlux   float(nbands)
;uFlux   float(nbands)
;vFlux   float(nbands)
;freq    double(nbands)
}
;#end_structure#
;********************************************************
END

FUNCTION source::init, input, iErr=iErr, nBand=nBand
;construct a source table object
;
;   input  poly
;   (1) if a number assume that this is number of sources
;       and create a default, mostly empty source table.
;       if no input is not specified, nsource = 1
;
;   (2) a string, assumed to be a file name.  Open the
;       file and get the source table there
;   (3) a FITSFILE object;  read down the file and
;       get source table
;   (4) a (subclass of) a FITSEXTENSION object
;       grab the fitsfile object and treat as (3)
;
;establish error handler
   cErr = 0
   catch, cErr
   if (cErr NE 0) then begin
;supress further handling at this level 
      catch, /cancel 
      midiCatchError
      iErr = 1
RETURN,0
   endif         ; handle actual error
;determine input type
   if(N_PARAMS() GE 1) then begin
      sInput = size(input)
      sInput = sInput[sInput[0]+1]
   endif else begin
      sInput = 2
      input  = 1
   endelse
;integer, thus input is the size of the Source table
   if (sInput ge 1 and (sInput le 3)) then begin
      if(NOT KEYWORD_SET(nBands)) then nBands = 1
      self.nBands = nBands
      nSource = input
;add variable length pointers to fluxes etc.
      template = {sourceStruct}
;fill in blank character strings to set lengths
      template.source=string(replicate(32B,16))
      template.calCode=string(replicate(32B,4))
      template.equinox=string(replicate(32B,8))
      template.velTyp=string(replicate(32B,8))
      template.velDef=string(replicate(32B,8))
      template = CREATE_STRUCT(template, $
         'iFlux', FLTARR(nBands), $
         'qFlux', FLTARR(nBands), $
         'uFlux', FLTARR(nBands), $
         'vFlux', FLTARR(nBands), $
         'freq',  DBLARR(nBands))
      self.table = PTR_NEW(replicate(template, nSource))
      if (0 eq self->FITSTABLE::init(template, $
         extname='SOURCE', iErr=iErr)) then $
         midiSetError,'Source Table Creation from Disk Failed',$
         /notInitial
      (self.head)->addPar,'NBANDS', self.nBands
;end of integer input, try string or object input
   endif else if (sInput eq 7 or (sInput eq 11)) then begin 
;if string input save in temporary variable
      if (sInput eq 7) then tInput = input else begin
;if object input, test class and extract inFile if necessary
         inClass = OBJ_CLASS(input)
	 inClass = strTrim(inClass[0],2)
	 if (inClass EQ 'FITSFILE') then tInput = input else begin
;find highest order superclass
            sc = inClass
            while (sc NE '') do begin
               superClass = sc
               sc = OBJ_CLASS(sc,/super)
               sc = sc[0]
            endwhile
            superClass = superClass[0]
	    if (inClass EQ 'FITSEXTENSION' OR (superClass EQ 'FITSEXTENSION'))$
	       then tInput = input->file() else $
	       midiSetError, 'Source input object of unknown type'
         endelse        ; not a FITSFILE object
      endelse           ; not a string input
;call FITSTABLE constructor with string or FITSFILE input
      if (0 eq self->FITSTABLE::init(tInput, extName='SOURCE',/table, $
         iErr=iErr)) then $
         midiSetError, 'Source Table Creation from Disk Failed',/notInitial
      self.nBands = (self.head)->getPar('NBANDS', matches)
   endif  else  midiSetError, 'Source construction input of unknown type'
RETURN,1
END

PRO Source::CLEANUP
PTR_FREE,self.table
RETURN
END
