;
; Copyright 2005, 2006 University of Leiden.
;
; This file is part of MIA+EWS.
;
; MIA+EWS is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; MIA+EWS is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with MIA; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
oir1={ImageDetStruct,   $ ;#FITS TABLE structure#
region:0,           $  ; int & which region
detector:1,         $  ; int & which detector
correlation:0,      $  ; int & type of correlation (self/cross)
regName:STRING(REPLICATE(32B,16)),$ string & name for this region
corner:lonarr(2),    $ ; long array & pixel coordinates of b.l.c.
gain:double(1.),     $ ; double & electrons per adu
nAxes:lonarr(2),     $ ; long array &size of region in pixels
crVal:dblarr(2),     $ ; dbl array &reference pixel coordinates
crPix:fltarr(2),     $ ; float arr&position of reference pixel
cType:REPLICATE(STRING(REPLICATE(32B,8)),2), $ str array &dimension type
cD:dblarr(2,2)      $ ;  dbl array & linear coordinate transf. to WCS
; ports              size not known yet which input ports are correlated
; dmp                size not known yet
; dmc                size not known yet
}

oir2={ImageDetector,    $ ;#class members#
INHERITS FITSTABLE,  $    ;#class inheritance#
revision:1,          $    ;int & revision number
nDetect:1,           $    ;int & number of physical detectors
instrument:'MIDI',   $    ;str & instrument name
nRegion:0,           $    ;int & number of specified regions on detector
maxCoeff:0,          $    ;int & max no. of coefficients in coord distortions
numDim:2,            $    ;int & dimensionality of detector regions
dateObs:'',          $    ;str & date of observations
maxTel:2,            $    ;int & max number of telescopes per region
dataType:-1,         $    ;int & idl data type of information
dataTempl:PTR_NEW()  $    ;ptr->struct &representation of 1 row of table
}

oir3={ImageData, $   ;#class members#
INHERITS FITSTABLE, $;#class inheritance#
detector:OBJ_NEW(), $;object & detector object associated with this data
revision:1, $        ;int   & revision number of this format
nRegion:0,          $;int   & number of regions on detector
dateObs:'',         $;str   & date of observation
maxTel:2,           $;int   & max telescopes imaged per region
dataCols:PTR_NEW(),  $ptr->int array & which columns (1-rel) have pixels
sourceCols:PTR_NEW(),$ptr->int array & which cols. have source numbers
targetCols:PTR_NEW() $ptr->int array & which cols. have target types
}

oir4={ImageDataStruct,    $ ;#FITS TABLE structure#
frame:0L,        $          ;long & frame number
time:0.0D,       $          ;dbl  & time of exposure
exp_Time:0.0,    $          ;float & length of exposure
reference:0,     $          ;int & phase reference source number
opd:DBLARR(2),   $          ;dbl array & main delay line OPD offsets (fsec)
localOpd:DBLARR(2),   $     ;dbl array & instrument OPD offset (fsec)
offset:fltarr(2),      $    ;flt array & pointing offset rel. source position
rotation:0.0,    $          ;flt & rotation of field rel. north (degrees)
stepping_Phase:0L $          ;long & sequence no. in OPD stepping cycle
;opt_train         optical train designator (maxTel not known)
;DataN             data to be added later (N not yet known)
;SourceN           source number to be added later (N not yet known)
;TarTypN           Target Type to be added later (N not yet known)
}

oir5={Source,  $        ;#class members#
INHERITS FITSTABLE, $   ;#class inheritance#
revision:1, $           ;int & revision numbers
nBands:1    $           ;int &number of freqs. for which fluxes are given
}

oir6={SourceStruct,  $  ;#FITS TABLE structure#
source_ID:0,      $     ;int  & source number
source:STRING(REPLICATE(32B,16)), $ ;str ; source name
calCode:STRING(REPLICATE(32B,4)), $ ;str ; calibration code
raEpp:0.0d, $   ; dbl & mean ra (deg)
decEpp:0.0d,$   ; dbl & mean dec (deg)
equinox:STRING(REPLICATE(32B,8)),$ ; string & epoch of raEpp/decEpp
rApp:0.0d, $    ; dbl & apparent ra 
decApp:0.0d,$   ; dbl & apparent dec
sysVel:0.0d,$   ; dbl & systemic velocity (m/s)
velTyp:STRING(REPLICATE(32B,8)),$ ; str & type of sysvel
velDef:STRING(REPLICATE(32B,8)),$ ; str & 'radio' or 'optical'
pmRa:0.0d,$   ; dbl & propermotion ra (deg/day)
pmDec:0.0d,$  ; dbl &propermotion dec (deg/day)
parallax:0.0, $ ; flt &heliocentric parallax (arcsec)
diameter:0.0, $ ; flt &source diameter (arcsec)
diam_err:0.0 $ ; flt &source diameter uncertainty (arcsec)
;iFlux   float(nbands)
;qFlux   float(nbands)
;uFlux   float(nbands)
;vFlux   float(nbands)
;freq    double(nbands)
}

oir7={arrayGeometry, $; #class members#
INHERITS FITSTABLE, $;  #class inheritance#
revision:1,    $ int & revision number
arrNam:STRING(REPLICATE(32B,16)), $ ;str & telescope name e.g. 'VLTI'
frame:STRING(REPLICATE(32B,16)), $ ; str &coordinate frame e.g. 'GEOCENTRIC'
arrayX:0.0D, $ ;  dbl &array center x-coordinate in meters
arrayY:0.0D, $ ;  dbl &array center x-coordinate in meters
arrayZ:0.0D  $ ;  dbl &array center x-coordinate in meters
}

oir8={arrayGeometryStruct, $ ; #FITS TABLE structure#
tel_Name:STRING(REPLICATE(32B,16)), $ ; station (telescope) name
sta_Name:STRING(REPLICATE(32B,16)), $ ; station (telescope) name
index:1,   $      ; station number (can be used as index)
diameter:0.0,$    ; element diameter (meters)
staXYZ:dblarr(3),$; station coordinates relative to center (meters)
mntSta:0,    $    ; station mount type
mntParam:0.0D $   ; as yet unspecified mount geometry parameters
}

oir9 = {opticalTrain, $ ;#class members#
INHERITS FITSTABLE,$    ;#class inheritance#
revision:1,        $    ;int & revision number
arrNam:'',         $  ; str & array name
dateObs:''        $  ; str & start date of obs. described by this table
}

oir10={opticalTrainStruct, $ ; #FITS TABLE structure#
index:0,          $ int &optical path index number
telescope:0,      $ int &telescope feeding this optical path (c.f. array geometry)
dly_line:0,       $ int &delay line feeding this path
lab_beam:0,       $ int &input channel selected
switchyard:STRING(REPLICATE(32b,16)) $str & selected option at lab switchyard
}

oir11={coordDistortion, $ ;#class members#
nAxis:2,           $   ; int &dimensionality of fit
naxes:intarr(2),   $   ; int array &axis sizes
crVal:dblarr(2),   $   ; dbl array &coordinate reference values
crPix:fltarr(2),   $   ; flt array&position of reference pixel
cType:REPLICATE(STRING(REPLICATE(32B,8)),2),  $  ;str array &coordinate types
CD:dblarr(2,2), $   ; dble array&standard fits coordinate array
maxCoeff:0,     $   ; int & max number of coefficients in expansion
dmp:PTR_NEW(),  $   ; ptr->int array &array describing which polynomials are use
                    ; in coordinate distortion matrix
dmc:PTR_NEW(),  $   ; ptr->dbl array &array giving coord-distorion coefficients
rDmc:PTR_NEW(), $   ; ptr->dbl array&coefficients for reverse transformation
valSet:0B,      $   ; bool &have crVal been set yet
pixSet:0B,      $   ; bool &have crPix been set yet
cdSet:0B        $   ; bool &have cd been set yet
}

oir12={dataFilter, $  ; #class members#
TransferSize:1024l*1024l,       $ long & buffer size
dataCol:PTR_NEW(),       $      ; ptr->int array&list of column numbers of data structs 
tZero:PTR_NEW(),  $             ; ptr->dbl array&store input zero offsets
tScale:PTR_NEW(), $             ; ptr->dbl array&store input zero offsets
inData:OBJ_NEW(),  $            ; object &input data object
outData:OBJ_NEW(), $            ; object &output data object
inputDetector:OBJ_NEW(),$       ; object &image detector object for input data
outputDetector:OBJ_NEW(),$      ; object &image detector object for output data
outputTemplate:PTR_NEW(), $     ; ptr->struct&what output data looks like
dataType:4         $            ; int &output data type
}

oir13={coordCompression, $ ; #class members#
INHERITS dataFilter,     $ ; #class inheritance
maxDegree:2,             $ ;int & maximum degree for coorddistortion
spectralMode:1B,$          ;bool & 1 if spectral mode, 0 if not 
weightImageTable:PTR_NEW()  $  ; ptr->struct &pointer to weight images
}

oir14={noDispersion,      $ ; #class members#
INHERITS dataFilter,     $ ; #class inheritance
maxDegree:2,             $ ;int & maximum degree for coorddistortion
spectralMode:1B,$          ;bool & 1 if spectral mode, 0 if not 
weightImageTable:PTR_NEW()  $  ; ptr->struct &pointer to weight images
}
