;
; Copyright 2005, 2006 University of Leiden.
;
; This file is part of MIA+EWS.
;
; MIA+EWS is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; MIA+EWS is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with MIA; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
;********************************************************
;#class#
;oirTarget
;#description#
;deal with Target Tables
;#end_class#
;*******************************************************

PRO oi_Target__DEFINE
;********************************************************
;#structure#
; Target
;#inheritance#
; fitsTable
;#description#
; Internal variables for Target Object
;#structure_text#
oir7={oi_Target, $; #class members#
INHERITS FITSTABLE, $;  #class inheritance#
OI_REVN:1    $ int & revision number
}
;#end_structure#
;********************************************************

;********************************************************
;#structure#
; oi_Target
;#inheritance#
; NONE
;#description#
;variables per row of oi_Target Table
;#structure_text#
oir8={oi_TargetStruct, $ ; #FITS TABLE structure#
TARGET_ID:0, $ ; target identifier number
TARGET:STRING(REPLICATE(16B,8)), $ ;
RAEP0:0.d0, $
DECEP0:0.d0, $
EQUINOX:0.0, $
RA_ERR:0.d0, $
DEC_ERR:0.d0, $
SYSVEL:0.d0,  $
VELTYP:STRING(REPLICATE(32B,8)), $ ;
VELDEF:STRING(REPLICATE(32B,8)), $ ;
PMRA:0.d0, $
PMDEC:0.d0, $
PMRA_ERR:0.d0, $
PMDEC_ERR:0.d0, $
PARALLAX:0.0, $
PARA_ERR:0.0, $
SPECTYP:STRING(REPLICATE(16B,8)) $ ;
}
;#end_structure#
;********************************************************
END

FUNCTION oi_Target::init, input, iErr=iErr
;construct a Target table object
;
;   input  poly
;
;   (1) a string, assumed to be a file name.  Open the
;       file and get the source table there
;   (2) a FITSFILE object;  read down the file and
;       get source table
;   (3) a (subclass of) a FITSEXTENSION object
;       grab the fitsfile object and treat as (3)
;   (4) absent (create and empty object for output)
;establish error handler
   cErr = 0
   catch, cErr
   if (cErr NE 0) then begin
;supress further handling at this level 
      catch, /cancel 
      midiCatchError
      iErr = 1
RETURN,0
   endif         ; handle actual error
;determine input type
; no input: ready for output
   if(N_PARAMS() LE 0) then begin
      self.oi_revn = 1
      template = {oi_TargetStruct}
      template.target  = STRING(REPLICATE(32B,16))
      template.spectyp = STRING(REPLICATE(32B,16))
      template.veltyp  = STRING(REPLICATE(32B,8))
      template.veldef  = STRING(REPLICATE(32B,8))
      if (0 eq self->FITSTABLE::init(template, $
         extname='OI_TARGET', iErr=iErr)) then begin
            midiSetError, 'Target Table Creation Failed',/notInitial
            RETURN,0
      endif
      (self.head)->addPar,'OI_REVN', self.oi_revn
      RETURN, 1
   endif ; no input
   sInput = size(input)
   sInput = sInput[sInput[0]+1]
;    try string or object input
   if (sInput eq 7 or (sInput eq 11)) then begin 
;if string input save in temporary variable
      if (sInput eq 7) then tInput = input else begin
;if object input, test class and extract inFile if necessary
         inClass = OBJ_CLASS(input)
	 inClass = strTrim(inClass[0],2)
	 if (inClass EQ 'FITSFILE') then tInput = input else begin
;find highest order superclass
            sc = inClass
            while (sc NE '') do begin
               superClass = sc
               sc = OBJ_CLASS(sc,/super)
               sc = sc[0]
            endwhile
            superClass = superClass[0]
	    if (inClass EQ 'FITSEXTENSION' OR (superClass EQ 'FITSEXTENSION'))$
	       then tInput = input->file() else $
	       midiSetError, 'Source input object of unknown type'
         endelse        ; not a FITSFILE object
      endelse           ; not a string input
;call FITSTABLE constructor with string or FITSFILE input
      if (0 eq self->FITSTABLE::init(tInput, extName='OI_TARGET',$
         /table, iErr=iErr))  then $
         midiSetError, 'Source Table Creation from Disk Failed',/notInitial
      self.oi_revn = (self.head)->getPar('OI_REVN')
   endif  else $           ; input from disk
      midiSetError, 'Source construction input of unknown type'
RETURN,1
END

PRO oi_target::cleanup
   self->FitsTable::cleanup
RETURN
END


PRO oi_target::newFile, fileName, iErr=iErr, priHead=priHead
   self->fitsTable::newFile, fileName, /table, iErr=iErr, priHead=priHead
RETURN
END

PRO oi_target::appendToFile, input, iErr=iErr
   self->fitsTable::appendToFile, input, iErr=iErr
RETURN
END
