/*******************************************************************************
external.c

USNO/NRL Optical Interferometer
3450 Massachusetts Avenue NW
Washington DC 20392-5420

System: Data Reduction
Subsystem: AMOEBA

Description:
Wrappers for external libraries contributed by collaborators.

Modification history:
02-Oct-2003  C.A.Hummel, file created
*******************************************************************************/

/* Includes */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#define NRANSI
#include "nrutil.h"
#include "export.h"
#include "ccs.h"

/* Defines */

#define PI 3.141592653589793
#define NEG(x) ((x) > 0 ? -(x) : (x))
#define MIN(x,y) ((x) > (y) ? (y) : (x))
#define MAX(x,y) ((x) > (y) ? (x) : (y))
#define RAD(x) ((x)/360.*2.*PI)

/* Function prototypes */

/* ...callable from IDL */

int wilson(int argc, char *argp[]);
int peterson(int argc, char *argp[]);
int shadow(int argc, char *argp[]);

/* Global variables; storage for data used in fit routines */

/*----------------------------------------------------------------------------*/
int wilson(int argc, char *argp[]){
	/* Wrapper for IMLC routine by R.E. Wilson
	*/

	int *piILC,*piCLC;
	double *pdfXLC,*pdfYLC,*pdfFLC;
	float *pfWDPARMS;

        if (argc != 6) {
                fprintf(stderr,"\nWrong # of parameters(%d)",argc);
                return(1);
                }

	pfWDPARMS=  ((float**)argp)[0];
	piILC=        ((int**)argp)[1];
	piCLC=        ((int**)argp)[2];
	pdfXLC=    ((double**)argp)[3];
	pdfYLC=    ((double**)argp)[4];
	pdfFLC=    ((double**)argp)[5];

	imlc_(pfWDPARMS,piILC,piCLC,pdfXLC,pdfYLC,pdfFLC);

	return(0);
	}
/*----------------------------------------------------------------------------*/
int peterson(int argc, char *argp[]){
	/* Wrapper for RocheVis routine by D. M. Peterson, modified by 
	 * C. A. Hummel.
	*/

	int *piN;
	int *piTeffMax,*piLogGMax,*paiLogG,*piLDinit,*piWavesMax;
	float *pfRochePARMS;
	float *pfLam,*pfVr,*pfVi,*pfFlux,*pfU,*pfV;
	float *pafLD,*pafLogG,*pafWaves,*pafTeff,*pfVsini;

        if (argc != 18) {
                fprintf(stderr,"\nWrong # of parameters(%d)",argc);
                return(1);
                }

	pfRochePARMS=((float**)argp)[0];
	piN  =         ((int**)argp)[1];
	pfLam =      ((float**)argp)[2];
	pfVr =       ((float**)argp)[3];
	pfVi =       ((float**)argp)[4];
	pfFlux =     ((float**)argp)[5];
	pfU  =       ((float**)argp)[6];
	pfV  =       ((float**)argp)[7];

	piLDinit=	((int**)argp)[8];
	piWavesMax=	((int**)argp)[9];
	piTeffMax=	((int**)argp)[10];
	piLogGMax=	((int**)argp)[11];
	paiLogG=	((int**)argp)[12];
	pafLD=	      ((float**)argp)[13];
	pafLogG=      ((float**)argp)[14];
	pafWaves=     ((float**)argp)[15];
	pafTeff=      ((float**)argp)[16];	
	pfVsini=      ((float**)argp)[17];

	return(RocheVis(pfRochePARMS,piN,pfLam,pfVr,pfVi,pfFlux,pfU,pfV,
			piLDinit,piWavesMax,piTeffMax,piLogGMax,paiLogG,
			pafLD,pafLogG,pafWaves,pafTeff,pfVsini));

	}
/*----------------------------------------------------------------------------*/
int shadow(int argc, char *argp[]){
	/*
	*/

	int i,j;
	int *piN_AZ,*piN_EL,*piLoc,*piTelType;
	double *pfAZ,*pfEL,*pfShadow;
	double f;
	float *pfR,*pfT;
	ccsERROR error;
	ccsCOMPL_STAT status;

	int teltype=5,noofRayRadial=10,noofRayAngular=10;

        if (argc != 9) {
                fprintf(stderr,"\nWrong # of parameters(%d)",argc);
                return(1);
                }

	piN_AZ=       ((int**)argp)[0];
	piN_EL=       ((int**)argp)[1];
	pfAZ=      ((double**)argp)[2];
	pfEL=      ((double**)argp)[3];
	pfShadow=  ((double**)argp)[4];
	piLoc=        ((int**)argp)[5];
	pfR=        ((float**)argp)[6];
	pfT=        ((float**)argp)[7];
	piTelType=    ((int**)argp)[8];

	for (i=0;i<piN_EL[0];i++) {
		for (j=0;j<piN_AZ[0];j++) {
			status=issshadowAltAz(pfEL[i],pfAZ[j],
					      piTelType[0],piLoc[0],
					      noofRayRadial,noofRayAngular,
					      &f,&error);
			pfShadow[i*piN_AZ[0]+j]=f;
			pfR[i*piN_AZ[0]+j]=90.-pfEL[i];
			pfT[i*piN_AZ[0]+j]=(pfAZ[j]-90)/52.7;
			}
		}
	}
/*----------------------------------------------------------------------------*/
