/* Header file for call to keyinc, the c version of Keyin
 * 22-Oct-1993 DFB Created
 */

#ifndef _KEYINC_H
#define _KEYINC_H

/* Default length of string type */
#define KSTRING_LEN 80
#ifndef TRUE
#define TRUE (1)
#endif
#ifndef FALSE
#define FALSE (0)
#endif

/* Types of values allowed */
enum partype { kinteger, kdouble, kstring, kboolean, kenum, kaction };

typedef struct { 
	char * key;			/* Parameter name 		     */
	void * val;			/* Value			     */
	enum partype type;		/* Type				     */
	int nval;			/* Dimension of array (1 for scalar) */
        int *nset;			/* No of variables set               */
	char *opts;			/* Options              	     */
	char *helpstring;		/* Brief description of parameter    */
} keyrec;

/* Type of I/O "devices" in call to keyinc */
typedef enum {kioTty, kioLoad, kioSave, kioBuffer } kioType;

typedef struct {
        kioType Type;
	int iOutputLineLen;
	int iMaxOutputChars;
	union {FILE* File; char * Buff; } In;
	union {FILE* File; char * Buff; } Out;
} kioStruc;

extern int 
keyinc(const keyrec KeyTable[], int iNpar, char * pzProgName,
		kioStruc IOStream, char * pzReturnString);


#endif /* _KEYINC_H */
