/*******************************************************************************
proprietary.c

USNO/NRL Optical Interferometer
3450 Massachusetts Avenue NW
Washington DC 20392-5420

System: Data Reduction
Subsystem: AMOEBA

Description:
Wrappers for external libraries contributed by collaborators.

Modification history:
02-Oct-2003  C.A.Hummel, file created
*******************************************************************************/

/* Includes */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#define NRANSI
#include "nrutil.h"
#include "export.h"
#include "ccs.h"

/* Defines */

#define PI 3.141592653589793
#define NEG(x) ((x) > 0 ? -(x) : (x))
#define MIN(x,y) ((x) > (y) ? (y) : (x))
#define MAX(x,y) ((x) > (y) ? (x) : (y))
#define RAD(x) ((x)/360.*2.*PI)

/* Function prototypes */

/* ...callable from IDL */

int shadow(int argc, char *argp[]);
int wilson(int argc, char *argp[]);
int devinney(int argc, char *argp[]);

int imlc_(float *pfWDPARMS,float *fSPOTPARMS,IDL_LONG *piILC,IDL_LONG *piCLC,
		double *pdfXLC,double *pdfYLC,double *pdfFLC);
int rvlc_(float *pfWDPARMS,float *fSPOTPARMS,IDL_LONG *piILC,IDL_LONG *piCLC,double *pdfXLC,double *pdfYLC,double *pdfFLC,
		IDL_LONG *piJLC,float *pfPHAS,float *pfHKM1,float *pfHKM2);

ccsCOMPL_STAT issshadowAltAz(
                    double alt,
                    double az,
                    int teltype,
                    int location,
                    int noofRayRadial,
                    int noofRayAngular,
                    double *shadow,
		    ccsERROR *error
                    );


/* Global variables; storage for data used in fit routines */

/*----------------------------------------------------------------------------*/
int shadow(int argc, char *argp[]){
	/*
	*/

	int i,j;
	IDL_LONG *piN_AZ,*piN_EL,*piLoc,*piTelType;
	double *pfAZ,*pfEL,*pfShadow;
	double f;
	float *pfR,*pfT;
	ccsERROR error;
	ccsCOMPL_STAT status;

	int teltype=5,noofRayRadial=10,noofRayAngular=10;

        if (argc != 9) {
                fprintf(stderr,"\nWrong # of parameters(%d)",argc);
                return(1);
                }

	piN_AZ=       ((IDL_LONG**)argp)[0];
	piN_EL=       ((IDL_LONG**)argp)[1];
	pfAZ=      ((double**)argp)[2];
	pfEL=      ((double**)argp)[3];
	pfShadow=  ((double**)argp)[4];
	piLoc=        ((IDL_LONG**)argp)[5];
	pfR=        ((float**)argp)[6];
	pfT=        ((float**)argp)[7];
	piTelType=    ((IDL_LONG**)argp)[8];

	for (i=0;i<piN_EL[0];i++) {
		for (j=0;j<piN_AZ[0];j++) {
			status=issshadowAltAz(pfEL[i],pfAZ[j],
					      piTelType[0],piLoc[0],
					      noofRayRadial,noofRayAngular,
					      &f,&error);
			pfShadow[i*piN_AZ[0]+j]=f;
			pfR[i*piN_AZ[0]+j]=90.-pfEL[i];
			pfT[i*piN_AZ[0]+j]=(pfAZ[j]-90)/52.7;
			}
		}
	}
/*----------------------------------------------------------------------------*/
int wilson(int argc, char *argp[]){
	/* Wrapper for IMLC routine by R.E. Wilson
	*/

	IDL_LONG *piILC,*piCLC;
	float *pfWDPARMS,*pfSPOTPARMS;
	double *pdfXLC,*pdfYLC,*pdfFLC;

        if (argc != 7) {
                fprintf(stderr,"\nWrong # of parameters(%d)",argc);
                return(1);
                }

	pfWDPARMS=  ((float**)argp)[0];
	pfSPOTPARMS=((float**)argp)[1];
	piILC=   ((IDL_LONG**)argp)[2];
	piCLC=   ((IDL_LONG**)argp)[3];
	pdfXLC=    ((double**)argp)[4];
	pdfYLC=    ((double**)argp)[5];
	pdfFLC=    ((double**)argp)[6];

	imlc_(pfWDPARMS,pfSPOTPARMS,piILC,piCLC,pdfXLC,pdfYLC,pdfFLC);

	return(0);
	}
/*----------------------------------------------------------------------------*/
int devinney(int argc, char *argp[]){
	/* Wrapper for IMLC routine by Wilson and Devinney
	*/

	IDL_LONG *piILC,*piJLC,*piCLC;
	float *pfWDPARMS,*pfSPOTPARMS;
	double *pdfXLC,*pdfYLC,*pdfFLC;
	float *pfPHAS,*pfHKM1,*pfHKM2;

        if (argc != 11) {
                fprintf(stderr,"\nWrong # of parameters(%d)",argc);
                return(1);
                }

	pfWDPARMS=  ((float**)argp)[0];
	pfSPOTPARMS=((float**)argp)[1];
	piILC=   ((IDL_LONG**)argp)[2];
	piCLC=   ((IDL_LONG**)argp)[3];
	pdfXLC=    ((double**)argp)[4];
	pdfYLC=    ((double**)argp)[5];
	pdfFLC=    ((double**)argp)[6];
	piJLC=   ((IDL_LONG**)argp)[7];
	pfPHAS=     ((float**)argp)[8];
	pfHKM1=     ((float**)argp)[9];
	pfHKM2=     ((float**)argp)[10];

	rvlc_(pfWDPARMS,pfSPOTPARMS,piILC,piCLC,pdfXLC,pdfYLC,pdfFLC,
		piJLC,pfPHAS,pfHKM1,pfHKM2);

	return(0);
	}
/*----------------------------------------------------------------------------*/
