/*******************************************************************************
swap.c


USNO/NRL Optical Interferometer
3450 Massachusetts Avenue, NW
Washington, DC 20392-5420

System:  Data Reduction
Subsystem: Constrictor


description:
------------

functions: 
----------

modification history:
--------------------

*******************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#include "swap.h"

/*******************************************************************************
swap

description:
------------

*******************************************************************************/

short swapshort(short i) {
  swap((unsigned char*)&i,sizeof(short));
  return(i);
  }

int swapint(int i) {
  swap((unsigned char*)&i,sizeof(int));
  return(i);
  }

int swaplong(long i) {
  swap((unsigned char*)&i,sizeof(long));
  return(i);
  }
 
float swapfloat(float x) {
  swap((unsigned char*)&x,sizeof(float));
  return(x);
  }

double swapdouble(double x) {
  swap((unsigned char*)&x,sizeof(double));
  return(x);
  }

void swap (x, size)
  unsigned char *x;
  int size; {

  unsigned char  c;
  unsigned short s;
  unsigned long  l;

  switch (size) {
    case 2:        /* swap two bytes */
      c = *x;
      *x = *(x+1);
      *(x+1) = c;
      break;
    case 4:        /* swap two shorts (2-byte words) */
      s = *(unsigned short *)x;
      *(unsigned short  *)x = *((unsigned short *)x + 1);
      *((unsigned short *)x + 1) = s;
      swap ((unsigned char *)x,   2);
      swap ((unsigned char *)((unsigned short *)x+1), 2);
      break;
    case 8:        /* swap two longs (4-bytes words) */
      l = *(unsigned long *)x;
      *(unsigned long  *)x = *((unsigned long *)x + 1);
      *((unsigned long *)x + 1) = l;
      swap ((unsigned char *)x,   4);
      swap ((unsigned char *)((unsigned long *)x+1), 4);
      break;
    default:
      exit(1);
    }
  }
