;*******************************************************************************
; File: hds.pro
;
; Description:
; ------------
; This file contains the PV-WAVE wrapper functions and procedures for the
; C-functions in hds_wrap.c, with which they share common names. Note that,
; variables do not have to be allocated in PV-WAVE prior to the procedure call.
;
; Block directory:
; ----------------
; Block 1: cmp_calloc,dat_calloc
; Block 2: toplevel,clearstatus,hds_state,hds_new,hds_open,hds_close
; Block 3: cmp_
; Block 4: cmp_get,cmp_put
; Block 5: dat_
; Block 6: dat_get,dat_put
;
;
;************************************************************************Block 1
function cmp_calloc,name
;
; Allocates and returns a string to hold component 'name'.
;
dat_find,name
dat_clen,clen
dat_annul
string=''
for i=0L,clen-1 do string=string+' '
return,string
end
;-------------------------------------------------------------------------------
function dat_calloc
;
; Allocates and returns a string to hold component at current location.
;
dat_clen,clen
string=''
for i=0L,clen-1 do string=string+' '
return,string
end
;************************************************************************Block 2
pro toplevel
status=linknload(!external_lib,'toplevel')
end
;-------------------------------------------------------------------------------
pro clearstatus
hds_close
status=linknload(!external_lib,'clearstatus')
hds_close
end
;-------------------------------------------------------------------------------
function hds_state
;
; Note: there is no HDS installation available under HP-UX.
;
state=0L
r=file_search(!oyster_dir+'source/hds*')
if strlen(r(0)) gt 0 then $
	status=linknload(!external_lib,'hds_state',state)
return,state
end
;-------------------------------------------------------------------------------
pro hds_new,filename,name,type,status
;
; Opens new HDS file (overwriting existing one) and returns status.
;
common Hds,path,hds_file_stub
;
if hds_state() ne 0 then begin
	print,'***Error: Please close current file before opening another one!'
	status=-1
	return
endif
;
if n_elements(filename) eq 0 then begin
	filename=''
	read,'Please enter HDS file name: ',filename
endif
;
if n_elements(name) eq 0 then begin
	name=''
	read,'Please enter name of toplevel object to be created: ',name
endif
;
if n_elements(type) eq 0 then begin
	type=''
	read,'Please enter type of toplevel object to be created: ',type
endif
;
ndim=0L
dims=lonarr(7)
status=linknload(!external_lib,'hds_new',filename,name,type,ndim,dims)
if status ne 0 then begin
	print,'***Error: error creating file!'
	return
endif
print,'File '+filename+' created.'
status=0
;
end
;-------------------------------------------------------------------------------
pro hds_open,filename,mode,status
;
; Opens existing HDS file and returns status.
;
common Hds,path,hds_file_stub
;
; See whether a file is currently open (only one can be open at a time)
if hds_state() ne 0 then begin
	print,'***Error: Please close current file before opening another one!'
	status=-1
	return
endif
;
; Did the user forget to specify the file?
if n_elements(filename) eq 0 then begin
	spawn,'ls *.c??'
	filename=''
	read,'Please enter HDS file name: ',filename
endif
;
; The default mode is READ only
if n_elements(mode) eq 0 then mode='READ'
;
; Does the file exist?
result=file_search(filename,count=fcount)
if fcount ne 1 then begin
	print,'***Error(HDS_OPEN): '+filename+' does not exist!'
	status=-1
	return
endif else filename=result(0)
;
; Check whether it is an HDS file (first three bytes SDS)
openr,unit,filename,/get_lun
x=0b & y=0b & z=0b
readu,unit,x,y,z
free_lun,unit
if x ne 83 or y ne 68 or z ne 83 then begin
	print,'***Error(HDS_OPEN): file not HDS format!'
	status=-1
	return
endif
;
; Extract date portion
hds_file_stub=npoifile(filename)
;
; Extract the path
path=pathname(filename)
;
status=linknload(!external_lib,'hds_open',filename,mode)
if status ne 0 then begin
	print,'***Error(HDS_OPEN): error opening file!'
	clearstatus
	status=-1
	return
endif
;
print,'HDS-file opened; mode=',mode,'.' 
status=0
;
end
;-------------------------------------------------------------------------------
pro hds_close
if hds_state() eq 0 then return
toplevel
dat_annul
print,'HDS file closed.'
end
;************************************************************************Block 3
pro cmp_shape,name,ndim,dims
ndim=0L
dims=lonarr(7)
status=linknload(!external_lib,'cmp_shape',name,dims,ndim)
end
;-------------------------------------------------------------------------------
pro cmp_size,name,size
;
dat_find,name
dat_size,size
dat_annul
end
;************************************************************************Block 4
pro cmp_get0c,name,data
data=cmp_calloc(name)
len=strlen(data)
status=linknload(!external_lib,'cmp_get0c',name,data,len)
data=strtrim(data,2)
end
;-------------------------------------------------------------------------------
pro cmp_get0i,name,value
value=0L
status=linknload(!external_lib,'cmp_get0i',name,value)
end
;-------------------------------------------------------------------------------
pro cmp_get0r,name,value
value=0.
status=linknload(!external_lib,'cmp_get0r',name,value)
end
;-------------------------------------------------------------------------------
pro cmp_get0d,name,value
value=0D
status=linknload(!external_lib,'cmp_get0d',name,value)
end
;-------------------------------------------------------------------------------
pro cmp_get1c,name,num,data
cmp_size,name,size
data=strarr(size)
string=cmp_calloc(name)
data(*)=string
len=strlen(string)
status=linknload(!external_lib,'cmp_get1c',name,size,data,len)
if n_params() eq 2 then num=data else data=strtrim(data(0:num-1),2)
end
;-------------------------------------------------------------------------------
pro cmp_get1i,name,num,data
cmp_size,name,size
data=lonarr(size,/nozero)
status=linknload(!external_lib,'cmp_get1i',name,size,data)
if n_params() eq 2 then num=data else data=data(0:num-1)
end
;-------------------------------------------------------------------------------
pro cmp_get1r,name,num,data
cmp_size,name,size
data=fltarr(size,/nozero)
status=linknload(!external_lib,'cmp_get1r',name,size,data)
if n_params() eq 2 then num=data else data=data(0:num-1)
end
;-------------------------------------------------------------------------------
pro cmp_get1d,name,num,data
cmp_size,name,size
data=dblarr(size,/nozero)
status=linknload(!external_lib,'cmp_get1d',name,size,data)
if n_params() eq 2 then num=data else data=data(0:num-1)
end
;-------------------------------------------------------------------------------
pro cmp_getnc,name,ndim,dims,data
dim=dims(0:ndim-1)
data=make_array(size=[ndim,dim,7,produkt(dim)],/nozero)
string=cmp_calloc(name)
data(*)=string
len=strlen(string)
status=linknload(!external_lib,'cmp_getnc',name,ndim,dims,data,len)
data=strtrim(data,2)
end
;-------------------------------------------------------------------------------
pro cmp_getni,name,ndim,dims,data
ndim_l=long(ndim)
dims=long(dims)
dim=dims(0:ndim-1)
data=make_array(size=[ndim,dim,3,produkt(dim)],/nozero)
status=linknload(!external_lib,'cmp_getni',name,ndim_l,dims,data)
end
;-------------------------------------------------------------------------------
pro cmp_getnr,name,ndim,dims,data
ndim_l=long(ndim)
dims=long(dims)
dim=dims(0:ndim-1)
data=make_array(size=[ndim,dim,4,produkt(dim)],/nozero)
status=linknload(!external_lib,'cmp_getnr',name,ndim_l,dims,data)
end
;-------------------------------------------------------------------------------
pro cmp_getnd,name,ndim,dims,data
ndim_l=long(ndim)
dims=long(dims)
dim=dims(0:ndim-1)
data=make_array(size=[ndim,dim,5,produkt(dim)],/nozero)
status=linknload(!external_lib,'cmp_getnd',name,ndim_l,dims,data)
end
;-------------------------------------------------------------------------------
pro cmp_get0c,name,data
dat_find,name,status & if status ne 0 then return
dat_get0c,data
dat_annul
end
;-------------------------------------------------------------------------------
pro cmp_get0i,name,value
dat_find,name,status & if status ne 0 then return
dat_get0i,value
dat_annul
end
;-------------------------------------------------------------------------------
pro cmp_get0r,name,value
dat_find,name,status & if status ne 0 then return
dat_get0r,value
dat_annul
end
;-------------------------------------------------------------------------------
pro cmp_get0d,name,value
dat_find,name,status & if status ne 0 then return
dat_get0d,value
dat_annul
end
;-------------------------------------------------------------------------------
pro cmp_get1c,name,num,data
dat_find,name,status & if status ne 0 then return
dat_get1c,num,data
dat_annul
end
;-------------------------------------------------------------------------------
pro cmp_get1i,name,num,data
dat_find,name,status & if status ne 0 then return
dat_get1i,num,data
dat_annul
end
;-------------------------------------------------------------------------------
pro cmp_get1r,name,num,data
dat_find,name,status & if status ne 0 then return
dat_get1r,num,data
dat_annul
end
;-------------------------------------------------------------------------------
pro cmp_get1d,name,num,data
dat_find,name,status & if status ne 0 then return
dat_get1d,num,data
dat_annul
end
;-------------------------------------------------------------------------------
pro cmp_getnc,name,ndim,dims,data
dat_find,name,status & if status ne 0 then return
dat_getnc,ndim,dims,data
dat_annul
end
;-------------------------------------------------------------------------------
pro cmp_getni,name,ndim,dims,data
dat_find,name,status & if status ne 0 then return
dat_getni,ndim,dims,data
dat_annul
end
;-------------------------------------------------------------------------------
pro cmp_getnr,name,ndim,dims,data
dat_find,name,status & if status ne 0 then return
dat_getnr,ndim,dims,data
dat_annul
end
;-------------------------------------------------------------------------------
pro cmp_getnd,name,ndim,dims,data
dat_find,name,status & if status ne 0 then return
dat_getnd,ndim,dims,data
dat_annul
end
;-------------------------------------------------------------------------------
pro cmp_put0c,name,string
status=linknload(!external_lib,'cmp_put0c',name,string)
end
;-------------------------------------------------------------------------------
pro cmp_put0i,name,value
value=long(value)
status=linknload(!external_lib,'cmp_put0i',name,value)
end
;-------------------------------------------------------------------------------
pro cmp_put0r,name,value
value=float(value)
status=linknload(!external_lib,'cmp_put0r',name,value)
end
;-------------------------------------------------------------------------------
pro cmp_put0d,name,value
value=double(value)
status=linknload(!external_lib,'cmp_put0d',name,value)
end
;-------------------------------------------------------------------------------
pro cmp_put1c,name,data
num=n_elements(data)
len=max(strlen(data))
status=linknload(!external_lib,'cmp_put1c',name,num,data,len)
end
;-------------------------------------------------------------------------------
pro cmp_put1i,name,values
num=n_elements(values)
status=linknload(!external_lib,'cmp_put1i',name,num,values)
end
;-------------------------------------------------------------------------------
pro cmp_put1r,name,values
num=n_elements(values)
status=linknload(!external_lib,'cmp_put1r',name,num,values)
end
;-------------------------------------------------------------------------------
pro cmp_put1d,name,values
num=n_elements(values)
status=linknload(!external_lib,'cmp_put1d',name,num,values)
end
;-------------------------------------------------------------------------------
pro cmp_putnc,name,ndim,dims,data
ndim_l=long(ndim)
dims=long(dims)
len=strlen(data(0))
status=linknload(!external_lib,'cmp_putnc',name,ndim_l,dims,data,len)
end
;-------------------------------------------------------------------------------
pro cmp_putni,name,ndim,dims,values
ndim_l=long(ndim)
dims=long(dims)
status=linknload(!external_lib,'cmp_putni',name,ndim_l,dims,values)
end
;-------------------------------------------------------------------------------
pro cmp_putnr,name,ndim,dims,values
ndim_l=long(ndim)
dims=long(dims)
status=linknload(!external_lib,'cmp_putnr',name,ndim_l,dims,values)
end
;-------------------------------------------------------------------------------
pro cmp_putnd,name,ndim,dims,values
ndim_l=long(ndim)
dims_l=long(dims)
status=linknload(!external_lib,'cmp_putnd',name,ndim_l,dims_l,values)
end
;************************************************************************Block 5
pro dat_there,name,reply
reply=0L
if hds_state() eq 0 then begin
	print,'***Error(DAT_THERE): no file open!'
	return
endif
status=linknload(!external_lib,'dat_there',name,reply)
if (status eq 0) and (n_params() eq 0) then print,'Reply = ',reply
end
;-------------------------------------------------------------------------------
pro dat_find,name,status
dat_there,name,reply
if not reply then status=-1 else $
		  status=linknload(!external_lib,'dat_find',name)
if status ne 0 then print,'Warning(DAT_FIND): component not found: ',name,'!'
end
;-------------------------------------------------------------------------------
pro dat_name,name
;
; Pre-Fedora 27 version
name='123456789012345'
name_b=byte(name)
status=linknload(!external_lib,'dat_name',name_b)
name=string(name_b)
name=strcompress(name)
if (status eq 0) and (n_params() eq 0) then print,'Name = ',name 
end
;-------------------------------------------------------------------------------
pro dat_name,name
name='               '
status=linknload(!external_lib,'dat_name',name)
name=strcompress(name,/remove_all)
if (status eq 0) and (n_params() eq 0) then print,'Name = ',name 
end
;-------------------------------------------------------------------------------
pro dat_type,type
;
; Pre-Fedora 27 version
type='123456789012345'
type_b=byte(type)
status=linknload(!external_lib,'dat_type',type_b)
type=string(type_b)
if (status eq 0) and (n_params() eq 0) then print,'Type = ',type
end
;-------------------------------------------------------------------------------
pro dat_type,type
type='               '
status=linknload(!external_lib,'dat_type',type)
type=strcompress(type,/remove_all)
if (status eq 0) and (n_params() eq 0) then print,'Type = ',type
end
;-------------------------------------------------------------------------------
pro dat_ncomp,ncomp
ncomp=0L
status=linknload(!external_lib,'dat_ncomp',ncomp)
if (status eq 0) and (n_params() eq 0) then print,'Components = ',ncomp
end
;-------------------------------------------------------------------------------
pro dat_prim,reply
reply=0L
status=linknload(!external_lib,'dat_prim',reply)
if (status eq 0) and (n_params() eq 0) then print,'Reply = ',reply
end
;-------------------------------------------------------------------------------
pro dat_size,size
size=0L
status=linknload(!external_lib,'dat_size',size)
if (status eq 0) and (n_params() eq 0) then print,'Size = ',size
end
;-------------------------------------------------------------------------------
pro dat_shape,ndim,dims
ndim=0L
dims=lonarr(7)
status=linknload(!external_lib,'dat_shape',dims,ndim)
if (status eq 0) and (n_params() eq 0) then print,'Shape = ',dims(0:ndim-1)
end
;-------------------------------------------------------------------------------
pro dat_clen,clen
clen=0L
status=linknload(!external_lib,'dat_clen',clen)
if (status eq 0) and (n_params() eq 0) then print,'Length = ',clen
end
;-------------------------------------------------------------------------------
pro dat_cell,ndim,cell,status
ndim_l=long(ndim)
cell_l=long(cell)
dat_shape,ndims,cells
status=0
if ndims ne ndim_l then status=1
for i=0,ndims-1 do if cell_l(i) gt cells(i) then status=-1
for i=0,ndims-1 do if cell_l(i) eq 0        then status=-1
if status eq -1 then begin
	print,'***Error(DAT_CELL): invalid cell address!'
	return
endif
status=linknload(!external_lib,'dat_cell',ndim_l,cell_l)
end
;-------------------------------------------------------------------------------
pro dat_index,index
i=long(index)
status=linknload(!external_lib,'dat_index',i)
end
;-------------------------------------------------------------------------------
pro dat_new,name,type,ndim,dims
ndim_l=long(ndim)
dims_l=long(dims)
status=linknload(!external_lib,'dat_new',name,type,ndim_l,dims_l)
end
;-------------------------------------------------------------------------------
pro dat_new0c,name,len
len_l=long(len)
status=linknload(!external_lib,'dat_new0c',name,len_l)
end
;-------------------------------------------------------------------------------
pro dat_slice,ndim,diml,dimu
ndim_l=long(ndim)
diml_l=long(diml)
dimu_l=long(dimu)
status=linknload(!external_lib,'dat_slice',ndim_l,diml_l,dimu_l)
end
;-------------------------------------------------------------------------------
pro dat_alter,ndim,dims
;
; Note: only the last dimension may change!
;
ndim_l=long(ndim)
dims_l=long(dims)
status=linknload(!external_lib,'dat_alter',ndim_l,dims_l)
end
;-------------------------------------------------------------------------------
pro dat_erase,name
;
; Recursively delete a component.
;
status=linknload(!external_lib,'dat_erase',name)
end
;-------------------------------------------------------------------------------
pro dat_annul
;
; Annul locator. Close file if locator was associated with top level object.
;
status=linknload(!external_lib,'dat_annul')
end
;************************************************************************Block 6
pro dat_get,type,ndim,dims,data
ndim_l=long(ndim)
dims_l=long(dims)
case type of
	'_UBYTE':	begin
			t=1
			len=1L
			v=byte(0)
			end
	'_BYTE':	begin
			t=1
			len=1L
			v=byte(0)
			end
	'_WORD':	begin
			t=2
			len=2L
			v=0
			end
	'_INTEGER':	begin
			t=3
			len=4L
			v=0L
			end
	'_REAL':	begin
			t=4
			len=4L
			v=0.0
			end
	'_DOUBLE':	begin
			t=5
			len=8L
			v=0.D0
			end
	else:	begin
		if strpos(type,'_CHAR') ne -1 then begin
			t=7
			len=long(strmid(type,6,strlen(type)-6))
			v=''
			for i=0,len-1 do v=v+' '
		endif else begin
			print,'Type not implemented: ',type
			return
		endelse
		end
endcase
if ndim gt 0 then begin
	dim=dims(0:ndim-1)
	data=make_array(size=[ndim,dim,t,produkt(dim)],/nozero)
	if t eq 7 then data(*)=v
endif else data=v
status=linknload(!external_lib,'dat_get',type,ndim_l,dims_l,data,len)
if t eq 7 then data=strtrim(data,2)
end
;-------------------------------------------------------------------------------
pro dat_get0c,string
string=dat_calloc()
clen=strlen(string)
status=linknload(!external_lib,'dat_get0c',string,clen)
string=strtrim(string,2)
end
;-------------------------------------------------------------------------------
pro dat_get0i,value
value=0L
status=linknload(!external_lib,'dat_get0i',value)
end
;-------------------------------------------------------------------------------
pro dat_get0r,value
value=0.
status=linknload(!external_lib,'dat_get0r',value)
end
;-------------------------------------------------------------------------------
pro dat_get0d,value
value=0D
status=linknload(!external_lib,'dat_get0d',value)
end
;-------------------------------------------------------------------------------
pro dat_get1i,num,data
num_l=long(num)
data=lonarr(num,/nozero)
status=linknload(!external_lib,'dat_get1i',num_l,data)
end
;-------------------------------------------------------------------------------
pro dat_get1r,num,data
num_l=long(num)
data=fltarr(num,/nozero)
status=linknload(!external_lib,'dat_get1r',num_l,data)
end
;-------------------------------------------------------------------------------
pro dat_get1d,num,data
num_l=long(num)
data=dblarr(num,/nozero)
status=linknload(!external_lib,'dat_get1d',num_l,data)
end
;-------------------------------------------------------------------------------
pro dat_getni,ndim,dims,data
ndim_l=long(ndim)
dims_l=long(dims)
dim=dims(0:ndim-1)
data=make_array(size=[ndim,dim,3,produkt(dim)],/nozero)
status=linknload(!external_lib,'dat_getni',ndim_l,dims_l,data)
end
;-------------------------------------------------------------------------------
pro dat_getnr,ndim,dims,data
ndim_l=long(ndim)
dims_l=long(dims)
dim=dims(0:ndim-1)
data=make_array(size=[ndim,dim,4,produkt(dim)],/nozero)
status=linknload(!external_lib,'dat_getnr',ndim_l,dims_l,data)
end
;-------------------------------------------------------------------------------
pro dat_getnd,ndim,dims,data
ndim_l=long(ndim)
dims_l=long(dims)
dim=dims(0:ndim-1)
data=make_array(size=[ndim,dim,5,produkt(dim)],/nozero)
status=linknload(!external_lib,'dat_getnd',ndim_l,dims_l,data)
end
;-------------------------------------------------------------------------------
pro dat_get0c,string
string=dat_calloc()
len=strlen(string)
status=linknload(!external_lib,'dat_get0c',string,len)
string=strtrim(string,2)
end
;-------------------------------------------------------------------------------
pro dat_get0i,value
value=0L
status=linknload(!external_lib,'dat_get0i',value)
end
;-------------------------------------------------------------------------------
pro dat_get0r,value
value=0.
status=linknload(!external_lib,'dat_get0r',value)
end
;-------------------------------------------------------------------------------
pro dat_get0d,value
value=0D
status=linknload(!external_lib,'dat_get0d',value)
end
;-------------------------------------------------------------------------------
pro dat_get1c,num,data
dat_size,size
data=strarr(size)
string=dat_calloc()
data(*)=string
len=strlen(string)
status=linknload(!external_lib,'dat_get1c',size,data,len)
if n_params() eq 1 then num=data else data=strtrim(data(0:num-1),2)
end
;-------------------------------------------------------------------------------
pro dat_get1i,num,data
dat_size,size
data=lonarr(size,/nozero)
status=linknload(!external_lib,'dat_get1i',size,data)
if n_params() eq 1 then num=data else data=data(0:num-1)
end
;-------------------------------------------------------------------------------
pro dat_get1r,num,data
dat_size,size
data=fltarr(size,/nozero)
status=linknload(!external_lib,'dat_get1r',size,data)
if n_params() eq 1 then num=data else data=data(0:num-1)
end
;-------------------------------------------------------------------------------
pro dat_get1d,num,data
dat_size,size
data=dblarr(size,/nozero)
status=linknload(!external_lib,'dat_get1d',size,data)
if n_params() eq 1 then num=data else data=data(0:num-1)
end
;-------------------------------------------------------------------------------
pro dat_getnc,ndim,dims,data
dim=dims(0:ndim-1)
data=make_array(size=[ndim,dim,7,produkt(dim)],/nozero)
string=dat_calloc()
data(*)=string
len=strlen(string)
status=linknload(!external_lib,'dat_getnc',ndim,dims,data,len)
data=strtrim(data,2)
end
;-------------------------------------------------------------------------------
pro dat_getni,ndim,dims,data
ndim_l=long(ndim)
dims=long(dims)
dim=dims(0:ndim-1)
data=make_array(size=[ndim,dim,3,produkt(dim)],/nozero)
status=linknload(!external_lib,'dat_getni',ndim_l,dims,data)
end
;-------------------------------------------------------------------------------
pro dat_getnr,ndim,dims,data
ndim_l=long(ndim)
dims=long(dims)
dim=dims(0:ndim-1)
data=make_array(size=[ndim,dim,4,produkt(dim)],/nozero)
status=linknload(!external_lib,'dat_getnr',ndim_l,dims,data)
end
;-------------------------------------------------------------------------------
pro dat_getnd,ndim,dims,data
ndim_l=long(ndim)
dims=long(dims)
dim=dims(0:ndim-1)
data=make_array(size=[ndim,dim,5,produkt(dim)],/nozero)
status=linknload(!external_lib,'dat_getnd',ndim_l,dims,data)
end
;-------------------------------------------------------------------------------
pro dat_put0c,string
status=linknload(!external_lib,'dat_put0c',string)
end
;-------------------------------------------------------------------------------
pro dat_put0i,data
status=linknload(!external_lib,'dat_put0i',data)
end
;-------------------------------------------------------------------------------
pro dat_put0r,data
status=linknload(!external_lib,'dat_put0r',data)
end
;-------------------------------------------------------------------------------
pro dat_put0d,data
status=linknload(!external_lib,'dat_put0d',data)
end
;-------------------------------------------------------------------------------
pro dat_put1c,data
num=n_elements(data)
len=strlen(data(0))
status=linknload(!external_lib,'dat_put1c',num,data,len)
end
;-------------------------------------------------------------------------------
pro dat_put1i,num,data
num_l=long(num)
status=linknload(!external_lib,'dat_put1i',num_l,data)
end
;-------------------------------------------------------------------------------
pro dat_put1r,num,data
num_l=long(num)
status=linknload(!external_lib,'dat_put1r',num_l,data)
end
;-------------------------------------------------------------------------------
pro dat_put1d,num,data
num_l=long(num)
status=linknload(!external_lib,'dat_put1d',num_l,data)
end
;-------------------------------------------------------------------------------
pro dat_putnc,ndim,dims,data
ndim_l=long(ndim)
dims_l=long(dims)
len=strlen(data(0))
status=linknload(!external_lib,'dat_putnc',ndim_l,dims_l,data,len)
end
;-------------------------------------------------------------------------------
pro dat_putni,ndim,dims,data
ndim_l=long(ndim)
dims_l=long(dims)
status=linknload(!external_lib,'dat_putni',ndim_l,dims_l,data)
end
;-------------------------------------------------------------------------------
pro dat_putnr,ndim,dims,data
ndim_l=long(ndim)
dims_l=long(dims)
status=linknload(!external_lib,'dat_putnr',ndim_l,dims_l,data)
end
;-------------------------------------------------------------------------------
pro dat_putnd,ndim,dims,data
ndim_l=long(ndim)
dims_l=long(dims)
status=linknload(!external_lib,'dat_putnd',ndim_l,dims_l,data)
end
;-------------------------------------------------------------------------------
