;*******************************************************************************
; File: math.lib
;
; Description:
; ------------
; This file contains various procedures for the AMOEBA software.
; Marquardt-Levenberg algorithms implemented in IDL.
;
; Block directory:
; ----------------
; Block 1: marquardtmin,marquardtcof,svd8,svb8,gaussj8
;
;************************************************************************Block 1
pro marquardtmin,x,y,sig,ndata,a,ia,ma,covar,alpha,chisq,func,alamda,tol
;
common MLLS,mfit,ochisq,atry,betta,neev,neevi
;
if alamda lt 0 then begin
	index=where(ia ne 0,mfit)
	alamda=abs(alamda)
	marquardtcof,x,y,sig,ndata,a,ia,ma,alpha,betta,chisq,func
	ochisq=chisq
	atry=a
	neev=intarr(1000)-1
	neevi=0
	return
endif
;
covar=alpha
index=indgen(mfit)
covar[index,index]=alpha[index,index]*(1+alamda)
;
status=0
if mfit eq 1 then begin
	covar=1/covar
	da=covar*betta
endif else begin
	print,'Calling svdc...'
	svdc,covar,w,u,v,/double
;	svd8,covar,w,u,v	; double precision version of NR
	small=where(w lt max(w)*tol,count)
	neev[neevi]=count & neevi=neevi+1
	if alamda eq 0 then begin
		si=sort(w)
		ws=w[si]
		count=medianve(neev[0:neevi-1])
		if count ge 1 then small=where(w le ws[count-1])
	endif
	if not !quiet then begin
		if count eq 1 $
		then print,'SVD: will edit',count,' singular value!' $
		else print,'SVD: will edit',count,' singular values!'
	endif
	if count gt 0 then w[small]=0
	da=svsol(u,w,v,betta,/double)
;	svb8,u,w,v,betta,da	; double precision version of NR
;
;	covar=invert(covar,status)
;	if status eq 1 then print,'***Warning(MRQMIN): singular array!'
;	if status eq 2 then print,'***Warning(MRQMIN): small pivot!'
;	da=covar#betta
;
endelse
;
; Compute parameter uncertainties (covariance matrix)
if alamda eq 0 then begin
	if mfit eq 1 then return
	for i=0,mfit-1 do begin
		betta[*]=0 & betta[i]=1
		da=svsol(u,w,v,betta,/double)
;		svb8,u,w,v,betta,da ; double precision version of NR
		covar[*,i]=da
	endfor	
	return
endif
;
index=where(ia ne 0)
atry[index]=a[index]+da[0:mfit-1]
marquardtcof,x,y,sig,ndata,atry,ia,ma,covar,da,chisq,func
;
if chisq lt ochisq then begin
	alamda=alamda*0.2
	ochisq=chisq
	alpha=covar
	betta=da
	a=atry
endif else begin
	alamda=alamda*10
	chisq=ochisq
endelse
;
end
;-------------------------------------------------------------------------------
pro marquardtcof,x,y,sig,ndata,a,ia,ma,alpha,betta,chisq,func
;
index=where(ia ne 0,mfit)
alpha=dblarr(mfit,mfit)
betta=dblarr(mfit)
case func of
	'ellfuncs':	ellfuncs,x,y,a,ymod,    dyda,ma,ndata,ia
	'orbfuncs':	orbfuncs,x,  a,ymod,    dyda,ma,ndata,ia
	'modfuncs':	modfuncs,x,y,a,ymod,sig,dyda,ma,ndata,ia
	'maskfuncs':	maskfuncs,x,y,a,ymod,sig,dyda,ma,ndata,ia
endcase
sig2i=1.d0/sig^2
dy=y-ymod
chisq=total(dy^2*sig2i)
wt=dblarr(ndata,mfit,/nozero)
for i=0,mfit-1 do begin
	wt[*,i]=dyda[*,index[i]]*sig2i
	betta[i]=total(dy*wt[*,i])
endfor
for i=0,mfit-1 do for j=0,i do begin
	alpha[i,j]=total(wt[*,i]*dyda[*,index[j]])
	alpha[j,i]=alpha[i,j]
endfor
;
end
;-------------------------------------------------------------------------------
pro svd8,a,w,u,v
;
; Calls C-function svdwave, a double-precision implementation of
; Numerical Recipes (CUP) Singular-Value-Decomposition routine.
; A = U#W#tv.
;
;
a_save=a
a=double(a)
;
m=n_elements(a[*,0])
n=n_elements(a[0,*])
w=dblarr(n,/nozero)
v=dblarr(n,n,/nozero)
;
status=linknload(!external_lib,'svdwave',a,m,n,w,v)
;
u=a
a=a_save
;
end
;-------------------------------------------------------------------------------
pro svb8,u,w,v,b,x
;
; Solves Ax=b, for A=u#w#tv from SVD. Double-precision implementation.
;
;
u=double(u)
w=double(w)
v=double(v)
b=double(b)
m=n_elements(u[*,0])
n=n_elements(u[0,*])
x=dblarr(n)
;
status=linknload(!external_lib,'svbwave',u,w,v,m,n,b,x)
;
end
;-------------------------------------------------------------------------------
pro gaussj8,a,b
;
; Double-precision implementation.
;
;
a=double(a)
b=double(b)
n=n_elements(b[*,0])
m=n_elements(b[0,*])
;
status=linknload(!external_lib,'gaussjwave',a,n,b,m)
;
end
;************************************************************************Block 2
pro hichol,v,iv,jv,ni,ns,nm
;
;
status=linknload(!external_lib,'hi_chol_wrapper',v,iv,jv,ni,ns,nm)
;
end
;-------------------------------------------------------------------------------
pro hisolve,v,iv,jv,ni,ns,nm,r,s
;
;
status=linknload(!external_lib,'hi_solve_wrapper',v,iv,jv,ni,ns,nm,r,s)
;
end
;-------------------------------------------------------------------------------
pro hires,vd,iv,jv,rd,rn,s,nm
;
;
rn=dblarr(nm)
;
status=linknload(!external_lib,'hi_res_wrapper',vd,iv,jv,rd,rn,s,nm)
;
end
;-------------------------------------------------------------------------------
