;
; Copyright 2005, 2006 University of Leiden.
;
; This file is part of MIA+EWS.
;
; MIA+EWS is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; MIA+EWS is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with MIA; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
a1 = {FitsFile,     $  ;#class members#
filename:'',        $  ;string & fits file name
unit:0L,            $  ;long   & logical unit no. 
openStatus:'',      $  ;string & READ/WRITE status at opening
state:0L,           $  ;long   & current file status (open/closed..)
priHead:OBJ_NEW(),  $  ;object & file primary header object
eof:0L,             $  ;long   & position of file EOF in bytes
isExt:0B,           $  ;bool   & are there extensions
numExt:0L,          $  ;long   & number of known extensions
lastExt:OBJ_NEW()   $  ;object & last known extensions
}

a2 = {FitsHeader, $  ;#class members#
type:'',         $   ;string & header type:PRIMARY or EXTENSION
extName:'',      $   ;string & if extension which type
lines:0L,        $   ;long   & number of lines in header
endPos:0L,       $   ;long   & positions of header end (bytes)
keyWords:PTR_NEW(),$ ;ptr->string array & list of header keywords
head:PTR_NEW()   $   ;ptr->string array& list of header records
}

a3 = {FitsImage,    $  ;#class members#
INHERITS FITSFILE,  $  ;#class inheritance#
bitpix:0,           $  ;int  & FITS bits/pixel indicator
bytesPlane:0L,      $  ;long & bytes per image plane
naxis:PTR_NEW(),    $  ;ptr->long array & image dimensions
bzero:0.0d,         $
bscale:1.0d,        $
diskIdlType:0B,     $  ;byte & IDL internal equivalent of bitpix
dataStart:0L,       $  ;long & position of 1st data point (bytes)
dataEnd:0L,         $  ;long & position after last data point
dataCurrent:0L,     $  ;long & current reading position
planeCurrent:0L,    $  ;long & current plane being read/written
planeLast:0L,       $  ;long & number of last plane known
dataBuff:PTR_NEW(), $  ;ptr  & read/write buffer
buffPlanes:0L,      $  ;long & number of planes that fit in buffer
headerStatus:'',    $  ;string & indicates whether header is in \cr
                       ;local storage, on disk...
dataStatus:''       $  ;string & where is data
}

a4 = {FitsExtension,$ ;#class members#
file:OBJ_NEW(),     $  ;ptr->FITSFILE & to which file does extension belong
extName:'',         $  ;string & type of extension
extNumber:0L,       $  ;long   & sequence number
headStart:0L,       $  ;long   & position of start of header (bytes)
dataStart:0L,       $  ;long   & position of start of data
dataEnd:0L,         $  ;long   & position of end of data
dataCurrent:0L,     $  ;long   & position currently being read/written
dataStatus:'',      $  ;string & READ/WRITE..
priHead:OBJ_NEW(),  $  ;ptr    & primary header of file
head:OBJ_NEW(),     $  ;ptr    & extension header object 
headerStatus:''     $  ;string & 'DISK','LOCAL'...
}

a5={FitsTable, $       ;#class members#
INHERITS FITSEXTENSION, $;#class inheritance#
table:PTR_NEW(),     $ ;ptr->structure & internal IDL representation of \cr
                       ;table data
strucTemp:PTR_NEW(), $ ;ptr->structure & internal rep. of one row
subStrucTemp:PTR_NEW(), $;ptr->structure & internal rep. of selected columns
subStructCol:PTR_NEW(),  $;ptr->int array & which columns selected
floatCol:PTR_NEW(),$ ;ptr->int array & colmns with float conversion
naxis1:0L, $         ;long   & bytes per row
naxis2:0L, $         ;long   & number of rows in file
naxis2_POS:0L, $     ;long   & position of NAXIS2 keyword in file
tfields:0L, $        ;long   & number of columns
heap:0L, $           ;long   & not currently used
dheap:0, $           ;long   & not currently used
ttype:PTR_NEW(),  $  ;ptr->str array & names of columns
format:PTR_NEW(), $  ;ptr->str array & column formatting info
idlType:PTR_NEW(),$  ;ptr->int array& idl types of each column
nElem:PTR_NEW(), $   ;ptr->long array & number of elements per column
tScale:PTR_NEW(), $  ;ptr->dbl array &rescaling per column
tZero:PTR_NEW(),  $  ;ptr->dbl array &offsets per column    
maxVaL:PTR_NEW(), $  ;ptr & ? not implemented
nDims:PTR_NEW(), $   ;ptr->long  &array dimensions of each column
bytOff:PTR_NEW(), $  ;ptr->long  &position in file of column rel. start of row
buffSize:0L,      $  ;long   & max size of i/o buffer (bytes)
oRead:0L,         $  ;long   & size of last read block of data (bytes)
dataTemp:PTR_NEW() $ ;ptr    & buffer containing data just read
}

a6={EXTENSIONDEF, $       ;#non-class structure#
fileName:'',     $     ;string & file name
extName:'',      $     ;string & extension name
extNumber:0L     $     ;long   & extension number
}


