pro a12sini_binaries
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Given e and p[d], compute a1sini from k1 [km] and a2sini [km] from k2 [km/s]
; See Batten, Fletcher and MacCarthy, 8th catalogue, page 2.
;
common StarBase,StarTable,Notes
;
index=where(StarTable.e ge 0,count)
;
StarTable[index].a1sini= $
	StarTable[index].k1 $
	*(sqrt(1.0-StarTable[index].e^2)*StarTable[index].p*13751.0)
;
StarTable[index].a2sini= $
	StarTable[index].k2 $
	*(sqrt(1.0-StarTable[index].e^2)*StarTable[index].p*13751.0)
;
end
