pro a_binaries
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Estimate semi-major axis [arcsec] of binaries using Kepler's third law.
; Requires mass, mass2, p[d], d[pc].
;
common StarBase,StarTable,Notes
;
index=where((StarTable.mass ne 0) $
	and (StarTable.mass2 ne 0) $
	and (StarTable.p ne 0) $
	and (StarTable.d ne 0),count)
if count gt 0 then begin
	StarTable[index].a= $
		(StarTable[index].mass+StarTable[index].mass2)^(1./3) $
		*(StarTable[index].p/365.25)^(2./3)/StarTable[index].d
endif
;
end
