function a_sini,p,e,k1,k2,px=px
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return a*sin(i) [km] for a given binary component or the sum (k1,k2).
; If keyword px is set to the parallax ["], return a_sini [mas].
;
; Period p [d], eccentricity e, semi-amplitudes k1, k2 (optional) [km/s]
; Example for HD 22128: print,a_sini(5.08,0,68.4,73.7,px=0.0058)
; Inputs can be arrays
;
common AstroConstants,m_sun,r_sun,a_unit,s_year
;
RAD=180/!pi
; d[pc]=1/px["]
pc=(a_unit/sin((1./3600)/RAD))/1000	; [km]
semi_axis2=0
;
if keyword_set(px) then d=1/px	; [PC]
;
semi_axis=k1*sqrt(1.0-e^2)*p*13751.0	; [km]
if n_elements(k2) gt 0 then $
semi_axis2=k2*sqrt(1.0-e^2)*p*13751.0	; [km]
if n_elements(k2) gt 0 then semi_axis=semi_axis+semi_axis2
if keyword_set(px) then begin
	semi_axis=atan((semi_axis/(d*pc))*RAD)*3600.*1000. ; [mas]
endif
;
return,semi_axis
;
end
