function add,x,n,dim,sdev=sdev
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Sum every n samples along dimension dim (first is 0) of a matrix x.
; If the requested dimension is larger than the number of dimensions
; of x, it defaults to the last dimension of x.
;
if n_elements(dim) eq 0 then dim=0
;
if n eq 1 then return,x
;
r=size(x)
dim=dim < (r[0]-1)
k=r[1+dim]/n
r0=r
r0[1+dim]=k
result=make_array(size=r0)
sdev=make_array(size=r0)
;
r1=r
r1[1+dim]=1
m=produkt(r1[1:r[0]])
if dim eq 0 then m1=1 else m1=produkt(r1[1:dim])
m2=m1*k
index=(lindgen(m)/m1)*m2+(lindgen(m) mod m1)
;
r2=r
r2[1+dim]=n
m2=produkt(r[1:dim+1])
jndex=(lindgen(m*n)/(m1*n))*m2+(lindgen(m*n) mod (m1*n))
;
for i=0L,k-1 do begin
	result[index+i*m1]=summe(reform(x[jndex+i*m1*n],r2[1:r[0]]),dim,sdev=sd)
	sdev[index+i*m1]=sd
endfor
;
return,result
;
end
