pro add_component,component,origin,reference
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; e.g. add_component,'B-C','A-C','A-B' does B-C=A-C-(A-B)
;
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
n_old=n_elements(positions)
index=where(positions.component eq origin,n_new)
new_positions=replicate(location(),n_old+n_new)
new_positions[0:n_old-1].component=positions.component
new_positions[0:n_old-1].date=positions.date
new_positions[0:n_old-1].jy=positions.jy
new_positions[0:n_old-1].jd=positions.jd
new_positions[0:n_old-1].rho=positions.rho
new_positions[0:n_old-1].theta=positions.theta
new_positions[0:n_old-1].rhom=positions.rhom
new_positions[0:n_old-1].thetam=positions.thetam
new_positions[0:n_old-1].emajor=positions.emajor
new_positions[0:n_old-1].eminor=positions.eminor
new_positions[0:n_old-1].pa=positions.pa
;
RAD=180/!pi
jd0=2440000.d0
;
for i=0,n_new-1 do begin
	p=reform(binarypos(jd0+positions[index[i]].jd,reference))
	rar=p[0]*sin(p[1]/RAD)
	dcr=p[0]*cos(p[1]/RAD)
	rao=positions[index[i]].rho*sin(positions[index[i]].theta)
	dco=positions[index[i]].rho*cos(positions[index[i]].theta)
	dra=rao-rar
	ddc=dco-dcr
	new_positions[n_old+i].component=component
	new_positions[n_old+i].rho=sqrt(dra^2+ddc^2)
	new_positions[n_old+i].theta=atan(dra,ddc)
	new_positions[n_old+i].date=positions[index[i]].date
	new_positions[n_old+i].jy=positions[index[i]].jy
	new_positions[n_old+i].jd=positions[index[i]].jd
	new_positions[n_old+i].emajor=positions[index[i]].emajor
	new_positions[n_old+i].eminor=positions[index[i]].eminor
	new_positions[n_old+i].pa=positions[index[i]].pa
endfor
;
positions=new_positions
;
end
