pro add_startable,starids
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Non-destructive add of starids to startable. If some starids exist, they
; will be left untouched. If no startable exists yet, it will be created.
;
common StarBase,StarTable,Notes
;
if n_elements(starids) eq 0 then return
;
if n_elements(startable) ne 0 then table0=startable
get_startable,starids
if n_elements(table0) eq 0 then return
table1=startable
;
; Create combined startable
create_startable,unique([table0.starid,table1.starid])
;
; Fill info, giving priority to existing entries
for i=0,n_elements(startable)-1 do begin
	index0=where(table0.starid eq startable[i].starid,count0)
	index1=where(table1.starid eq startable[i].starid,count1)
	if count0 eq 1 then t=table0[index0] else t=table1[index1]
	for j=0,n_tags(startable)-1 do startable[i].(j)=t[0].(j)
endfor
;
end
