function addbincounts,c,n
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Fast addition specifically for bincounts with all three dimensions.
;
if n eq 1 then return,c
;
r=size(c)
if r[0] eq 2 then begin
	nb=n_elements(c[*,0])
	nf=n_elements(c[0,*])
	nr=nf/n
	r=intarr(nb,nr)
;
	for i=0L,nr-1 do r[*,i]=total(c[*,i*n:(i+1)*n-1],2)
endif else begin
	nb=n_elements(c[*,0,0])
	nc=n_elements(c[0,*,0])
	nf=n_elements(c[0,0,*])
	nr=nf/n
	r=intarr(nb,nc,nr)
;
	for i=0L,nr-1 do r[*,*,i]=total(c[*,*,i*n:(i+1)*n-1],3)
endelse
;
return,r
;
end
