pro addcal,stars0,vlimit,klimit=klimit
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; For a given list of stars, find the closest calibrators brighter than vlimit,
; and add them to the startable.
;
common StarBase,startable,notes
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
if n_elements(stars0) eq 0 then begin
	print,'***Error(ADDCAL): stars not defined!'
	return
endif else stars0=strupcase(stars0)
;
if n_elements(klimit) eq 0 then klimit=0 else klimit=1
;
if n_elements(vlimit) eq 0 then vlimit=5.0
RAD=180/pi_circle
;
if n_elements(startable) ne 0 then table=startable
get_startable,stars0
ra0=startable.ra*15/RAD
dec0=startable.dec/RAD
;
; Read the diameter list with the calibrator information
n=0
d=0.0
z=0.0
a_0=0.0
a_1=0.0
a_2=0.0
c=''
status=dc_read_free(!oyster_dir+'starbase/diameter.bsc', $
	n,d,z,a_0,a_1,a_2,c,/col,resize=[1,2,3,4,5,6,7],ignore=['!'])
if status ne 0 then return
;
; Select the calibrators
index=where(c eq 'C') & n=n[index]
get_startable,'BSC'+string(n,format='(i4.4)')
get_jhk
rename_bsc
rename_starids,'bsc-fkv'
if klimit then index=where(startable.mk lt klimit,count) $
	  else index=where(startable.mv lt vlimit,count)
if count eq 0 then begin
	print,'***Error(ADDCAL): no stars bright enough found!'
	return
endif
;
ra=startable[index].ra*15/RAD
dec=startable[index].dec/RAD
stars=startable[index].starid
names=strcompress(startable[index].name)
cals=strarr(n_elements(stars0))
;
for i=0,n_elements(stars0)-1 do begin
	index=where(stars ne stars0[i])
	stars1=stars[index] & names1=names[index]
	ra1=ra[index] & dec1=dec[index]
	dist=sqrt(((ra1-ra0[i])*cos(dec1))^2+(dec1-dec0[i])^2)
	j=where(dist eq min(dist))
	cals[i]=stars1[j]
	print,'Adding calibrator ',cals[i],' (',names1[j],')', $
		' for star ',stars0[i],format='(a,a,a,a,a,a,a)'
endfor
;
if n_elements(table) ne 0 then begin
	startable=table
	addstar,cals
endif else get_startable,cals
;
end
