pro addstar,stars
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Add one or more stars to the startable. Create the latter, if not existent.
; Leave old table intact but remove duplicate entries.
;
common StarBase,startable,notes
;
if n_elements(stars) eq 0 then begin
	print,'***Error(ADDSTAR): stars not defined!'
	return
endif else stars=strupcase(stars)
;
if n_elements(startable) ne 0 then table=startable
get_startable,stars
if n_elements(table) ne 0 then startable=merge_startable(table,startable)
;
si=sort(startable.starid)
startable=startable[si]
startable=startable[uniq(startable.starid)]
;
return
;
if n_elements(startable) eq 0 then get_startable,stars else begin
	stars=[startable.starid,stars]
	get_startable,unique(stars)
endelse
;
end
