function airypattern,image,pixscale,lamda,p_diameter,s_diameter,xoff,yoff
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return Airy pattern (pixel scale in mas) with or without central obstruction
; Image array must be provided with pixel scale [mas], and uneven number of
; pixels, e.g., image=fltarr(101,101)
;
; xoff and yoff [mas] allow to shift image.
;
; Equation: see https://en.wikipedia.org/wiki/Airy_disk
;
if n_params() lt 4 then begin
	print,'Error: not all mandatory parameters specified!'
	print,'Needs: image,pixscale,lambda,diam_tel,diam_sec,xoff,yoff'
	return,0
endif
k=2*!pi/lamda
a=p_diameter/2
;
; Compute angles theta in radians
mas2rad=!pi/(180l*3600000l)
dims=size(image,/dim)
theta=shift(dist(dims[0],dims[1]),dims[0]/2,dims[1]/2)*pixscale*mas2rad
;
; Apply offsets
theta[0:dims[0]/2,*]=theta[0:dims[0]/2,*]+xoff*mas2rad
theta[dims[0]/2+1:dims[0]-1,*]=theta[dims[0]/2+1:dims[0]-1,*]-xoff*mas2rad
theta[*,0:dims[1]/2]=theta[*,0:dims[1]/2]+yoff*mas2rad
theta[*,dims[1]/2+1:dims[1]-1]=theta[*,dims[1]/2+1:dims[1]-1]-yoff*mas2rad
;
arg=k*a*sin(theta)
index=where(arg eq 0) & arg[index]=0.1
epsilon=s_diameter/p_diameter
;
if s_diameter eq 0 then begin
    r=(2*beselj(arg,1)/arg)^2
    r[index]=1
endif else begin
    r=(2*beselj(arg,1)/arg-2*epsilon*beselj(epsilon*arg,1)/arg)^2/(1.-epsilon^2)
    r[index]=1
endelse
;
return,r
;
end
