function alloc_maps,icc,ccc,xcc,ycc,fcc,nx,ny
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; In OYSTER, a map is really a CLEAN component list. All input arrays here
; are 1-dimensional vectors. It is therefore not really an image, though
; they can hold one.
;
if n_elements(nx) eq 0 then nx=0
if n_elements(ny) eq 0 then ny=0
;
index=where(icc ne 0,n)
m=max(icc)
map=alloc_map(m,ccc[0:m-1],xcc[0:m-1],ycc[0:m-1],fcc[0:m-1])
maps=replicate(map,n)
;
j=0
for i=0,n-1 do begin
	maps[i].icc=icc[i]
	maps[i].ccc(0:icc[i]-1)=ccc[j:j+icc[i]-1]
	maps[i].xcc(0:icc[i]-1)=xcc[j:j+icc[i]-1]
	maps[i].ycc(0:icc[i]-1)=ycc[j:j+icc[i]-1]
	maps[i].fcc(0:icc[i]-1)=fcc[j:j+icc[i]-1]
	j=j+icc[i]
endfor
;
return,maps
;
end
