pro altair1
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; closure group delays
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common RawData,TimeStamp,LaserPos,GeoPos,QuadCounts, $
        Raw0,RawN,OutputBeam,BinCounts
;
get_data,'2002-07-07.raw.062.01'
t=fdlstamp()/1000. & t0=t[0] & t=t-t[0]
;
ob=1
ch=channelindex[genconfig.spectrometerid[ob]]-1
l=genconfig.wavelength[ch,ob]
d=gitter(121,-12e-6)
;
get_bincounts,2
hds_close
nphot=fringenphot(bincounts[*,ch,*])
;
window,/free
set_screen
!y.range=0
!p.multi=[0,2,3]
!p.charsize=1.0
;
f1=fdldelay(genconfig.baselineid[0,ob])
v1=fringevis(bincounts[*,ch,*],genconfig.fringemod[0,ob])
g1b=groupdelay(box(abs(visdft(v1,l,d)),10,1),l,d,g1i)
p1=cphase(total(visrotate( $
	v1,l,g1b+phaseshift(f1-g1b,l)*lambdawhite(v1,l)/(2*!pi)),1))
plot,t,p1,psym=3,ystyle=1
f2=fdldelay(genconfig.baselineid[1,ob])
v2=fringevis(bincounts[*,ch,*],genconfig.fringemod[1,ob])
g2b=groupdelay(box(abs(visdft(v2,l,d)),10,1),l,d,g2i)
p2=cphase(total(visrotate( $
	v2,l,g2b+phaseshift(f2-g2b,l)*lambdawhite(v2,l)/(2*!pi)),1))
plot,t,p2,psym=3,ystyle=1
f3=fdldelay(genconfig.baselineid[2,ob])
v3=fringevis(bincounts[*,ch,*],genconfig.fringemod[2,ob])
g3b=groupdelay(box(abs(visdft(v3,l,d)),10,1),l,d,g3i)
p3=cphase(total(visrotate( $
	v3,l,g3b+phaseshift(f3-g3b,l)*lambdawhite(v3,l)/(2*!pi)),1))
plot,t,p3,psym=3,ystyle=1
f4=fdldelay(genconfig.baselineid[3,ob])
v4=fringevis(bincounts[*,ch,*],genconfig.fringemod[3,ob])
g4b=groupdelay(box(abs(visdft(v4,l,d)),10,1),l,d,g4i)
p4=cphase(total(visrotate( $
	v4,l,g4b+phaseshift(f4-g4b,l)*lambdawhite(v4,l)/(2*!pi)),1))
plot,t,p4,psym=3,ystyle=1
f5=fdldelay(genconfig.baselineid[4,ob])
v5=fringevis(bincounts[*,ch,*],genconfig.fringemod[4,ob])
g5b=groupdelay(box(abs(visdft(v5,l,d)),10,1),l,d,g5i)
p5=cphase(total(visrotate( $
	v5,l,g5b+phaseshift(f5-g5b,l)*lambdawhite(v5,l)/(2*!pi)),1))
plot,t,p5,psym=3,ystyle=1
f6=fdldelay(genconfig.baselineid[5,ob])
v6=fringevis(bincounts[*,ch,*],genconfig.fringemod[5,ob])
g6b=groupdelay(box(abs(visdft(v6,l,d)),10,1),l,d,g6i)
p6=cphase(total(visrotate( $
	v6,l,g6b+phaseshift(f6-g6b,l)*lambdawhite(v6,l)/(2*!pi)),1))
plot,t,p6,psym=3,ystyle=1
;
g1b=g1b*1e6
g2b=g2b*1e6
g3b=g3b*1e6
g4b=g4b*1e6
g5b=g5b*1e6
g6b=g6b*1e6
;
; g1b=groupdelays(1,2,numav=10,gindex=g1i)*1e6
; g2b=groupdelays(2,2,numav=10,gindex=g2i)*1e6
; g3b=groupdelays(3,2,numav=10,gindex=g3i)*1e6
; g4b=groupdelays(4,2,numav=10,gindex=g4i)*1e6
; g5b=groupdelays(5,2,numav=10,gindex=g5i)*1e6
; g6b=groupdelays(6,2,numav=10,gindex=g6i)*1e6
;
; Compute closure group delays
t1=g1b-g2b-g6b
t2=g2b+g3b-g4b
t3=g3b-g5b-g6b
;
; Flag bad data
t1ib=where(g1i eq 0 or g2i eq 0 or g6i eq 0)
t2ib=where(g2i eq 0 or g3i eq 0 or g4i eq 0)
t3ib=where(g3i eq 0 or g5i eq 0 or g6i eq 0)
;
; Plot closure group delays
window,/free
set_screen
!p.charsize=2.0
!p.multi=[0,1,3]
!y.range=[-4,4]
!p.psym=3
x=findgen(n_elements(t))
plot,x,t1
oplot,x[t1ib],t1[t1ib],color=tci(2)
plot,x,t2
oplot,x[t2ib],t2[t2ib],color=tci(2)
plot,x,t3
oplot,x[t3ib],t3[t3ib],color=tci(2)
;
; Determine which data points are good
t1ig=where(g1i eq 1 and g2i eq 1 and g6i eq 1)
t2ig=where(g2i eq 1 and g3i eq 1 and g4i eq 1)
t3ig=where(g3i eq 1 and g5i eq 1 and g6i eq 1)
;
t1m=medianve(t1[t1ig],t1me)
t2m=medianve(t2[t2ig],t2me)
t3m=medianve(t3[t3ig],t3me)
;
; g1b=g1b-t1m
; g4b=g4b+t2m
; g5b=g5b+t3m
;
t1me=t1me*4
t2me=t2me*4
t3me=t3me*4
;
index1=where(g1i eq 1 and g2i eq 1 and g6i eq 1 $
	and abs(t1-t1m) gt t1me)
index2=where(g2i eq 1 and g3i eq 1 and g4i eq 1 $
	and abs(t2-t2m) gt t2me)
index3=where(g3i eq 1 and g5i eq 1 and g6i eq 1 $
	and abs(t3-t3m) gt t3me)
g1i2=g1i
g2i2=g2i
g3i2=g3i
g4i2=g4i
g5i2=g5i
g6i2=g6i
g1i2[index1]=0 & g2i2[index1]=0 & g6i2[index1]=0
g2i2[index2]=0 & g3i2[index2]=0 & g4i2[index2]=0
g3i2[index3]=0 & g5i2[index3]=0 & g6i2[index3]=0
;
; Prepare weights
n=n_elements(t)	; the number of data points, i.e. time stamps
wb1=total(g1i2)/n
wb2=total(g2i2)/n
wb3=total(g3i2)/n
wb4=total(g4i2)/n
wb5=total(g5i2)/n
wb6=total(g6i2)/n
;
; These will hold solutions for E2, C, W, and W7
se2=fltarr(n)
sac=fltarr(n)
saw=fltarr(n)
sw7=fltarr(n)
solns=fltarr(4,n)
;
se2i=intarr(n)+1
saci=intarr(n)+1
sawi=intarr(n)+1
sw7i=intarr(n)+1
solni=intarr(4,n)+1
;
; Design matrix, last line if for reference W
dm=transpose([[1,-1,0,0], $
	      [0,-1,1,0], $
	      [0,0,-1,1], $
	      [0,-1,0,1], $
	      [-1,0,0,1], $
	      [1,0,-1,0], $
	      [0,0,1,0]])
dm=float(dm)
weight=[wb1,wb2,wb3,wb4,wb5,wb6,1]
for j=0,n_elements(dm[0,*])-1 do dm[*,j]=dm[*,j]*sqrt(weight)
;
; For each time stamp, compute station based group delay solutions
for i=0l,n-1 do begin
	gindex=[g1i2[i],g2i2[i],g3i2[i],g4i2[i],g5i2[i],g6i2[i],1]
	gright=[g1b[i],g2b[i],g3b[i],g4b[i],g5b[i],g6b[i],0]*sqrt(weight)
	index=where(gindex eq 1,count)
	if count gt 0 then begin
		m=dm[index,*]
		g=gright[index]
		tm=transpose(m)
		norm=tm#m
		r=tm#g
		svd,norm,w,u,v
		small=where(w lt max(w)*1e-6,count)
		for j=0,count-1 do begin
			w[small[j]]=0
			solni[*,i]=solni[*,i]*(1-nint(abs(v[*,small[j]])))
		endfor
		svbksb,u,w,v,r,s
		solns[*,i]=s
	endif
endfor
;
; Extract solutions
se2=reform(solns[0,*])
sac=reform(solns[1,*])
saw=reform(solns[2,*])
sw7=reform(solns[3,*])
;
; Compute baseline solutions for the group delays
g1g=se2-sac
g2g=saw-sac
g3g=sw7-saw
g4g=sw7-sac
g5g=sw7-se2
g6g=se2-saw
;
; Add back median offsets
; g1g=g1g+t1m
; g4g=g4g-t2m
; g5g=g5g-t3m
;
g1g=g1g/1e6
g2g=g2g/1e6
g3g=g3g/1e6
g4g=g4g/1e6
g5g=g5g/1e6
g6g=g6g/1e6
;
; Plot phases rotated with the baseline solutions
window,/free
set_screen
!y.range=0
!p.multi=[0,2,3]
;
g1gc=g1g+phaseshift(f1-g1g,l)*lambdawhite(v1,l)/(2*!pi)
p1=cphase(total(visrotate(v1,l,g1gc),1))
plot,t,p1,psym=3,ystyle=1
g2gc=g2g+phaseshift(f2-g2g,l)*lambdawhite(v2,l)/(2*!pi)
p2=cphase(total(visrotate(v2,l,g2gc),1))
plot,t,p2,psym=3,ystyle=1
g3gc=g3g+phaseshift(f3-g3g,l)*lambdawhite(v3,l)/(2*!pi)
p3=cphase(total(visrotate(v3,l,g3gc),1))
plot,t,p3,psym=3,ystyle=1
g4gc=g4g+phaseshift(f4-g4g,l)*lambdawhite(v4,l)/(2*!pi)
p4=cphase(total(visrotate(v4,l,g4gc),1))
plot,t,p4,psym=3,ystyle=1
g5gc=g5g+phaseshift(f5-g5g,l)*lambdawhite(v5,l)/(2*!pi)
p5=cphase(total(visrotate(v5,l,g5gc),1))
plot,t,p5,psym=3,ystyle=1
g6gc=g6g+phaseshift(f6-g6g,l)*lambdawhite(v6,l)/(2*!pi)
p6=cphase(total(visrotate(v6,l,g6gc),1))
plot,t,p6,psym=3,ystyle=1
;
; Use baseline solutions to coherently integrate visibilities
cohint=10
;
p2d=lambdawhite(v1,l)/(2*!pi)
c1=phasescan(t,p1)
g2=g1gc-c1*p2d
c2=cphase(total(visrotate(v1,l,g2),1))
vis1=add(visrotate(v1,l,g2-c2*p2d),cohint,1)
;
p2d=lambdawhite(v2,l)/(2*!pi)
c1=phasescan(t,p2)
g2=g2gc-c1*p2d
c2=cphase(total(visrotate(v2,l,g2),1))
vis2=add(visrotate(v2,l,g2-c2*p2d),cohint,1)
;
p2d=lambdawhite(v3,l)/(2*!pi)
c1=phasescan(t,p3)
g2=g3gc-c1*p2d
c2=cphase(total(visrotate(v3,l,g2),1))
vis3=add(visrotate(v3,l,g2-c2*p2d),cohint,1)
;
p2d=lambdawhite(v4,l)/(2*!pi)
c1=phasescan(t,p4)
g2=g4gc-c1*p2d
c2=cphase(total(visrotate(v4,l,g2),1))
vis4=add(visrotate(v4,l,g2-c2*p2d),cohint,1)
;
p2d=lambdawhite(v5,l)/(2*!pi)
c1=phasescan(t,p5)
g2=g5gc-c1*p2d
c2=cphase(total(visrotate(v5,l,g2),1))
vis5=add(visrotate(v5,l,g2-c2*p2d),cohint,1)
;
p2d=lambdawhite(v6,l)/(2*!pi)
c1=phasescan(t,p6)
g2=g6gc-c1*p2d
c2=cphase(total(visrotate(v6,l,g2),1))
vis6=add(visrotate(v6,l,g2-c2*p2d),cohint,1)
;
; Compute triples for unaveraged and coherently av. data
ch=11
tv1=reform(v1[ch,*]*conj(v2[ch,*])*conj(v6[ch,*])) $
   -reform(complex(abs(v1[ch,*])^2 $
		  +abs(v2[ch,*])^2 $
		  +abs(v6[ch,*])^2 $
	    	  -2*nphot[ch,*],0))*0
tv2=reform(v2[ch,*]*     v3[ch,*] *conj(v4[ch,*])) $
   -reform(complex(abs(v2[ch,*])^2 $
		  +abs(v3[ch,*])^2 $
		  +abs(v4[ch,*])^2 $
	    	  -2*nphot[ch,*],0))*0
tv3=reform(v3[ch,*]*conj(v5[ch,*])*conj(v6[ch,*])) $
   -reform(complex(abs(v3[ch,*])^2 $
		  +abs(v5[ch,*])^2 $
		  +abs(v6[ch,*])^2 $
	    	  -2*nphot[ch,*],0))*0
tv4=reform(v4[ch,*]*conj(v5[ch,*])*conj(v1[ch,*])) $
   -reform(complex(abs(v4[ch,*])^2 $
		  +abs(v5[ch,*])^2 $
		  +abs(v1[ch,*])^2 $
	    	  -2*nphot[ch,*],0))*0
;
tvis1=reform(vis1[ch,*]*conj(vis2[ch,*])*conj(vis6[ch,*]))
tvis2=reform(vis2[ch,*]*     vis3[ch,*] *conj(vis4[ch,*]))
tvis3=reform(vis3[ch,*]*conj(vis5[ch,*])*conj(vis6[ch,*]))
tvis4=reform(vis4[ch,*]*conj(vis5[ch,*])*conj(vis1[ch,*]))
;
window,/free
set_screen
!y.range=[-150,150]
!p.multi=[0,2,4]
!p.charsize=2.0
rad=180/!pi
;
; Further average to the same time interval
plot,rad*cphase(add(tv1,1000)),psym=1
plot,rad*cphase(add(tvis1,100)),psym=1
plot,rad*cphase(add(tv2,1000)),psym=1
plot,rad*cphase(add(tvis2,100)),psym=1
plot,rad*cphase(add(tv3,1000)),psym=1
plot,rad*cphase(add(tvis3,100)),psym=1
plot,rad*cphase(add(tv4,1000)),psym=1
plot,rad*cphase(add(tvis4,100)),psym=1
;
end
