pro altair3a
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; closure fringe delays
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common RawData,TimeStamp,LaserPos,GeoPos,QuadCounts, $
        Raw0,RawN,OutputBeam,BinCounts
;
get_rawdata,'2002-07-07.raw.062'
t=fdlstamp()/1000. & t0=t[0] & t=t-t[0]
;
ob=1
ch=channelindex[genconfig.spectrometerid[ob]]-1
l=genconfig.wavelength[ch,ob]
d=gitter(121,-12e-6)
;
get_bincounts,2
hds_close
;
window,/free
set_screen
!y.range=0
!p.multi=[0,2,3]
!p.charsize=1.0
;
f1=fdldelay(genconfig.baselineid[0,ob])
v1=fringevis(bincounts[*,ch,*],genconfig.fringemod[0,ob])
p2d1=lambdawhite(v1,l)/(2*!pi)
g1b=groupdelay(box(abs(visdft(v1,l,d)),10,1),l,d,g1i)
g1p=g1b+phaseshift(f1-g1b,l)*p2d1
p1=cphase(total(visrotate(v1,l,g1p),1))
c1=phasescan(t,p1)
g1pca=g1p-c1*p2d1
plot,t,cphase(total(visrotate(v1,l,g1pca),1)),psym=3,ystyle=1
p1a=cphase(total(visrotate(v1,l,g1pca),1))
g1pc=g1pca-p1a*p2d1
;
f2=fdldelay(genconfig.baselineid[1,ob])
v2=fringevis(bincounts[*,ch,*],genconfig.fringemod[1,ob])
p2d2=lambdawhite(v2,l)/(2*!pi)
g2b=groupdelay(box(abs(visdft(v2,l,d)),10,1),l,d,g2i)
g2p=g2b+phaseshift(f2-g2b,l)*p2d2
p2=cphase(total(visrotate(v2,l,g2p),1))
c2=phasescan(t,p2)
g2pc=g2p-c2*p2d2
plot,t,cphase(total(visrotate(v2,l,g2pc),1)),psym=3,ystyle=1
p2=cphase(total(visrotate(v2,l,g2pc),1))
g2pc=g2pc-p2*p2d2
;
f3=fdldelay(genconfig.baselineid[2,ob])
v3=fringevis(bincounts[*,ch,*],genconfig.fringemod[2,ob])
p2d3=lambdawhite(v3,l)/(2*!pi)
g3b=groupdelay(box(abs(visdft(v3,l,d)),10,1),l,d,g3i)
g3p=g3b+phaseshift(f3-g3b,l)*p2d3
p3=cphase(total(visrotate(v3,l,g3p),1))
c3=phasescan(t,p3)
g3pc=g3p-c3*p2d3
plot,t,cphase(total(visrotate(v3,l,g3pc),1)),psym=3,ystyle=1
p3=cphase(total(visrotate(v3,l,g3pc),1))
g3pc=g3pc-p3*p2d3
;
f4=fdldelay(genconfig.baselineid[3,ob])
v4=fringevis(bincounts[*,ch,*],genconfig.fringemod[3,ob])
p2d4=lambdawhite(v4,l)/(2*!pi)
g4b=groupdelay(box(abs(visdft(v4,l,d)),10,1),l,d,g4i)
g4p=g4b+phaseshift(f4-g4b,l)*p2d4
p4=cphase(total(visrotate(v4,l,g4p),1))
c4=phasescan(t,p4)
g4pc=g4p-c4*p2d4
plot,t,cphase(total(visrotate(v4,l,g4pc),1)),psym=3,ystyle=1
p4=cphase(total(visrotate(v4,l,g4pc),1))
g4pc=g4pc-p4*p2d4
;
f5=fdldelay(genconfig.baselineid[4,ob])
v5=fringevis(bincounts[*,ch,*],genconfig.fringemod[4,ob])
p2d5=lambdawhite(v5,l)/(2*!pi)
g5b=groupdelay(box(abs(visdft(v5,l,d)),10,1),l,d,g5i)
g5p=g5b+phaseshift(f5-g5b,l)*p2d5
p5=cphase(total(visrotate(v5,l,g5p),1))
c5=phasescan(t,p5)
g5pc=g5p-c5*p2d5
plot,t,cphase(total(visrotate(v5,l,g5pc),1)),psym=3,ystyle=1
p5=cphase(total(visrotate(v5,l,g5pc),1))
g5pc=g5pc-p5*p2d5
;
f6=fdldelay(genconfig.baselineid[5,ob])
v6=fringevis(bincounts[*,ch,*],genconfig.fringemod[5,ob])
p2d6=lambdawhite(v6,l)/(2*!pi)
g6b=groupdelay(box(abs(visdft(v6,l,d)),10,1),l,d,g6i)
g6p=g6b+phaseshift(f6-g6b,l)*p2d6
p6=cphase(total(visrotate(v6,l,g6p),1))
c6=phasescan(t,p6)
g6pc=g6p-c6*p2d6
plot,t,cphase(total(visrotate(v6,l,g6pc),1)),psym=3,ystyle=1
p6=cphase(total(visrotate(v6,l,g6pc),1))
g6pc=g6pc-p6*p2d6
;
g1pc=g1pc*1e6
g2pc=g2pc*1e6
g3pc=g3pc*1e6
g4pc=g4pc*1e6
g5pc=g5pc*1e6
g6pc=g6pc*1e6
;
t1=g1pc-g2pc-g6pc
t2=g2pc+g3pc-g4pc
t3=g3pc-g5pc-g6pc
;
t1ib=where(g1i eq 0 or g2i eq 0 or g6i eq 0)
t2ib=where(g2i eq 0 or g3i eq 0 or g4i eq 0)
t3ib=where(g3i eq 0 or g5i eq 0 or g6i eq 0)
;
window,/free
set_screen
!p.charsize=2.0
!p.multi=[0,1,3]
!y.range=[-4,4]
!p.psym=3
plot,t,t1
oplot,t[t1ib],t1[t1ib],color=tci(2)
plot,t,t2
oplot,t[t2ib],t2[t2ib],color=tci(2)
plot,t,t3
oplot,t[t3ib],t3[t3ib],color=tci(2)
;
t1ig=where(g1i eq 1 and g2i eq 1 and g6i eq 1)
t2ig=where(g2i eq 1 and g3i eq 1 and g4i eq 1)
t3ig=where(g3i eq 1 and g5i eq 1 and g6i eq 1)
;
t1m=medianve(t1[t1ig],t1me)
t2m=medianve(t2[t2ig],t2me)
t3m=medianve(t3[t3ig],t3me)
;
t1me=t1me*4
t2me=t2me*4
t3me=t3me*4
;
index1=where(g1i eq 1 and g2i eq 1 and g6i eq 1 $
	and abs(t1-t1m) gt t1me)
index2=where(g2i eq 1 and g3i eq 1 and g4i eq 1 $
	and abs(t2-t2m) gt t2me)
index3=where(g3i eq 1 and g5i eq 1 and g6i eq 1 $
	and abs(t3-t3m) gt t3me)
g1i2=g1i
g2i2=g2i
g3i2=g3i
g4i2=g4i
g5i2=g5i
g6i2=g6i
g1i2[index1]=0 & g2i2[index1]=0 & g6i2[index1]=0
g2i2[index2]=0 & g3i2[index2]=0 & g4i2[index2]=0
g3i2[index3]=0 & g5i2[index3]=0 & g6i2[index3]=0
;
n=n_elements(t)
wb1=total(g1i2)/n
wb2=total(g2i2)/n
wb3=total(g3i2)/n
wb4=total(g4i2)/n
wb5=total(g5i2)/n
wb6=total(g6i2)/n
;
se2=fltarr(n)
sac=fltarr(n)
saw=fltarr(n)
sw7=fltarr(n)
solns=fltarr(4,n)
;
se2i=intarr(n)+1
saci=intarr(n)+1
sawi=intarr(n)+1
sw7i=intarr(n)+1
solni=intarr(4,n)+1
;
dm=transpose([[1,-1,0,0], $
	      [0,-1,1,0], $
	      [0,0,-1,1], $
	      [0,-1,0,1], $
	      [-1,0,0,1], $
	      [1,0,-1,0], $
	      [0,0,1,0]])
dm=float(dm)
weight=[wb1,wb2,wb3,wb4,wb5,wb6,1]
wf=[0.1,1.0,1.0,0.1,0.1,1.0,1.0]
weight=weight*wf
for j=0,n_elements(dm[0,*])-1 do dm[*,j]=dm[*,j]*sqrt(weight)
for i=0l,n-1 do begin
	gindex=[g1i2[i],g2i2[i],g3i2[i],g4i2[i],g5i2[i],g6i2[i],1]
	gright=[g1pc[i],g2pc[i],g3pc[i],g4pc[i],g5pc[i],g6pc[i],0]*sqrt(weight)
	index=where(gindex eq 1,count)
	if count gt 0 then begin
		m=dm[index,*]
		g=gright[index]
		tm=transpose(m)
		norm=tm#m
		r=tm#g
		svd,norm,w,u,v
		small=where(w lt max(w)*1e-6,count)
		for j=0,count-1 do begin
			w[small[j]]=0
			solni[*,i]=solni[*,i]*(1-nint(abs(v[*,small[j]])))
		endfor
		svbksb,u,w,v,r,s
		solns[*,i]=s
	endif
endfor
;
index=where(solni[0,*] eq 1 and solni[1,*] eq 1 $
	and solni[2,*] eq 1 and solni[3,*] eq 1)
se2=reform(solns[0,index])
sac=reform(solns[1,index])
saw=reform(solns[2,index])
sw7=reform(solns[3,index])
;
t=t[index]
;
g1g=se2-sac
g2g=saw-sac
g3g=sw7-saw
g4g=sw7-sac
g5g=sw7-se2
g6g=se2-saw
;
g1g=g1g/1e6
g2g=g2g/1e6
g3g=g3g/1e6
g4g=g4g/1e6
g5g=g5g/1e6
g6g=g6g/1e6
;
cohint=10
;
vis1=add(visrotate(v1[*,index],l,g1g),cohint,1)
vis2=add(visrotate(v2[*,index],l,g2g),cohint,1)
vis3=add(visrotate(v3[*,index],l,g3g),cohint,1)
vis4=add(visrotate(v4[*,index],l,g4g),cohint,1)
vis5=add(visrotate(v5[*,index],l,g5g),cohint,1)
vis6=add(visrotate(v6[*,index],l,g6g),cohint,1)
;
k=0
tv1=reform(v1[k,*]*conj(v2[k,*])*conj(v6[k,*]))
tv2=reform(v2[k,*]*v3[k,*]*conj(v4[k,*]))
tv3=reform(v3[k,*]*conj(v5[k,*])*conj(v6[k,*]))
tv4=reform(v4[k,*]*conj(v5[k,*])*conj(v1[k,*]))
;
tvis1=reform(vis1[k,*]*conj(vis2[k,*])*conj(vis6[k,*]))
tvis2=reform(vis2[k,*]*vis3[k,*]*conj(vis4[k,*]))
tvis3=reform(vis3[k,*]*conj(vis5[k,*])*conj(vis6[k,*]))
tvis4=reform(vis4[k,*]*conj(vis5[k,*])*conj(vis1[k,*]))
;
window,/free
set_screen
!y.range=[-180,180]
!p.multi=[0,2,4]
!p.charsize=2.0
rad=180/!pi
;
plot,rad*cphase(add(tv1,100)),psym=3
plot,rad*cphase(add(tvis1,10)),psym=3
plot,rad*cphase(add(tv2,100)),psym=3
plot,rad*cphase(add(tvis2,10)),psym=3
plot,rad*cphase(add(tv3,100)),psym=3
plot,rad*cphase(add(tvis3,10)),psym=3
plot,rad*cphase(add(tv4,100)),psym=3
plot,rad*cphase(add(tvis4,10)),psym=3
;
end
