function amber,lambda,p,t,f
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return refractive index for air. lambda[mu], p[mb], t[C], f[mb]
; According to memo of A. Merand, Jan 2009.
; Note that hPa=mb!
;
if n_params() gt 0 and n_params() lt 4 then begin
	p=ppair(2635)		; mb
	t=12.d0      		; C
	f=ppwv(t,35)*p/1013.	; mb
endif
;
tk=t+273.15d0	; temperature in Kelvin
;
return,1.+1d-6*(1.+0.00752/lambda^2)*(77.6*p/tk+3.73d-5*f/tk^2)
;
end
