function amv_star,spectrum
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return absolute V-magnitude M_V from spectral classification.
n=n_elements(spectrum)
if n eq 0 then return,-1
pmv=fltarr(n)
spec_parse,spectrum,type,class,type2,class2
;
index=dwarfs(class,type)
if index[0] ne -1 then pmv[index]=amv_dwarf(type[index])
;
index=subgiants(class,type)
if index[0] ne -1 then pmv[index]=amv_subgiant(type[index])
;
index=giants(class,type)
if index[0] ne -1 then pmv[index]=amv_giant(type[index])
;
index=brightgiants(class,type)
if index[0] ne -1 then pmv[index]=amv_brightgiant(type[index])
;
index=supergiants(class,type)
if index[0] ne -1 then pmv[index]=amv_supergiant(type[index])
;
if n eq 1 then pmv=pmv[0]
return,pmv
;
end
