pro amv_stars
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Derive absolute V-magnitude M_V for all stars from spectral classification.
; For double stars, M_V will be the combined absolute magnitude.
;
common StarBase,startable,notes
;
; Dwarfs
d_type=''
d_ft=0.
d_t=0.
d_c=0.
d_mv=0.
d_mb=0.
status=dc_read_free(!oyster_dir+'starbase/spec_par.V', $
	d_type,d_ft,d_t,d_c,d_mv,d_mb, $
	/col,resize=[1,2,3,4,5],ignore=['!'])
d_r=poly_fit(d_ft,d_mv,5)
;
; Uncomment next lines for plot of M_V-spectral type relationship
; !p.charsize=1.5
; plot,findgen(70),poly(findgen(70),d_r),title='Dwarfs',yrange=[20,-8], $
; 	xtitle='Integer Spectral type',ytitle='Absolute magnitude'
; oplot,d_ft,d_mv,psym=6
;
index=where(startable.class gt 4.5 $
		and startable.type ne 0,count)
if count gt 0 then startable[index].amv=poly(startable[index].type,d_r)
;
; Sub-giants
subg_type=''
subg_ft=0.
subg_mv=0.
status=dc_read_free(!oyster_dir+'starbase/spec_MV.IV', $
	subg_type,subg_ft,subg_mv, $
	/col,resize=[1,2,3],ignore=['!'])
subg_r=poly_fit(subg_ft,subg_mv,3)
;
; Uncomment next lines for plot of M_V-spectral type relationship
; !p.charsize=1.5
; plot,findgen(70),poly(findgen(70),subg_r),title='Sub-giants',yrange=[20,-8], $
; 	xtitle='Integer Spectral type',ytitle='Absolute magnitude'
; oplot,subg_ft,subg_mv,psym=6
;
index=where(startable.class le 4.5 and startable.class gt 3.5 $
		and startable.type ne 0,count)
if count gt 0 then startable[index].amv=poly(startable[index].type,d_r)
;
; Giants
g_type=''
g_ft=0.
g_t=0.
g_c=0.
g_mv=0.
g_mb=0.
status=dc_read_free(!oyster_dir+'starbase/spec_par.III', $
	g_type,g_ft,g_t,g_c,g_mv,g_mb, $
	/col,resize=[1,2,3,4,5],ignore=['!'])
g_r=poly_fit(g_ft,g_mv,5)
;
; Uncomment next lines for plot of M_V-spectral type relationship
; !p.charsize=1.5
; plot,findgen(70),poly(findgen(70),g_r),title='Giants',yrange=[20,-8], $
; 	xtitle='Integer Spectral type',ytitle='Absolute magnitude'
; oplot,g_ft,g_mv,psym=6
;
index=where(startable.class le 3.5 and startable.class gt 2.5 $
		and startable.type ne 0,count)
if count gt 0 then startable[index].amv=poly(startable[index].type,g_r)
;
; Bright-Giants
bg_type=''
bg_ft=0.
bg_mv=0.
status=dc_read_free(!oyster_dir+'starbase/spec_MV.II',bg_type,bg_ft,bg_mv, $
	/col,resize=[1,2,3],ignore=['!'])
bg_r=poly_fit(bg_ft,bg_mv,4)
;
; Uncomment next lines for plot of M_V-spectral type relationship
; !p.charsize=1.5
; plot,findgen(70),poly(findgen(70),bg_r),title='Bright-giants',yrange=[20,-8],
; 	xtitle='Integer Spectral type',ytitle='Absolute magnitude'
; oplot,bg_ft,bg_mv,psym=6
;
index=where(startable.class le 2.5 and startable.class gt 1.75 $
		and startable.type ne 0,count)
if count gt 0 then startable[index].amv=poly(startable[index].type,g_r)
;
; Super-Giants
; sg_type=''
; sg_ft=0.
; sg_t=0.
; sg_c=0.
; sg_mv=0.
; sg_mb=0.
; status=dc_read_free(!oyster_dir+'starbase/spec_par.Iab', $
; 	sg_type,sg_ft,sg_t,sg_c,sg_mv,sg_mb, $
; 	/col,resize=[1,2,3,4,5],ignore=['!'])
; sg_r=poly_fit(sg_ft,sg_mv,5)
;
; Uncomment next lines for plot of M_V-spectral type relationship
; !p.charsize=1.5
; plot,findgen(70),poly(findgen(70),sg_r),title='Super-Giants',yrange=[20,-8], $
; 	xtitle='Integer Spectral type',ytitle='Absolute magnitude'
; oplot,sg_ft,sg_mv,psym=6
;
; index=where(fix(startable.class) eq 1,count)
; if count gt 0 then startable(index).amv=poly(startable(index).type,sg_r)
;
; Super-giants Ia
sgIa_type=''
sgIa_ft=0.
sgIa_mv=0.
status=dc_read_free(!oyster_dir+'starbase/spec_MV.Ia', $
	sgIa_type,sgIa_ft,sgIa_mv, $
	/col,resize=[1,2,3],ignore=['!'])
sgIa_r=poly_fit(sgIa_ft,sgIa_mv,4)
index=where(startable.class gt 0 and startable.class lt 1.15 $
		and startable.type ne 0,count)
if count gt 0 then startable[index].amv=poly(startable[index].type,sgIa_r)
;
; Uncomment next lines for plot of M_V-spectral type relationship
; !p.charsize=1.5
; plot,findgen(70),poly(findgen(70),sgIa_r),title='Super-Giants Ia',yrange=[20,-
; 	xtitle='Integer Spectral type',ytitle='Absolute magnitude'
; oplot,sgIa_ft,sgIa_mv,psym=6
;
; Super-giants Iab
sgIab_type=''
sgIab_ft=0.
sgIab_mv=0.
status=dc_read_free(!oyster_dir+'starbase/spec_MV.Iab', $
	sgIab_type,sgIab_ft,sgIab_mv, $
	/col,resize=[1,2,3],ignore=['!'])
sgIab_r=poly_fit(sgIab_ft,sgIab_mv,4)
index=where(startable.class ge 1.15 and startable.class lt 1.35 $
		and startable.type ne 0,count)
if count gt 0 then startable[index].amv=poly(startable[index].type,sgIab_r)
;
; Uncomment next lines for plot of M_V-spectral type relationship
; !p.charsize=1.5
; plot,findgen(70),poly(findgen(70),sgIab_r),title='Super-Giants Iab',yrange=[20
; 	xtitle='Integer Spectral type',ytitle='Absolute magnitude'
; oplot,sgIab_ft,sgIab_mv,psym=6
;
; Super-giants Ib
sgIb_type=''
sgIb_ft=0.
sgIb_mv=0.
status=dc_read_free(!oyster_dir+'starbase/spec_MV.Ib', $
	sgIb_type,sgIb_ft,sgIb_mv, $
	/col,resize=[1,2,3],ignore=['!'])
sgIb_r=poly_fit(sgIb_ft,sgIb_mv,4)
index=where(startable.class ge 1.35 and startable.class le 1.75 $
		and startable.type ne 0,count)
if count gt 0 then startable[index].amv=poly(startable[index].type,sgIb_r)
;
; Uncomment next lines for plot of M_V-spectral type relationship
; !p.charsize=1.5
; plot,findgen(70),poly(findgen(70),sgIb_r),title='Super-Giants Ib',yrange=[20,-
; 	xtitle='Integer Spectral type',ytitle='Absolute magnitude'
; oplot,sgIb_ft,sgIb_mv,psym=6
;
;...............................................................................
; Check for secondaries and make necessary adjustments
; Dwarfs...
index=where(startable.class ne 0 and startable.type2 ne 0 $
	and startable.class2 gt 4.5,count)
if count gt 0 then begin
	MV2=poly(startable[index].type2,d_r)
	startable[index].dmv=MV2-startable[index].amv
	startable[index].amv= $
	cmag(startable[index].amv,MV2)
endif
;
; Sub-giants...
index=where(startable.class ne 0 and startable.type2 ne 0 $
	and startable.class2 le 4.5 and startable.class2 gt 3.5,count)
if count gt 0 then begin
	MV2=poly(startable[index].type2,subg_r)
	startable[index].dmv=MV2-startable[index].amv
	startable[index].amv= $
	cmag(startable[index].amv,MV2)
endif
;
; Giants...
index=where(startable.class ne 0 and startable.type2 ne 0 $
	and startable.class2 le 3.5 and startable.class2 gt 2.5,count)
if count gt 0 then begin
	MV2=poly(startable[index].type2,g_r)
	startable[index].dmv=MV2-startable[index].amv
	startable[index].amv= $
	cmag(startable[index].amv,MV2)
endif
;
; Bright-giants...
index=where(startable.class ne 0 and startable.type2 ne 0 $
	and startable.class2 le 2.5 and startable.class2 gt 1.75,count)
if count gt 0 then begin
	MV2=poly(startable[index].type2,bg_r)
	startable[index].dmv=MV2-startable[index].amv
	startable[index].amv= $
	cmag(startable[index].amv,MV2)
endif
;
; Super-Giants...
index=where(startable.class ne 0 and startable.type2 ne 0 $
	and startable.class2 le 1.75 and startable.class2 gt 1.35,count)
if count gt 0 then begin
	MV2=poly(startable[index].type2,sgIb_r)
	startable[index].dmv=MV2-startable[index].amv
	startable[index].amv= $
	cmag(startable[index].amv,MV2)
endif
;
index=where(startable.class ne 0 and startable.type2 ne 0 $
	and startable.class2 le 1.35 and startable.class2 gt 1.15,count)
if count gt 0 then begin
	MV2=poly(startable[index].type2,sgIab_r)
	startable[index].dmv=MV2-startable[index].amv
	startable[index].amv= $
	cmag(startable[index].amv,MV2)
endif
;
index=where(startable.class ne 0 and startable.type2 ne 0 $
	and startable.class2 le 1.15 and startable.class2 gt 0,count)
if count gt 0 then begin
	MV2=poly(startable[index].type2,sgIa_r)
	startable[index].dmv=MV2-startable[index].amv
	startable[index].amv= $
	cmag(startable[index].amv,MV2)
endif
;
end
