pro analyze_vizier_sed,star,spec_class
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; For a given star, compile the SED with data from Vizier an fit a template
; to it to determine the stellar diameter and the effective stellar temperature.
;
; Must supply star ID (e.g., 'HD 27376', and nearest spectral type, e.g, 'B9V'
;
forward_function vizier_sed
;
sedd=vizier_sed(star,template,pickles=spec_class)
plot,template[*,0],template[*,1]*1e6,psym=0, $
 	xtitle='Wavelength ('+greek('mu')+'m]', $
 	ytitle='F!D'+greek('lambda')+'!N * 10!E6!N '+ $
 	'(erg cm!E-2!N s!E-1!N'+greek('mu')+'m!E-1!N)'
;
oplot,sedd[*,0],sedd[*,1]*1e6,psym=5
;
; Adjust SED in amplitude and shape for a best match to the photometry
;
end
